/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console.actions;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.internal.console.ConsoleMessages;

public class TextViewerGotoLineAction
extends TextViewerAction {
    protected int fLastLine;
    protected ITextViewer fTextViewer;

    public TextViewerGotoLineAction(ITextViewer iTextViewer) {
        super(iTextViewer, -1);
        this.fTextViewer = iTextViewer;
        this.setText(ConsoleMessages.TextViewerGotoLineAction_Go_to__Line____Ctrl_L_4);
        this.setToolTipText(ConsoleMessages.TextViewerGotoLineAction_Go_To_Line_1);
        this.setDescription(ConsoleMessages.TextViewerGotoLineAction_Go_To_Line_1);
    }

    @Override
    public void update() {
    }

    protected void gotoLine(int n) {
        IDocument iDocument = this.fTextViewer.getDocument();
        try {
            int n2 = iDocument.getLineOffset(n);
            int n3 = iDocument.getLineLength(n);
            this.fTextViewer.getTextWidget().setSelection(n2, n2 + n3);
            this.fTextViewer.revealRange(n2, n3);
        }
        catch (BadLocationException badLocationException) {
            ConsolePlugin.errorDialog(this.fTextViewer.getTextWidget().getShell(), ConsoleMessages.TextViewerGotoLineAction_Go_To_Line_1, ConsoleMessages.TextViewerGotoLineAction_Exceptions_occurred_attempt_to_go_to_line_2, badLocationException);
        }
    }

    @Override
    public void run() {
        try {
            Point point = this.fTextViewer.getTextWidget().getSelection();
            IDocument iDocument = this.fTextViewer.getDocument();
            this.fLastLine = iDocument.getLineOfOffset(iDocument.getLength()) + 1;
            int n = point == null ? 1 : this.fTextViewer.getTextWidget().getLineAtOffset(point.x) + 1;
            String string = ConsoleMessages.TextViewerGotoLineAction_Go_To_Line_1;
            String string2 = MessageFormat.format((String)ConsoleMessages.TextViewerGotoLineAction_Enter_line_number__8, (Object[])new Object[]{new Integer(this.fLastLine)});
            String string3 = Integer.toString(n);
            Shell shell = this.fTextViewer.getTextWidget().getShell();
            InputDialog inputDialog = new InputDialog(shell, string, string2, string3, (IInputValidator)new NumberValidator());
            if (inputDialog.open() == 0) {
                try {
                    int n2 = Integer.parseInt(inputDialog.getValue());
                    this.gotoLine(n2 - 1);
                }
                catch (NumberFormatException numberFormatException) {
                    ConsolePlugin.errorDialog(shell, ConsoleMessages.TextViewerGotoLineAction_Go_To_Line_1, ConsoleMessages.TextViewerGotoLineAction_Exceptions_occurred_attempt_to_go_to_line_2, numberFormatException);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            ConsolePlugin.errorDialog(this.fTextViewer.getTextWidget().getShell(), ConsoleMessages.TextViewerGotoLineAction_Go_To_Line_1, ConsoleMessages.TextViewerGotoLineAction_Exceptions_occurred_attempt_to_go_to_line_2, badLocationException);
            return;
        }
    }

    class NumberValidator
    implements IInputValidator {
        NumberValidator() {
        }

        public String isValid(String string) {
            try {
                int n = Integer.parseInt(string);
                if (n <= 0 || TextViewerGotoLineAction.this.fLastLine < n) {
                    return ConsoleMessages.TextViewerGotoLineAction_Line_number_out_of_range_1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return ConsoleMessages.TextViewerGotoLineAction_Not_a_number_2;
            }
            return null;
        }
    }
}

