/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IHyperlink2;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.ConsoleDocumentAdapter;
import org.eclipse.ui.internal.console.ConsoleHyperlinkPosition;
import org.eclipse.ui.progress.WorkbenchJob;

public class TextConsoleViewer
extends SourceViewer
implements LineStyleListener,
LineBackgroundListener,
MouseTrackListener,
MouseMoveListener,
MouseListener {
    private ConsoleDocumentAdapter documentAdapter;
    private IHyperlink hyperlink;
    private Cursor handCursor;
    private Cursor textCursor;
    private int consoleWidth = -1;
    private TextConsole console;
    private IPropertyChangeListener propertyChangeListener;
    private IDocumentListener documentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            TextConsoleViewer.this.updateLinks(documentEvent.fOffset);
        }
    };
    private Listener mouseUpListener = new Listener(){

        public void handleEvent(Event event) {
            String string;
            if (TextConsoleViewer.this.hyperlink != null && (string = TextConsoleViewer.this.getTextWidget().getSelectionText()).length() <= 0 && event.button == 1) {
                if (TextConsoleViewer.this.hyperlink instanceof IHyperlink2) {
                    ((IHyperlink2)TextConsoleViewer.this.hyperlink).linkActivated(event);
                } else {
                    TextConsoleViewer.this.hyperlink.linkActivated();
                }
            }
        }
    };
    WorkbenchJob revealJob = new WorkbenchJob("Reveal End of Document"){

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            StyledText styledText = TextConsoleViewer.this.getTextWidget();
            if (styledText != null && !styledText.isDisposed()) {
                int n = styledText.getLineCount();
                styledText.setTopIndex(n - 1);
            }
            return Status.OK_STATUS;
        }
    };
    private IPositionUpdater positionUpdater = new IPositionUpdater(){

        public void update(DocumentEvent documentEvent) {
            try {
                IDocument iDocument = TextConsoleViewer.this.getDocument();
                if (iDocument != null) {
                    Position[] positionArray = iDocument.getPositions(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY);
                    int n = 0;
                    while (n < positionArray.length) {
                        Position position = positionArray[n];
                        if (position.offset == documentEvent.fOffset && position.length <= documentEvent.fLength) {
                            position.delete();
                        }
                        if (position.isDeleted) {
                            iDocument.removePosition(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY, position);
                        }
                        ++n;
                    }
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    };

    public TextConsoleViewer(Composite composite, TextConsole textConsole) {
        super(composite, null, 768);
        this.console = textConsole;
        IDocument iDocument = textConsole.getDocument();
        this.setDocument(iDocument);
        StyledText styledText = this.getTextWidget();
        styledText.setDoubleClickEnabled(true);
        styledText.addLineStyleListener((LineStyleListener)this);
        styledText.addLineBackgroundListener((LineBackgroundListener)this);
        styledText.setEditable(true);
        this.setFont(textConsole.getFont());
        styledText.addMouseTrackListener((MouseTrackListener)this);
        styledText.addListener(4, this.mouseUpListener);
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        this.propertyChangeListener = new HyperlinkColorChangeListener();
        colorRegistry.addListener(this.propertyChangeListener);
        this.revealJob.setSystem(true);
        iDocument.addDocumentListener(this.documentListener);
        iDocument.addPositionUpdater(this.positionUpdater);
    }

    public void setTabWidth(int n) {
        StyledText styledText = this.getTextWidget();
        int n2 = styledText.getTabs();
        if (n != n2) {
            styledText.setTabs(n);
        }
    }

    public void setFont(Font font) {
        StyledText styledText = this.getTextWidget();
        Font font2 = styledText.getFont();
        if (font2 == font) {
            return;
        }
        if (font == null || !font.equals((Object)font2)) {
            styledText.setFont(font);
        }
    }

    protected void revealEndOfDocument() {
        this.revealJob.schedule(50L);
    }

    public void lineGetStyle(LineStyleEvent lineStyleEvent) {
        IDocument iDocument = this.getDocument();
        if (iDocument != null && iDocument.getLength() > 0) {
            ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
            int n = lineStyleEvent.lineOffset;
            int n2 = lineStyleEvent.lineText.length();
            StyleRange[] styleRangeArray = ((IConsoleDocumentPartitioner)iDocument.getDocumentPartitioner()).getStyleRanges(lineStyleEvent.lineOffset, lineStyleEvent.lineText.length());
            if (styleRangeArray != null) {
                int n3 = 0;
                while (n3 < styleRangeArray.length) {
                    arrayList.add(styleRangeArray[n3]);
                    ++n3;
                }
            } else {
                arrayList.add(new StyleRange(n, n2, null, null));
            }
            try {
                Position[] positionArray = this.getDocument().getPositions(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY);
                Position[] positionArray2 = this.findPosition(n, n2, positionArray);
                Color color = JFaceColors.getHyperlinkText((Display)Display.getCurrent());
                if (positionArray2 != null) {
                    int n4 = 0;
                    while (n4 < positionArray2.length) {
                        Position position = positionArray2[n4];
                        StyleRange styleRange = new StyleRange(position.offset, position.length, color, null);
                        styleRange.underline = true;
                        this.override(arrayList, styleRange);
                        ++n4;
                    }
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            if (arrayList.size() > 0) {
                lineStyleEvent.styles = arrayList.toArray(new StyleRange[arrayList.size()]);
            }
        }
    }

    private void override(List list, StyleRange styleRange) {
        if (list.isEmpty()) {
            list.add(styleRange);
            return;
        }
        int n = styleRange.start;
        int n2 = n + styleRange.length;
        int n3 = 0;
        while (n3 < list.size()) {
            StyleRange styleRange2 = (StyleRange)list.get(n3);
            int n4 = styleRange2.start + styleRange2.length;
            if (n2 > styleRange2.start && n < n4) {
                if (n < styleRange2.start && n2 > styleRange2.start) {
                    n = styleRange2.start;
                }
                if (n >= styleRange2.start && n2 <= n4) {
                    styleRange2.length = n - styleRange2.start;
                    list.add(++n3, styleRange);
                    if (n2 != n4) {
                        list.add(++n3, new StyleRange(n2, n4 - n2 - 1, styleRange2.foreground, styleRange2.background));
                    }
                    return;
                }
                if (n >= styleRange2.start && n < n4) {
                    styleRange2.length = n - styleRange2.start;
                    list.add(++n3, styleRange);
                } else if (n2 >= n4) {
                    list.remove(n3);
                } else {
                    list.add(++n3, new StyleRange(n2 + 1, n4 - n2 + 1, styleRange2.foreground, styleRange2.background));
                }
            }
            ++n3;
        }
    }

    private Position[] findPosition(int n, int n2, Position[] positionArray) {
        if (positionArray.length == 0) {
            return null;
        }
        int n3 = n + n2;
        int n4 = 0;
        int n5 = positionArray.length - 1;
        int n6 = 0;
        Position position = null;
        while (n4 < n5) {
            n6 = (n4 + n5) / 2;
            position = positionArray[n6];
            if (n3 < position.getOffset()) {
                if (n4 == n6) {
                    n5 = n4;
                    continue;
                }
                n5 = n6 - 1;
                continue;
            }
            if (n > position.getOffset() + position.getLength() - 1) {
                if (n5 == n6) {
                    n4 = n5;
                    continue;
                }
                n4 = n6 + 1;
                continue;
            }
            n4 = n5 = n6;
        }
        ArrayList<Position> arrayList = new ArrayList<Position>();
        int n7 = n4 - 1;
        if (n7 >= 0) {
            position = positionArray[n7];
            while (n7 >= 0 && position.getOffset() + position.getLength() > n) {
                if (--n7 <= 0) continue;
                position = positionArray[n7];
            }
        }
        position = positionArray[++n7];
        while (n7 < positionArray.length && position.getOffset() < n3) {
            arrayList.add(position);
            if (++n7 >= positionArray.length) continue;
            position = positionArray[n7];
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new Position[arrayList.size()]);
    }

    public void lineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
        lineBackgroundEvent.lineBackground = null;
    }

    protected Cursor getHandCursor() {
        if (this.handCursor == null) {
            this.handCursor = new Cursor((Device)ConsolePlugin.getStandardDisplay(), 21);
        }
        return this.handCursor;
    }

    protected Cursor getTextCursor() {
        if (this.textCursor == null) {
            this.textCursor = new Cursor((Device)ConsolePlugin.getStandardDisplay(), 19);
        }
        return this.textCursor;
    }

    protected void linkEntered(IHyperlink iHyperlink) {
        StyledText styledText = this.getTextWidget();
        if (this.hyperlink != null) {
            this.linkExited(this.hyperlink);
        }
        this.hyperlink = iHyperlink;
        this.hyperlink.linkEntered();
        styledText.setCursor(this.getHandCursor());
        styledText.redraw();
        styledText.addMouseListener((MouseListener)this);
    }

    protected void linkExited(IHyperlink iHyperlink) {
        iHyperlink.linkExited();
        this.hyperlink = null;
        StyledText styledText = this.getTextWidget();
        styledText.setCursor(this.getTextCursor());
        styledText.redraw();
        styledText.removeMouseListener((MouseListener)this);
    }

    public void mouseEnter(MouseEvent mouseEvent) {
        this.getTextWidget().addMouseMoveListener((MouseMoveListener)this);
    }

    public void mouseExit(MouseEvent mouseEvent) {
        this.getTextWidget().removeMouseMoveListener((MouseMoveListener)this);
        if (this.hyperlink != null) {
            this.linkExited(this.hyperlink);
        }
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }

    public void mouseMove(MouseEvent mouseEvent) {
        int n = -1;
        try {
            Point point = new Point(mouseEvent.x, mouseEvent.y);
            n = this.getTextWidget().getOffsetAtLocation(point);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.updateLinks(n);
    }

    protected void updateLinks(int n) {
        IHyperlink iHyperlink;
        if (n >= 0 && (iHyperlink = this.getHyperlink(n)) != null) {
            if (iHyperlink.equals(this.hyperlink)) {
                return;
            }
            this.linkEntered(iHyperlink);
            return;
        }
        if (this.hyperlink != null) {
            this.linkExited(this.hyperlink);
        }
    }

    public IHyperlink getHyperlink() {
        return this.hyperlink;
    }

    public IHyperlink getHyperlink(int n) {
        if (n >= 0 && this.console != null) {
            return this.console.getHyperlink(n);
        }
        return null;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    protected IDocumentAdapter createDocumentAdapter() {
        if (this.documentAdapter == null) {
            this.consoleWidth = -1;
            this.documentAdapter = new ConsoleDocumentAdapter(-1);
        }
        return this.documentAdapter;
    }

    public void setConsoleWidth(int n) {
        if (this.consoleWidth != n) {
            this.consoleWidth = n;
            ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TextConsoleViewer.this.documentAdapter != null) {
                        TextConsoleViewer.this.documentAdapter.setWidth(TextConsoleViewer.this.consoleWidth);
                    }
                }
            });
        }
    }

    protected void handleDispose() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            iDocument.removeDocumentListener(this.documentListener);
            iDocument.removePositionUpdater(this.positionUpdater);
        }
        StyledText styledText = this.getTextWidget();
        styledText.removeLineStyleListener((LineStyleListener)this);
        styledText.removeLineBackgroundListener((LineBackgroundListener)this);
        styledText.removeMouseTrackListener((MouseTrackListener)this);
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        this.handCursor = null;
        if (this.textCursor != null) {
            this.textCursor.dispose();
        }
        this.textCursor = null;
        this.hyperlink = null;
        this.console = null;
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        colorRegistry.removeListener(this.propertyChangeListener);
        super.handleDispose();
    }

    protected void updateTextListeners(TextViewer.WidgetCommand widgetCommand) {
        super.updateTextListeners(widgetCommand);
        widgetCommand.preservedText = null;
        widgetCommand.event = null;
        widgetCommand.text = null;
    }

    protected void internalRevealRange(int n, int n2) {
        StyledText styledText = this.getTextWidget();
        int n3 = this.documentAdapter.getLineAtOffset(n);
        int n4 = this.documentAdapter.getLineAtOffset(n2);
        int n5 = styledText.getTopIndex();
        if (n5 > -1) {
            IRegion iRegion;
            int n6;
            int n7 = this.getVisibleLinesInViewport();
            int n8 = n5 + n7;
            int n9 = 2;
            if (n3 < n5 + n9 || n3 > n8 - n9 || n4 < n5 + n9 || n4 > n8 - n9) {
                n6 = Math.max(0, n7 - (n4 - n3));
                styledText.setTopIndex(n3 - n6 / 3);
                this.updateViewportListeners(6);
            }
            if (n4 < n3) {
                n4 += n3;
                n3 = n4 - n3;
                n4 -= n3;
            }
            n6 = -1;
            int n10 = -1;
            if (n4 > n3) {
                iRegion = this.getExtent(n, n);
                n10 = n6 = iRegion.getOffset() + styledText.getHorizontalPixel();
            } else {
                iRegion = this.getExtent(n, n2);
                n6 = iRegion.getOffset() + styledText.getHorizontalPixel();
                n10 = n6 + iRegion.getLength();
            }
            int n11 = styledText.getHorizontalPixel();
            int n12 = n11 + styledText.getClientArea().width;
            if (n6 < n11 || n12 < n10) {
                n9 = 10;
                int n13 = n11;
                int n14 = n12 - n11;
                int n15 = n10 - n6;
                n13 = n6 < n11 ? n6 : (n15 + n9 < n14 ? n10 + n9 - n14 : n6);
                float f = (float)n13 / (float)this.getAverageCharWidth();
                styledText.setHorizontalIndex(Math.round(f));
            }
        }
    }

    class HyperlinkColorChangeListener
    implements IPropertyChangeListener {
        HyperlinkColorChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("ACTIVE_HYPERLINK_COLOR") || propertyChangeEvent.getProperty().equals("HYPERLINK_COLOR")) {
                TextConsoleViewer.this.getTextWidget().redraw();
            }
        }
    }
}

