/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsoleResourceBundleMessages;
import org.eclipse.ui.internal.console.FollowHyperlinkAction;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class TextConsolePage
implements IPageBookViewPage,
IPropertyChangeListener,
IAdaptable {
    private IPageSite fSite;
    private TextConsole fConsole;
    private IConsoleView fConsoleView;
    private TextConsoleViewer fViewer;
    private MenuManager fMenuManager;
    protected Map fGlobalActions = new HashMap();
    protected ArrayList fSelectionActions = new ArrayList();
    protected ClearOutputAction fClearOutputAction;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            TextConsolePage.this.updateSelectionDependentActions();
        }
    };
    private ITextListener textListener = new ITextListener(){

        public void textChanged(TextEvent textEvent) {
            IDocument iDocument;
            IUpdate iUpdate = (IUpdate)TextConsolePage.this.fGlobalActions.get(ActionFactory.FIND.getId());
            if (iUpdate != null) {
                iUpdate.update();
            }
            if (TextConsolePage.this.fClearOutputAction != null && (iDocument = TextConsolePage.this.fViewer.getDocument()) != null) {
                TextConsolePage.this.fClearOutputAction.setEnabled(iDocument.getLength() > 0);
            }
        }
    };

    public TextConsolePage(TextConsole textConsole, IConsoleView iConsoleView) {
        this.fConsole = textConsole;
        this.fConsoleView = iConsoleView;
    }

    protected TextConsoleViewer createViewer(Composite composite) {
        return new TextConsoleViewer(composite, this.fConsole);
    }

    public IPageSite getSite() {
        return this.fSite;
    }

    public void init(IPageSite iPageSite) throws PartInitException {
        this.fSite = iPageSite;
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    public void createControl(Composite composite) {
        this.fViewer = this.createViewer(composite);
        this.fViewer.setConsoleWidth(this.fConsole.getConsoleWidth());
        this.fViewer.setTabWidth(this.fConsole.getTabWidth());
        this.fConsole.addPropertyChangeListener(this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        String string = "#ContextMenu";
        if (this.getConsole().getType() != null) {
            string = String.valueOf(this.getConsole().getType()) + "." + string;
        }
        this.fMenuManager = new MenuManager("#ContextMenu", string);
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                TextConsolePage.this.contextMenuAboutToShow(iMenuManager);
            }
        });
        Menu menu = this.fMenuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.createActions();
        this.configureToolBar(this.getSite().getActionBars().getToolBarManager());
        this.getSite().registerContextMenu(string, this.fMenuManager, (ISelectionProvider)this.fViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        this.fViewer.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        this.fViewer.addTextListener(this.textListener);
    }

    public void dispose() {
        this.fConsole.removePropertyChangeListener(this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        if (this.fMenuManager != null) {
            this.fMenuManager.dispose();
        }
        this.fClearOutputAction = null;
        this.fSelectionActions.clear();
        this.fGlobalActions.clear();
        this.fViewer.getSelectionProvider().removeSelectionChangedListener(this.selectionChangedListener);
        this.fViewer.removeTextListener(this.textListener);
        this.fViewer = null;
    }

    public Control getControl() {
        return this.fViewer != null ? this.fViewer.getControl() : null;
    }

    public void setActionBars(IActionBars iActionBars) {
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.getTextWidget().setFocus();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fViewer != null) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getProperty();
            if (object.equals(this.fConsole) && IConsoleConstants.P_FONT.equals(string)) {
                this.fViewer.setFont(this.fConsole.getFont());
            } else if (IConsoleConstants.P_FONT_STYLE.equals(string)) {
                this.fViewer.getTextWidget().redraw();
            } else if (string.equals(IConsoleConstants.P_STREAM_COLOR)) {
                this.fViewer.getTextWidget().redraw();
            } else if (object.equals(this.fConsole) && string.equals(IConsoleConstants.P_TAB_SIZE)) {
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.fViewer.setTabWidth(n);
            } else if (object.equals(this.fConsole) && string.equals(IConsoleConstants.P_CONSOLE_WIDTH)) {
                this.fViewer.setConsoleWidth(this.fConsole.getConsoleWidth());
            } else if (IConsoleConstants.P_BACKGROUND_COLOR.equals(string)) {
                this.fViewer.getTextWidget().setBackground(this.fConsole.getBackground());
            }
        }
    }

    protected void createActions() {
        IActionBars iActionBars = this.getSite().getActionBars();
        TextViewerAction textViewerAction = new TextViewerAction((ITextViewer)this.fViewer, 7);
        textViewerAction.configureAction(ConsoleMessages.TextConsolePage_SelectAllText, ConsoleMessages.TextConsolePage_SelectAllDescrip, ConsoleMessages.TextConsolePage_SelectAllDescrip);
        textViewerAction.setActionDefinitionId(ActionFactory.SELECT_ALL.getCommandId());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textViewerAction, IConsoleHelpContextIds.CONSOLE_SELECT_ALL_ACTION);
        this.setGlobalAction(iActionBars, ActionFactory.SELECT_ALL.getId(), (IAction)textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fViewer, 3);
        textViewerAction.configureAction(ConsoleMessages.TextConsolePage_CutText, ConsoleMessages.TextConsolePage_CutDescrip, ConsoleMessages.TextConsolePage_CutDescrip);
        textViewerAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        textViewerAction.setActionDefinitionId(ActionFactory.CUT.getCommandId());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textViewerAction, IConsoleHelpContextIds.CONSOLE_CUT_ACTION);
        this.setGlobalAction(iActionBars, ActionFactory.CUT.getId(), (IAction)textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fViewer, 4);
        textViewerAction.configureAction(ConsoleMessages.TextConsolePage_CopyText, ConsoleMessages.TextConsolePage_CopyDescrip, ConsoleMessages.TextConsolePage_CopyDescrip);
        textViewerAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        textViewerAction.setActionDefinitionId(ActionFactory.COPY.getCommandId());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textViewerAction, IConsoleHelpContextIds.CONSOLE_COPY_ACTION);
        this.setGlobalAction(iActionBars, ActionFactory.COPY.getId(), (IAction)textViewerAction);
        textViewerAction = new TextViewerAction((ITextViewer)this.fViewer, 5);
        textViewerAction.configureAction(ConsoleMessages.TextConsolePage_PasteText, ConsoleMessages.TextConsolePage_PasteDescrip, ConsoleMessages.TextConsolePage_PasteDescrip);
        textViewerAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        textViewerAction.setActionDefinitionId(ActionFactory.PASTE.getCommandId());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textViewerAction, IConsoleHelpContextIds.CONSOLE_PASTE_ACTION);
        this.setGlobalAction(iActionBars, ActionFactory.PASTE.getId(), (IAction)textViewerAction);
        this.fClearOutputAction = new ClearOutputAction(this.fConsole);
        ResourceBundle resourceBundle = ConsoleResourceBundleMessages.getBundle();
        FindReplaceAction findReplaceAction = new FindReplaceAction(resourceBundle, "find_replace_action_", (IWorkbenchPart)this.fConsoleView);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)findReplaceAction, IConsoleHelpContextIds.CONSOLE_FIND_REPLACE_ACTION);
        this.setGlobalAction(iActionBars, ActionFactory.FIND.getId(), (IAction)findReplaceAction);
        this.fSelectionActions.add(ActionFactory.CUT.getId());
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.PASTE.getId());
        this.fSelectionActions.add(ActionFactory.FIND.getId());
        iActionBars.updateActionBars();
    }

    protected void setGlobalAction(IActionBars iActionBars, String string, IAction iAction) {
        this.fGlobalActions.put(string, iAction);
        iActionBars.setGlobalActionHandler(string, iAction);
    }

    public Object getAdapter(Class clazz) {
        if (IFindReplaceTarget.class.equals((Object)clazz)) {
            return this.fViewer.getFindReplaceTarget();
        }
        if (Widget.class.equals((Object)clazz)) {
            return this.fViewer.getTextWidget();
        }
        return null;
    }

    protected IConsoleView getConsoleView() {
        return this.fConsoleView;
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }

    protected void updateAction(String string) {
        IAction iAction = (IAction)this.fGlobalActions.get(string);
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    protected void contextMenuAboutToShow(IMenuManager iMenuManager) {
        IDocument iDocument = this.fViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        iMenuManager.add((IAction)this.fGlobalActions.get(ActionFactory.CUT.getId()));
        iMenuManager.add((IAction)this.fGlobalActions.get(ActionFactory.COPY.getId()));
        iMenuManager.add((IAction)this.fGlobalActions.get(ActionFactory.PASTE.getId()));
        iMenuManager.add((IAction)this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId()));
        iMenuManager.add((IContributionItem)new Separator("FIND"));
        iMenuManager.add((IAction)this.fGlobalActions.get(ActionFactory.FIND.getId()));
        iMenuManager.add((IAction)new FollowHyperlinkAction(this.fViewer));
        iMenuManager.add((IAction)this.fClearOutputAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.appendToGroup("outputGroup", (IAction)this.fClearOutputAction);
    }

    public TextConsoleViewer getViewer() {
        return this.fViewer;
    }

    public void setViewer(TextConsoleViewer textConsoleViewer) {
        this.fViewer = textConsoleViewer;
    }
}

