/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.util.HashMap;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.internal.console.ConsoleDocument;
import org.eclipse.ui.internal.console.ConsoleHyperlinkPosition;
import org.eclipse.ui.internal.console.ConsolePatternMatcher;
import org.eclipse.ui.part.IPageBookViewPage;

public abstract class TextConsole
extends AbstractConsole {
    private int fConsoleWidth;
    private int fTabWidth;
    private Font fFont;
    private Color fBackground;
    private ConsolePatternMatcher fPatternMatcher;
    private ConsoleDocument fDocument;
    private boolean fPartitionerFinished = false;
    private boolean fMatcherFinished = false;
    private boolean fCompleteFired = false;
    private HashMap fAttributes = new HashMap();
    private IConsoleManager fConsoleManager = ConsolePlugin.getDefault().getConsoleManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose() {
        super.dispose();
        this.fFont = null;
        HashMap hashMap = this.fAttributes;
        synchronized (hashMap) {
            this.fAttributes.clear();
        }
    }

    public TextConsole(String string, String string2, ImageDescriptor imageDescriptor, boolean bl) {
        super(string, string2, imageDescriptor, bl);
        this.fDocument = new ConsoleDocument();
        this.fDocument.addPositionCategory(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY);
        this.fPatternMatcher = new ConsolePatternMatcher(this);
        this.fDocument.addDocumentListener(this.fPatternMatcher);
        this.fTabWidth = 8;
    }

    @Override
    public IPageBookViewPage createPage(IConsoleView iConsoleView) {
        return new TextConsolePage(this, iConsoleView);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public int getConsoleWidth() {
        return this.fConsoleWidth;
    }

    public void setConsoleWidth(int n) {
        if (this.fConsoleWidth != n) {
            int n2 = this.fConsoleWidth;
            this.fConsoleWidth = n;
            this.firePropertyChange(this, IConsoleConstants.P_CONSOLE_WIDTH, new Integer(n2), new Integer(this.fConsoleWidth));
        }
    }

    public void setTabWidth(int n) {
        if (this.fTabWidth != n) {
            final int n2 = this.fTabWidth;
            this.fTabWidth = n;
            ConsolePlugin.getStandardDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TextConsole.this.firePropertyChange(TextConsole.this, IConsoleConstants.P_TAB_SIZE, new Integer(n2), new Integer(TextConsole.this.fTabWidth));
                }
            });
        }
    }

    public int getTabWidth() {
        return this.fTabWidth;
    }

    public Font getFont() {
        if (this.fFont == null) {
            this.fFont = this.getDefaultFont();
        }
        return this.fFont;
    }

    private Font getDefaultFont() {
        return JFaceResources.getFont((String)"org.eclipse.jface.textfont");
    }

    public void setFont(Font font) {
        this.getFont();
        if (font == null) {
            font = this.getDefaultFont();
        }
        if (!this.fFont.equals((Object)font)) {
            Font font2 = this.fFont;
            this.fFont = font;
            this.firePropertyChange(this, IConsoleConstants.P_FONT, font2, this.fFont);
        }
    }

    public void setBackgrond(Color color) {
        this.setBackground(color);
    }

    public void setBackground(Color color) {
        if (this.fBackground == null ? color == null : this.fBackground.equals((Object)color)) {
            return;
        }
        Color color2 = this.fBackground;
        this.fBackground = color;
        this.firePropertyChange(this, IConsoleConstants.P_BACKGROUND_COLOR, color2, this.fBackground);
    }

    public Color getBackground() {
        return this.fBackground;
    }

    public void clearConsole() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            iDocument.set("");
        }
    }

    protected abstract IConsoleDocumentPartitioner getPartitioner();

    public IHyperlink[] getHyperlinks() {
        try {
            Position[] positionArray = this.getDocument().getPositions(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY);
            IHyperlink[] iHyperlinkArray = new IHyperlink[positionArray.length];
            int n = 0;
            while (n < positionArray.length) {
                ConsoleHyperlinkPosition consoleHyperlinkPosition = (ConsoleHyperlinkPosition)positionArray[n];
                iHyperlinkArray[n] = consoleHyperlinkPosition.getHyperLink();
                ++n;
            }
            return iHyperlinkArray;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            return new IHyperlink[0];
        }
    }

    public IHyperlink getHyperlink(int n) {
        try {
            Position[] positionArray;
            Position position;
            IDocument iDocument = this.getDocument();
            if (iDocument != null && (position = this.findPosition(n, positionArray = iDocument.getPositions(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY))) instanceof ConsoleHyperlinkPosition) {
                return ((ConsoleHyperlinkPosition)position).getHyperLink();
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return null;
    }

    private Position findPosition(int n, Position[] positionArray) {
        if (positionArray.length == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = positionArray.length - 1;
        int n4 = 0;
        Position position = null;
        while (n2 < n3) {
            n4 = (n2 + n3) / 2;
            position = positionArray[n4];
            if (n < position.getOffset()) {
                if (n2 == n4) {
                    n3 = n2;
                    continue;
                }
                n3 = n4 - 1;
                continue;
            }
            if (n > position.getOffset() + position.getLength() - 1) {
                if (n3 == n4) {
                    n2 = n3;
                    continue;
                }
                n2 = n4 + 1;
                continue;
            }
            n2 = n3 = n4;
        }
        position = positionArray[n2];
        if (n >= position.getOffset() && n < position.getOffset() + position.getLength()) {
            return position;
        }
        return null;
    }

    public void addPatternMatchListener(IPatternMatchListener iPatternMatchListener) {
        this.fPatternMatcher.addPatternMatchListener(iPatternMatchListener);
    }

    public void removePatternMatchListener(IPatternMatchListener iPatternMatchListener) {
        this.fPatternMatcher.removePatternMatchListener(iPatternMatchListener);
    }

    public ISchedulingRule getSchedulingRule() {
        return new MatcherSchedulingRule();
    }

    public void partitionerFinished() {
        this.fPatternMatcher.forceFinalMatching();
        this.fPartitionerFinished = true;
        this.checkFinished();
    }

    public void matcherFinished() {
        this.fMatcherFinished = true;
        this.fDocument.removeDocumentListener(this.fPatternMatcher);
        this.checkFinished();
    }

    private synchronized void checkFinished() {
        if (!this.fCompleteFired && this.fPartitionerFinished && this.fMatcherFinished) {
            this.fCompleteFired = true;
            this.firePropertyChange(this, IConsoleConstants.P_CONSOLE_OUTPUT_COMPLETE, null, null);
        }
    }

    public void addHyperlink(IHyperlink iHyperlink, int n, int n2) throws BadLocationException {
        IDocument iDocument = this.getDocument();
        ConsoleHyperlinkPosition consoleHyperlinkPosition = new ConsoleHyperlinkPosition(iHyperlink, n, n2);
        try {
            iDocument.addPosition(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY, (Position)consoleHyperlinkPosition);
            this.fConsoleManager.refresh(this);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            ConsolePlugin.log(badPositionCategoryException);
        }
    }

    public IRegion getRegion(IHyperlink iHyperlink) {
        try {
            IDocument iDocument = this.getDocument();
            if (iDocument != null) {
                Position[] positionArray = iDocument.getPositions(ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY);
                int n = 0;
                while (n < positionArray.length) {
                    ConsoleHyperlinkPosition consoleHyperlinkPosition = (ConsoleHyperlinkPosition)positionArray[n];
                    if (consoleHyperlinkPosition.getHyperLink().equals(iHyperlink)) {
                        return new Region(consoleHyperlinkPosition.getOffset(), consoleHyperlinkPosition.getLength());
                    }
                    ++n;
                }
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String string) {
        HashMap hashMap = this.fAttributes;
        synchronized (hashMap) {
            return this.fAttributes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        HashMap hashMap = this.fAttributes;
        synchronized (hashMap) {
            this.fAttributes.put(string, object);
        }
    }

    private class MatcherSchedulingRule
    implements ISchedulingRule {
        private MatcherSchedulingRule() {
        }

        public boolean contains(ISchedulingRule iSchedulingRule) {
            return iSchedulingRule == this;
        }

        public boolean isConflicting(ISchedulingRule iSchedulingRule) {
            if (this.contains(iSchedulingRule)) {
                return true;
            }
            if (iSchedulingRule != this && iSchedulingRule instanceof MatcherSchedulingRule) {
                return ((MatcherSchedulingRule)iSchedulingRule).getConsole() == TextConsole.this;
            }
            return false;
        }

        public TextConsole getConsole() {
            return TextConsole.this;
        }
    }
}

