/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.internal.console.IOConsolePartitioner;

public class IOConsoleOutputStream
extends OutputStream {
    private boolean closed = false;
    private IOConsolePartitioner partitioner;
    private IOConsole console;
    private boolean activateOnWrite = false;
    private Color color;
    private int fontStyle;
    private String fEncoding;
    private String fDefaultEncoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
    private boolean fNeedsEncoding = false;
    private boolean prependCR;

    IOConsoleOutputStream(IOConsole iOConsole) {
        this.console = iOConsole;
        this.partitioner = (IOConsolePartitioner)iOConsole.getPartitioner();
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n) {
        if (n != this.fontStyle) {
            int n2 = this.fontStyle;
            this.fontStyle = n;
            this.console.firePropertyChange(this, IConsoleConstants.P_FONT_STYLE, new Integer(n2), new Integer(this.fontStyle));
        }
    }

    public boolean isActivateOnWrite() {
        return this.activateOnWrite;
    }

    public void setActivateOnWrite(boolean bl) {
        this.activateOnWrite = bl;
    }

    public void setColor(Color color) {
        Color color2 = this.color;
        if (color2 == null || !color2.equals((Object)color)) {
            this.color = color;
            this.console.firePropertyChange(this, IConsoleConstants.P_STREAM_COLOR, color2, color);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
        if (this.prependCR) {
            this.prependCR = false;
            this.notifyParitioner("\r");
        }
        this.console.streamClosed(this);
        this.closed = true;
        this.partitioner = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Output Stream is closed");
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.fNeedsEncoding) {
            this.encodedWrite(new String(byArray, n, n2, this.fEncoding));
        } else {
            this.encodedWrite(new String(byArray, n, n2));
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void write(String string) throws IOException {
        if (this.fNeedsEncoding) {
            byte[] byArray = string.getBytes();
            string = new String(byArray, this.fEncoding);
        }
        this.encodedWrite(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodedWrite(String string) throws IOException {
        IOConsoleOutputStream iOConsoleOutputStream = this;
        synchronized (iOConsoleOutputStream) {
            if (this.closed) {
                throw new IOException("Output Stream is closed");
            }
            if (this.prependCR) {
                string = "\r" + string;
                this.prependCR = false;
            }
            if (string.endsWith("\r")) {
                this.prependCR = true;
                string = new String(string.substring(0, string.length() - 1));
            }
        }
        this.notifyParitioner(string);
    }

    private void notifyParitioner(String string) throws IOException {
        try {
            this.partitioner.streamAppended(this, string);
            if (this.activateOnWrite) {
                this.console.activate();
            } else {
                ConsolePlugin.getDefault().getConsoleManager().warnOfContentChange(this.console);
            }
        }
        catch (IOException iOException) {
            if (!this.closed) {
                this.close();
            }
            throw iOException;
        }
    }

    public void setEncoding(String string) {
        this.fEncoding = string;
        this.fNeedsEncoding = this.fEncoding != null && !this.fEncoding.equals(this.fDefaultEncoding);
    }
}

