/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.IOConsole;

public class IOConsoleInputStream
extends InputStream {
    private byte[] input = new byte[100];
    private int inPointer = 0;
    private int outPointer = 0;
    private int size = 0;
    private boolean eofSent = false;
    private boolean closed = false;
    private IOConsole console;
    private Color color;
    private int fontStyle = 0;

    IOConsoleInputStream(IOConsole iOConsole) {
        this.console = iOConsole;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        this.waitForData();
        if (this.available() == -1) {
            return -1;
        }
        int n3 = Math.min(n2, this.size);
        if (this.input.length - this.outPointer > n3) {
            System.arraycopy(this.input, this.outPointer, byArray, n, n3);
            this.outPointer += n3;
            this.size -= n3;
        } else {
            int n4 = this.input.length - this.outPointer;
            System.arraycopy(this.input, this.outPointer, byArray, n, n4);
            System.arraycopy(this.input, 0, byArray, n + n4, n3 - n4);
            this.outPointer = n3 - n4;
            this.size -= n3;
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized int read() throws IOException {
        this.waitForData();
        if (this.available() == -1) {
            return -1;
        }
        byte by = this.input[this.outPointer];
        ++this.outPointer;
        if (this.outPointer == this.input.length) {
            this.outPointer = 0;
        }
        --this.size;
        return by;
    }

    private void waitForData() {
        while (this.size == 0 && !this.closed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void appendData(String string) {
        byte[] byArray;
        String string2 = this.console.getEncoding();
        if (string2 != null) {
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
        } else {
            byArray = string.getBytes();
        }
        while (this.input.length - this.size < byArray.length) {
            this.growArray();
        }
        if (this.size == 0) {
            System.arraycopy(byArray, 0, this.input, 0, byArray.length);
            this.inPointer = byArray.length;
            this.size = byArray.length;
            this.outPointer = 0;
        } else if (this.inPointer < this.outPointer || this.input.length - this.inPointer > byArray.length) {
            System.arraycopy(byArray, 0, this.input, this.inPointer, byArray.length);
            this.inPointer += byArray.length;
            this.size += byArray.length;
        } else {
            System.arraycopy(byArray, 0, this.input, this.inPointer, this.input.length - this.inPointer);
            System.arraycopy(byArray, this.input.length - this.inPointer, this.input, 0, byArray.length - (this.input.length - this.inPointer));
            this.inPointer = byArray.length - (this.input.length - this.inPointer);
            this.size += byArray.length;
        }
        if (this.inPointer == this.input.length) {
            this.inPointer = 0;
        }
        this.notifyAll();
    }

    private void growArray() {
        byte[] byArray = new byte[this.input.length + 1024];
        if (this.outPointer < this.inPointer) {
            System.arraycopy(this.input, this.outPointer, byArray, 0, this.size);
        } else {
            System.arraycopy(this.input, this.outPointer, byArray, 0, this.input.length - this.outPointer);
            System.arraycopy(this.input, 0, byArray, this.input.length - this.outPointer, this.inPointer);
        }
        this.outPointer = 0;
        this.inPointer = this.size;
        this.input = byArray;
        byArray = null;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int n) {
        if (n != this.fontStyle) {
            int n2 = this.fontStyle;
            this.fontStyle = n;
            this.console.firePropertyChange(this, IConsoleConstants.P_FONT_STYLE, new Integer(n2), new Integer(this.fontStyle));
        }
    }

    public void setColor(Color color) {
        Color color2 = this.color;
        if (color2 == null || !color2.equals((Object)color)) {
            this.color = color;
            this.console.firePropertyChange(this, IConsoleConstants.P_STREAM_COLOR, color2, color);
        }
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public int available() throws IOException {
        if (this.closed && this.eofSent) {
            throw new IOException("Input Stream Closed");
        }
        if (this.size == 0) {
            if (!this.eofSent) {
                this.eofSent = true;
                return -1;
            }
            throw new IOException("Input Stream Closed");
        }
        return this.size;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            throw new IOException("Input Stream Closed");
        }
        this.closed = true;
        this.notifyAll();
        this.console.streamClosed(this);
    }
}

