/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.IOConsolePartitioner;
import org.eclipse.ui.part.IPageBookViewPage;

public class IOConsole
extends TextConsole {
    private IOConsolePartitioner partitioner;
    private IOConsoleInputStream inputStream;
    private List openStreams;
    private String fEncoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();

    public IOConsole(String string, String string2, ImageDescriptor imageDescriptor, boolean bl) {
        this(string, string2, imageDescriptor, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOConsole(String string, String string2, ImageDescriptor imageDescriptor, String string3, boolean bl) {
        super(string, string2, imageDescriptor, bl);
        if (string3 != null) {
            this.fEncoding = string3;
        }
        this.openStreams = new ArrayList();
        this.inputStream = new IOConsoleInputStream(this);
        List list = this.openStreams;
        synchronized (list) {
            this.openStreams.add(this.inputStream);
        }
        this.partitioner = new IOConsolePartitioner(this.inputStream, this);
        this.partitioner.connect(this.getDocument());
    }

    public IOConsole(String string, String string2, ImageDescriptor imageDescriptor) {
        this(string, string2, imageDescriptor, true);
    }

    public IOConsole(String string, ImageDescriptor imageDescriptor) {
        this(string, null, imageDescriptor);
    }

    @Override
    public IPageBookViewPage createPage(IConsoleView iConsoleView) {
        return new IOConsolePage(this, iConsoleView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOConsoleOutputStream newOutputStream() {
        IOConsoleOutputStream iOConsoleOutputStream = new IOConsoleOutputStream(this);
        iOConsoleOutputStream.setEncoding(this.fEncoding);
        List list = this.openStreams;
        synchronized (list) {
            this.openStreams.add(iOConsoleOutputStream);
        }
        return iOConsoleOutputStream;
    }

    public IOConsoleInputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public int getHighWaterMark() {
        return this.partitioner.getHighWaterMark();
    }

    public int getLowWaterMark() {
        return this.partitioner.getLowWaterMark();
    }

    public void setWaterMarks(int n, int n2) {
        if (n >= 0 && n >= n2) {
            throw new IllegalArgumentException("High water mark must be greater than low water mark");
        }
        this.partitioner.setWaterMarks(n, n2);
    }

    private void checkFinished() {
        if (this.openStreams.isEmpty()) {
            this.partitioner.streamsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(IOConsoleOutputStream iOConsoleOutputStream) {
        List list = this.openStreams;
        synchronized (list) {
            this.openStreams.remove(iOConsoleOutputStream);
            this.checkFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(IOConsoleInputStream iOConsoleInputStream) {
        List list = this.openStreams;
        synchronized (list) {
            this.openStreams.remove(iOConsoleInputStream);
            this.checkFinished();
        }
    }

    @Override
    public void clearConsole() {
        if (this.partitioner != null) {
            this.partitioner.clearBuffer();
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.partitioner.disconnect();
        Object[] objectArray = this.openStreams.toArray();
        int n = 0;
        while (n < objectArray.length) {
            Closeable closeable;
            Object object = objectArray[n];
            if (object instanceof IOConsoleInputStream) {
                closeable = (IOConsoleInputStream)object;
                try {
                    ((IOConsoleInputStream)closeable).close();
                }
                catch (IOException iOException) {}
            } else if (object instanceof IOConsoleOutputStream) {
                closeable = (IOConsoleOutputStream)object;
                try {
                    ((IOConsoleOutputStream)closeable).close();
                }
                catch (IOException iOException) {}
            }
            ++n;
        }
        this.inputStream = null;
    }

    public String getEncoding() {
        return this.fEncoding;
    }
}

