/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.internal.console.ConsoleManager;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ConsolePlugin
extends AbstractUIPlugin {
    private IConsoleManager fConsoleManager = null;
    private static ConsolePlugin fgPlugin = null;
    private static final String PI_UI_CONSOLE = "org.eclipse.ui.console";

    public static ConsolePlugin getDefault() {
        return fgPlugin;
    }

    public ConsolePlugin() {
        fgPlugin = this;
    }

    public static String getUniqueIdentifier() {
        return PI_UI_CONSOLE;
    }

    public static void log(IStatus iStatus) {
        ConsolePlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        if (throwable instanceof CoreException) {
            ConsolePlugin.log(((CoreException)throwable).getStatus());
        } else {
            ConsolePlugin.log(ConsolePlugin.newErrorStatus("Error logged from Console plug-in: ", throwable));
        }
    }

    public static IStatus newErrorStatus(String string, Throwable throwable) {
        return new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, string, throwable);
    }

    public IConsoleManager getConsoleManager() {
        if (this.fConsoleManager == null) {
            this.fConsoleManager = new ConsoleManager();
        }
        return this.fConsoleManager;
    }

    public static Display getStandardDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static void errorDialog(Shell shell, String string, String string2, Throwable throwable) {
        IStatus iStatus;
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
            if (iStatus != null && string2.equals(iStatus.getMessage())) {
                string2 = null;
            }
        } else {
            iStatus = new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, "Error within Debug UI: ", throwable);
            ConsolePlugin.log(iStatus);
        }
        ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
    }

    public static Image getImage(String string) {
        return ConsolePluginImages.getImage(string);
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return ConsolePluginImages.getImageDescriptor(string);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        IConsole[] iConsoleArray;
        if (this.fConsoleManager != null && (iConsoleArray = this.fConsoleManager.getConsoles()) != null) {
            this.fConsoleManager.removeConsoles(iConsoleArray);
        }
        super.stop(bundleContext);
    }
}

