/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.internal.console.ConsoleMessages;

public abstract class AbstractConsole
implements IConsole {
    private ListenerList fListeners;
    private String fName = null;
    private ImageDescriptor fImageDescriptor = null;
    private String fType = null;

    public AbstractConsole(String string, ImageDescriptor imageDescriptor, boolean bl) {
        this(string, null, imageDescriptor, bl);
    }

    public AbstractConsole(String string, String string2, ImageDescriptor imageDescriptor, boolean bl) {
        this.setName(string);
        this.setType(string2);
        this.setImageDescriptor(imageDescriptor);
        if (bl) {
            ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(new Lifecycle());
        }
    }

    public AbstractConsole(String string, ImageDescriptor imageDescriptor) {
        this(string, imageDescriptor, true);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    protected void setName(String string) {
        if (!string.equals(this.fName)) {
            String string2 = this.fName;
            this.fName = string;
            this.firePropertyChange(this, "org.eclipse.jface.text", string2, string);
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.fImageDescriptor;
    }

    protected void setImageDescriptor(ImageDescriptor imageDescriptor) {
        ImageDescriptor imageDescriptor2 = this.fImageDescriptor;
        this.fImageDescriptor = imageDescriptor;
        this.firePropertyChange(this, "org.eclipse.jface.image", imageDescriptor2, imageDescriptor);
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)iPropertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)iPropertyChangeListener);
        }
    }

    public void firePropertyChange(Object object, String string, Object object2, Object object3) {
        if (this.fListeners == null) {
            return;
        }
        PropertyNotifier propertyNotifier = new PropertyNotifier();
        propertyNotifier.notify(new PropertyChangeEvent(object, string, object2, object3));
    }

    public final void initialize() {
        this.init();
    }

    protected void init() {
    }

    public final void destroy() {
        this.dispose();
    }

    protected void dispose() {
    }

    public void activate() {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView(this);
    }

    protected void setType(String string) {
        this.fType = string;
    }

    @Override
    public String getType() {
        return this.fType;
    }

    public String getHelpContextId() {
        return null;
    }

    class Lifecycle
    implements IConsoleListener {
        Lifecycle() {
        }

        @Override
        public void consolesAdded(IConsole[] iConsoleArray) {
            int n = 0;
            while (n < iConsoleArray.length) {
                IConsole iConsole = iConsoleArray[n];
                if (iConsole == AbstractConsole.this) {
                    AbstractConsole.this.initialize();
                }
                ++n;
            }
        }

        @Override
        public void consolesRemoved(IConsole[] iConsoleArray) {
            int n = 0;
            while (n < iConsoleArray.length) {
                IConsole iConsole = iConsoleArray[n];
                if (iConsole == AbstractConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener(this);
                    AbstractConsole.this.destroy();
                }
                ++n;
            }
        }
    }

    class PropertyNotifier
    implements ISafeRunnable {
        private IPropertyChangeListener fListener;
        private PropertyChangeEvent fEvent;

        PropertyNotifier() {
        }

        public void handleException(Throwable throwable) {
            Status status = new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, ConsoleMessages.AbstractConsole_0, throwable);
            ConsolePlugin.log((IStatus)status);
        }

        public void run() throws Exception {
            this.fListener.propertyChange(this.fEvent);
        }

        public void notify(PropertyChangeEvent propertyChangeEvent) {
            if (AbstractConsole.this.fListeners == null) {
                return;
            }
            this.fEvent = propertyChangeEvent;
            Object[] objectArray = AbstractConsole.this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                this.fListener = (IPropertyChangeListener)objectArray[n];
                SafeRunner.run((ISafeRunnable)this);
                ++n;
            }
            this.fListener = null;
        }
    }
}

