/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

class RevisionHoverInformationControlCreator
extends AbstractReusableInformationControlCreator {
    private static final String fgStyleSheet = "/* Font definitions */\nbody, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt {font-family: sans-serif; font-size: 9pt }\npre\t\t\t\t{ font-family: monospace; font-size: 9pt }\n\n/* Margins */\nbody\t     { overflow: auto; margin-top: 0; margin-bottom: 4; margin-left: 3; margin-right: 0 }\nh1           { margin-top: 5; margin-bottom: 1 }\t\nh2           { margin-top: 25; margin-bottom: 3 }\nh3           { margin-top: 20; margin-bottom: 3 }\nh4           { margin-top: 20; margin-bottom: 3 }\nh5           { margin-top: 0; margin-bottom: 0 }\np            { margin-top: 10px; margin-bottom: 10px }\npre\t         { margin-left: 6 }\nul\t         { margin-top: 0; margin-bottom: 10 }\nli\t         { margin-top: 0; margin-bottom: 0 } \nli p\t     { margin-top: 0; margin-bottom: 0 } \nol\t         { margin-top: 0; margin-bottom: 10 }\ndl\t         { margin-top: 0; margin-bottom: 10 }\ndt\t         { margin-top: 0; margin-bottom: 0; font-weight: bold }\ndd\t         { margin-top: 0; margin-bottom: 0 }\n\n/* Styles and colors */\na:link\t     { color: #0000FF }\na:hover\t     { color: #000080 }\na:visited    { text-decoration: underline }\nh4           { font-style: italic }\nstrong\t     { font-weight: bold }\nem\t         { font-style: italic }\nvar\t         { font-style: italic }\nth\t         { font-weight: bold }\n";
    private boolean fIsFocusable;

    public RevisionHoverInformationControlCreator(boolean bl) {
        this.fIsFocusable = bl;
    }

    public boolean canReuse(IInformationControl iInformationControl) {
        if (!super.canReuse(iInformationControl)) {
            return false;
        }
        if (iInformationControl instanceof IInformationControlExtension4) {
            ((IInformationControlExtension4)iInformationControl).setStatusText(EditorsUI.getTooltipAffordanceString());
        }
        return true;
    }

    protected IInformationControl doCreateInformationControl(Shell shell) {
        if (BrowserInformationControl.isAvailable((Composite)shell)) {
            if (this.fIsFocusable) {
                return new RevisionInformationControl(shell);
            }
            return new RevisionInformationControl(shell, EditorsUI.getTooltipAffordanceString());
        }
        if (this.fIsFocusable) {
            return new DefaultInformationControl(shell, true);
        }
        return new DefaultInformationControl(shell, EditorsUI.getTooltipAffordanceString());
    }

    private static final class RevisionInformationControl
    extends BrowserInformationControl {
        public RevisionInformationControl(Shell shell, String string) {
            super(shell, "org.eclipse.jface.dialogfont", string);
        }

        public RevisionInformationControl(Shell shell) {
            super(shell, "org.eclipse.jface.dialogfont", true);
        }

        public void setInformation(String string) {
            string = this.addCSSToHTMLFragment(string);
            super.setInformation(string);
        }

        private String addCSSToHTMLFragment(String string) {
            int n = Math.min(100, string.length());
            if (string.substring(0, n).indexOf("<html>") != -1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(512 + string.length());
            HTMLPrinter.insertPageProlog((StringBuffer)stringBuffer, (int)0, (String)RevisionHoverInformationControlCreator.fgStyleSheet);
            stringBuffer.append(string);
            HTMLPrinter.addPageEpilog((StringBuffer)stringBuffer);
            return stringBuffer.toString();
        }
    }
}

