/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ResourceMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IWorkspace fWorkspace;
    private IResource fResource;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();

    public ResourceMarkerAnnotationModel(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.fResource = iResource;
        this.fWorkspace = iResource.getWorkspace();
    }

    @Override
    protected boolean isAcceptable(IMarker iMarker) {
        return iMarker != null && this.fResource.equals((Object)iMarker.getResource());
    }

    protected void update(IMarkerDelta[] iMarkerDeltaArray) {
        if (iMarkerDeltaArray.length == 0) {
            return;
        }
        if (iMarkerDeltaArray.length == 1) {
            IMarkerDelta iMarkerDelta = iMarkerDeltaArray[0];
            switch (iMarkerDelta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(iMarkerDelta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(iMarkerDelta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(iMarkerDelta.getMarker());
                }
            }
        } else {
            this.batchedUpdate(iMarkerDeltaArray);
        }
        this.fireModelChanged();
    }

    private void batchedUpdate(IMarkerDelta[] iMarkerDeltaArray) {
        Object object;
        HashSet<IMarker> hashSet = new HashSet<IMarker>(iMarkerDeltaArray.length);
        HashSet<IMarker> hashSet2 = new HashSet<IMarker>(iMarkerDeltaArray.length);
        int n = 0;
        while (n < iMarkerDeltaArray.length) {
            object = iMarkerDeltaArray[n];
            switch (object.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(object.getMarker());
                    break;
                }
                case 2: {
                    hashSet.add(object.getMarker());
                    break;
                }
                case 4: {
                    hashSet2.add(object.getMarker());
                }
            }
            ++n;
        }
        if (hashSet2.isEmpty() && hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = this.getAnnotationIterator(false);
        while (iterator.hasNext()) {
            Position position;
            object = iterator.next();
            if (!(object instanceof MarkerAnnotation)) continue;
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)((Object)object);
            IMarker iMarker = markerAnnotation.getMarker();
            if (hashSet.remove(iMarker)) {
                this.removeAnnotation(markerAnnotation, false);
            }
            if (hashSet2.remove(iMarker) && (position = this.createPositionFromMarker(iMarker)) != null) {
                markerAnnotation.update();
                this.modifyAnnotationPosition(markerAnnotation, position, false);
            }
            if (!hashSet2.isEmpty() || !hashSet.isEmpty()) continue;
            return;
        }
        object = hashSet2.iterator();
        while (object.hasNext()) {
            this.addMarkerAnnotation((IMarker)object.next());
        }
    }

    @Override
    protected void listenToMarkerChanges(boolean bl) {
        if (bl) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    @Override
    protected void deleteMarkers(final IMarker[] iMarkerArray) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                int n = 0;
                while (n < iMarkerArray.length) {
                    iMarkerArray[n].delete();
                    ++n;
                }
            }
        }, null, 1, null);
    }

    @Override
    protected IMarker[] retrieveMarkers() throws CoreException {
        return this.fResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
    }

    protected IResource getResource() {
        return this.fResource;
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta;
            IResourceDelta iResourceDelta2 = iResourceChangeEvent.getDelta();
            if (iResourceDelta2 != null && ResourceMarkerAnnotationModel.this.fResource != null && (iResourceDelta = iResourceDelta2.findMember(ResourceMarkerAnnotationModel.this.fResource.getFullPath())) != null) {
                ResourceMarkerAnnotationModel.this.update(iResourceDelta.getMarkerDeltas());
            }
        }
    }
}

