/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class MessageRegion {
    private Text messageText;
    private Label messageImageLabel;
    private Composite messageComposite;
    private String lastMessageText = "";
    private int lastMessageType;

    public void createContents(Composite composite) {
        this.messageComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.makeColumnsEqualWidth = false;
        this.messageComposite.setLayout((Layout)gridLayout);
        this.messageImageLabel = new Label(this.messageComposite, 0);
        GridData gridData = new GridData(4);
        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
        Rectangle rectangle = image == null ? new Rectangle(0, 0, 14, 14) : image.getBounds();
        gridData.heightHint = rectangle.height + 4;
        gridData.widthHint = rectangle.width + 4;
        this.messageImageLabel.setLayoutData((Object)gridData);
        this.messageText = new Text(this.messageComposite, 0);
        this.messageText.setEditable(false);
        this.messageText.setBackground(composite.getDisplay().getSystemColor(22));
        GridData gridData2 = new GridData(772);
        this.messageText.setLayoutData((Object)gridData2);
        this.hideRegion();
    }

    public void setMessageLayoutData(Object object) {
        this.messageComposite.setLayoutData(object);
    }

    public void updateText(String string, int n) {
        Image image = null;
        boolean bl = false;
        switch (n) {
            case 0: {
                this.hideRegion();
                return;
            }
            case 1: {
                image = JFaceResources.getImage((String)"dialog_messasge_info_image");
                break;
            }
            case 2: {
                image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                break;
            }
            case 3: {
                image = JFaceResources.getImage((String)"dialog_message_error_image");
                bl = true;
            }
        }
        if (string == null) {
            this.hideRegion();
            return;
        }
        this.showRegion();
        if (string.equals(this.messageText.getText()) && image == this.messageImageLabel.getImage()) {
            return;
        }
        this.messageImageLabel.setImage(image);
        this.messageText.setText(string);
        if (bl) {
            this.setMessageColors(JFaceColors.getErrorBackground((Display)this.messageComposite.getDisplay()));
        } else {
            this.lastMessageText = string;
            this.setMessageColors(JFaceColors.getBannerBackground((Display)this.messageComposite.getDisplay()));
        }
    }

    private void showRegion() {
        this.messageComposite.setVisible(true);
    }

    private void hideRegion() {
        this.messageComposite.setVisible(false);
        this.lastMessageText = null;
        this.lastMessageType = 0;
    }

    private void setMessageColors(Color color) {
        this.messageText.setBackground(color);
        this.messageComposite.setBackground(color);
        this.messageImageLabel.setBackground(color);
    }

    public void clearErrorMessage() {
        this.updateText(this.lastMessageText, this.lastMessageType);
    }
}

