/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class MarkerUtilities {
    private static MarkerTypeHierarchy fgMarkerTypeHierarchy;

    private MarkerUtilities() {
    }

    public static int getCharEnd(IMarker iMarker) {
        return MarkerUtilities.getIntAttribute(iMarker, "charEnd", -1);
    }

    public static int getCharStart(IMarker iMarker) {
        return MarkerUtilities.getIntAttribute(iMarker, "charStart", -1);
    }

    private static int getIntAttribute(IMarker iMarker, String string, int n) {
        if (iMarker.exists()) {
            return iMarker.getAttribute(string, n);
        }
        return n;
    }

    public static int getLineNumber(IMarker iMarker) {
        return MarkerUtilities.getIntAttribute(iMarker, "lineNumber", -1);
    }

    public static int getPriority(IMarker iMarker) {
        return MarkerUtilities.getIntAttribute(iMarker, "priority", 1);
    }

    public static int getSeverity(IMarker iMarker) {
        return MarkerUtilities.getIntAttribute(iMarker, "severity", 0);
    }

    private static void handleCoreException(CoreException coreException) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog iLog = Platform.getLog((Bundle)bundle);
        iLog.log(coreException.getStatus());
    }

    public static boolean isMarkerType(IMarker iMarker, String string) {
        if (iMarker != null) {
            try {
                return iMarker.exists() && iMarker.isSubtypeOf(string);
            }
            catch (CoreException coreException) {
                MarkerUtilities.handleCoreException(coreException);
            }
        }
        return false;
    }

    public static String getMarkerType(IMarker iMarker) {
        try {
            return iMarker.getType();
        }
        catch (CoreException coreException) {
            MarkerUtilities.handleCoreException(coreException);
            return null;
        }
    }

    public static String getMessage(IMarker iMarker) {
        return iMarker.getAttribute("message", null);
    }

    public static void setCharEnd(IMarker iMarker, int n) {
        MarkerUtilities.setIntAttribute(iMarker, "charEnd", n);
    }

    public static void setCharEnd(Map map, int n) {
        map.put("charEnd", new Integer(n));
    }

    public static void setCharStart(IMarker iMarker, int n) {
        MarkerUtilities.setIntAttribute(iMarker, "charStart", n);
    }

    public static void setCharStart(Map map, int n) {
        map.put("charStart", new Integer(n));
    }

    private static void setIntAttribute(IMarker iMarker, String string, int n) {
        try {
            if (iMarker.exists()) {
                iMarker.setAttribute(string, n);
            }
        }
        catch (CoreException coreException) {
            MarkerUtilities.handleCoreException(coreException);
        }
    }

    public static void setLineNumber(IMarker iMarker, int n) {
        MarkerUtilities.setIntAttribute(iMarker, "lineNumber", n);
    }

    public static void setLineNumber(Map map, int n) {
        map.put("lineNumber", new Integer(n));
    }

    public static void setMessage(Map map, String string) {
        map.put("message", string);
    }

    public static void createMarker(final IResource iResource, final Map map, final String string) throws CoreException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IMarker iMarker = iResource.createMarker(string);
                iMarker.setAttributes(map);
            }
        };
        iResource.getWorkspace().run(iWorkspaceRunnable, null, 1, null);
    }

    public static String[] getSuperTypes(String string) {
        if (fgMarkerTypeHierarchy == null) {
            fgMarkerTypeHierarchy = new MarkerTypeHierarchy();
        }
        return fgMarkerTypeHierarchy.getSuperTypes(string);
    }

    private static class MarkerTypeHierarchy {
        private Map fTypeMap;
        private Map fSuperTypesCache = new HashMap();

        private MarkerTypeHierarchy() {
        }

        public String[] getSuperTypes(String string) {
            String[] stringArray = (String[])this.fSuperTypesCache.get(string);
            if (stringArray == null) {
                stringArray = this.computeSuperTypes(string);
                this.fSuperTypesCache.put(string, stringArray);
            }
            return stringArray;
        }

        private String[] computeSuperTypes(String string) {
            String[] stringArray;
            ArrayList arrayList = new ArrayList();
            this.appendAll(arrayList, this.getDirectSuperTypes(string));
            int n = 0;
            while (n < arrayList.size()) {
                stringArray = (String)arrayList.get(n++);
                this.appendAll(arrayList, this.getDirectSuperTypes((String)stringArray));
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }

        private String[] getDirectSuperTypes(String string) {
            return (String[])this.getTypeMap().get(string);
        }

        private void appendAll(List list, Object[] objectArray) {
            if (objectArray == null) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (!list.contains(object)) {
                    list.add(object);
                }
                ++n;
            }
        }

        private Map getTypeMap() {
            if (this.fTypeMap == null) {
                this.fTypeMap = this.readTypes();
            }
            return this.fTypeMap;
        }

        private Map readTypes() {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "markers");
            if (iExtensionPoint != null) {
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    ArrayList<String> arrayList = new ArrayList<String>();
                    IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                    int n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        String string;
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                        if (iConfigurationElement.getName().equalsIgnoreCase("super") && (string = iConfigurationElement.getAttribute("type")) != null) {
                            arrayList.add(string);
                        }
                        ++n2;
                    }
                    String[] stringArray = new String[arrayList.size()];
                    arrayList.toArray(stringArray);
                    hashMap.put(iExtension.getUniqueIdentifier(), stringArray);
                    ++n;
                }
            }
            return hashMap;
        }
    }
}

