/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public class MarkerRulerAction
extends ResourceAction
implements IUpdate {
    private static final int MAX_LABEL_LENGTH = 80;
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private String fMarkerType;
    private List fMarkers;
    private boolean fAskForLabel;
    private ResourceBundle fBundle;
    private String fPrefix;
    private String fAddLabel;
    private String fRemoveLabel;

    public MarkerRulerAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor, IVerticalRulerInfo iVerticalRulerInfo, String string2, boolean bl) {
        super(resourceBundle, string);
        Assert.isLegal((iTextEditor != null ? 1 : 0) != 0);
        this.fRuler = iVerticalRulerInfo;
        this.fTextEditor = iTextEditor;
        this.fMarkerType = string2;
        this.fAskForLabel = bl;
        this.fBundle = resourceBundle;
        this.fPrefix = string;
        this.fAddLabel = MarkerRulerAction.getString((ResourceBundle)resourceBundle, (String)(String.valueOf(string) + "add.label"), (String)(String.valueOf(string) + "add.label"));
        this.fRemoveLabel = MarkerRulerAction.getString((ResourceBundle)resourceBundle, (String)(String.valueOf(string) + "remove.label"), (String)(String.valueOf(string) + "remove.label"));
    }

    public MarkerRulerAction(ResourceBundle resourceBundle, String string, IVerticalRuler iVerticalRuler, ITextEditor iTextEditor, String string2, boolean bl) {
        this(resourceBundle, string, iTextEditor, (IVerticalRulerInfo)iVerticalRuler, string2, bl);
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected IVerticalRuler getVerticalRuler() {
        if (this.fRuler instanceof IVerticalRuler) {
            return (IVerticalRuler)this.fRuler;
        }
        return null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected String getResourceKeyPrefix() {
        return this.fPrefix;
    }

    public void update() {
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            int n = this.getVerticalRuler().getLineOfLastMouseButtonActivity() + 1;
            if (n > iDocument.getNumberOfLines()) {
                this.setEnabled(false);
                this.setText(this.fAddLabel);
            } else {
                this.fMarkers = this.getMarkers();
                this.setEnabled(this.getResource() != null && (this.fMarkers.isEmpty() || this.markersUserEditable(this.fMarkers)));
                this.setText(this.fMarkers.isEmpty() ? this.fAddLabel : this.fRemoveLabel);
            }
        }
    }

    private boolean markersUserEditable(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.isUserEditable((IMarker)iterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isUserEditable(IMarker iMarker) {
        return iMarker != null && iMarker.exists() && iMarker.getAttribute("userEditable", true);
    }

    public void run() {
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected IResource getResource() {
        IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
        IResource iResource = (IResource)iEditorInput.getAdapter(IFile.class);
        if (iResource == null) {
            iResource = (IResource)iEditorInput.getAdapter(IResource.class);
        }
        return iResource;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)iAnnotationModel;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        return iDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected boolean includesRulerLine(Position position, IDocument iDocument) {
        if (position != null) {
            try {
                int n = iDocument.getLineOfOffset(position.getOffset());
                int n2 = this.fRuler.getLineOfLastMouseButtonActivity();
                if (n2 == n) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected void handleCoreException(CoreException coreException, String string) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog iLog = Platform.getLog((Bundle)bundle);
        if (string != null) {
            iLog.log((IStatus)new Status(4, "org.eclipse.ui", 0, string, (Throwable)coreException));
        } else {
            iLog.log(coreException.getStatus());
        }
        Shell shell = this.getTextEditor().getSite().getShell();
        String string2 = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.title"), (String)(String.valueOf(this.fPrefix) + "error.dialog.title"));
        String string3 = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
        ErrorDialog.openError((Shell)shell, (String)string2, (String)string3, (IStatus)coreException.getStatus());
    }

    protected List getMarkers() {
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        IResource iResource = this.getResource();
        IDocument iDocument = this.getDocument();
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = this.getAnnotationModel();
        if (iResource != null && abstractMarkerAnnotationModel != null && iResource.exists()) {
            try {
                IMarker[] iMarkerArray = iResource.findMarkers(this.fMarkerType, true, 0);
                if (iMarkerArray != null) {
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        if (this.includesRulerLine(abstractMarkerAnnotationModel.getMarkerPosition(iMarkerArray[n]), iDocument)) {
                            arrayList.add(iMarkerArray[n]);
                        }
                        ++n;
                    }
                }
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, TextEditorMessages.MarkerRulerAction_getMarker);
            }
        }
        return arrayList;
    }

    protected void addMarker() {
        IResource iResource = this.getResource();
        if (iResource == null) {
            return;
        }
        Map map = this.getInitialAttributes();
        if (this.fAskForLabel && !this.askForLabel(map)) {
            return;
        }
        this.execute((IUndoableOperation)new CreateMarkersOperation(this.fMarkerType, map, iResource, this.getOperationName()));
    }

    protected void removeMarkers(List list) {
        IMarker[] iMarkerArray = list.toArray(new IMarker[list.size()]);
        this.execute((IUndoableOperation)new DeleteMarkersOperation(iMarkerArray, this.getOperationName()));
    }

    protected boolean askForLabel(Map map) {
        Object v = map.get("message");
        String string = v instanceof String ? (String)v : "";
        String string2 = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "add.dialog.title"), (String)(String.valueOf(this.fPrefix) + "add.dialog.title"));
        String string3 = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "add.dialog.message"), (String)(String.valueOf(this.fPrefix) + "add.dialog.message"));
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                return string == null || string.trim().length() == 0 ? " " : null;
            }
        };
        InputDialog inputDialog = new InputDialog(this.fTextEditor.getSite().getShell(), string2, string3, string, iInputValidator);
        String string4 = null;
        if (inputDialog.open() != 1) {
            string4 = inputDialog.getValue();
        }
        if (string4 == null) {
            return false;
        }
        if ((string4 = string4.trim()).length() == 0) {
            return false;
        }
        MarkerUtilities.setMessage(map, string4);
        return true;
    }

    protected Map getInitialAttributes() {
        HashMap hashMap = new HashMap(11);
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        IDocument iDocument = iDocumentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
        int n = this.fRuler.getLineOfLastMouseButtonActivity();
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        try {
            IRegion iRegion = iDocument.getLineInformation(n);
            n2 = iRegion.getOffset();
            n4 = iRegion.getLength();
            n3 = n2 + n4;
        }
        catch (BadLocationException badLocationException) {}
        MarkerUtilities.setMessage(hashMap, this.getLabelProposal(iDocument, n2, n4));
        MarkerUtilities.setLineNumber(hashMap, n + 1);
        MarkerUtilities.setCharStart(hashMap, n2);
        MarkerUtilities.setCharEnd(hashMap, n3);
        return hashMap;
    }

    protected String getLabelProposal(IDocument iDocument, int n, int n2) {
        try {
            String string = iDocument.get(n, n2).trim();
            if (string.length() <= 80) {
                return string;
            }
            return string.substring(0, 80);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String getOperationName() {
        String string = this.getText();
        return string == null ? TextEditorMessages.AddMarkerAction_addMarker : string;
    }

    private void execute(IUndoableOperation iUndoableOperation) {
        final Shell shell = this.getTextEditor().getSite().getShell();
        IAdaptable iAdaptable = new IAdaptable(){

            public Object getAdapter(Class clazz) {
                if (clazz == Shell.class) {
                    return shell;
                }
                return null;
            }
        };
        IOperationHistory iOperationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        try {
            iOperationHistory.execute(iUndoableOperation, null, iAdaptable);
        }
        catch (ExecutionException executionException) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog iLog = Platform.getLog((Bundle)bundle);
            String string = MarkerRulerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
            iLog.log((IStatus)new Status(4, "org.eclipse.ui", 0, string, (Throwable)executionException));
        }
    }
}

