/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ReadOnlyAnnotationPreference;
import org.osgi.framework.Bundle;

public class MarkerAnnotationPreferences {
    private List fFragments;
    private List fPreferences;

    public static void initializeDefaultValues(IPreferenceStore iPreferenceStore) {
        boolean bl = iPreferenceStore.getBoolean("useAnnotationsPrefPage");
        boolean bl2 = iPreferenceStore.getBoolean("useQuickDiffPrefPage");
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        for (AnnotationPreference annotationPreference : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (bl && annotationPreference.isIncludeOnPreferencePage() && MarkerAnnotationPreferences.isComplete(annotationPreference) || bl2 && (annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") || annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") || annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion"))) continue;
            iPreferenceStore.setDefault(annotationPreference.getTextPreferenceKey(), annotationPreference.getTextPreferenceValue());
            iPreferenceStore.setDefault(annotationPreference.getOverviewRulerPreferenceKey(), annotationPreference.getOverviewRulerPreferenceValue());
            if (annotationPreference.getVerticalRulerPreferenceKey() != null) {
                iPreferenceStore.setDefault(annotationPreference.getVerticalRulerPreferenceKey(), annotationPreference.getVerticalRulerPreferenceValue());
            }
            PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)annotationPreference.getColorPreferenceKey(), (RGB)annotationPreference.getColorPreferenceValue());
            if (annotationPreference.getShowInNextPrevDropdownToolbarActionKey() != null) {
                iPreferenceStore.setDefault(annotationPreference.getShowInNextPrevDropdownToolbarActionKey(), annotationPreference.isShowInNextPrevDropdownToolbarAction());
            }
            if (annotationPreference.getIsGoToNextNavigationTargetKey() != null) {
                iPreferenceStore.setDefault(annotationPreference.getIsGoToNextNavigationTargetKey(), annotationPreference.isGoToNextNavigationTarget());
            }
            if (annotationPreference.getIsGoToPreviousNavigationTargetKey() != null) {
                iPreferenceStore.setDefault(annotationPreference.getIsGoToPreviousNavigationTargetKey(), annotationPreference.isGoToPreviousNavigationTarget());
            }
            if (annotationPreference.getHighlightPreferenceKey() != null) {
                iPreferenceStore.setDefault(annotationPreference.getHighlightPreferenceKey(), annotationPreference.getHighlightPreferenceValue());
            }
            if (annotationPreference.getTextStylePreferenceKey() == null) continue;
            iPreferenceStore.setDefault(annotationPreference.getTextStylePreferenceKey(), annotationPreference.getTextStyleValue());
        }
    }

    public static void useAnnotationsPreferencePage(IPreferenceStore iPreferenceStore) throws IllegalStateException {
        MarkerAnnotationPreferences.checkAccess();
        iPreferenceStore.putValue("useAnnotationsPrefPage", Boolean.toString(true));
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        for (AnnotationPreference annotationPreference : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (!annotationPreference.isIncludeOnPreferencePage() || !MarkerAnnotationPreferences.isComplete(annotationPreference)) continue;
            iPreferenceStore.setToDefault(annotationPreference.getTextPreferenceKey());
            iPreferenceStore.setToDefault(annotationPreference.getOverviewRulerPreferenceKey());
            if (annotationPreference.getVerticalRulerPreferenceKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getVerticalRulerPreferenceKey());
            }
            iPreferenceStore.setToDefault(annotationPreference.getColorPreferenceKey());
            if (annotationPreference.getShowInNextPrevDropdownToolbarActionKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getShowInNextPrevDropdownToolbarActionKey());
            }
            if (annotationPreference.getIsGoToNextNavigationTargetKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getIsGoToNextNavigationTargetKey());
            }
            if (annotationPreference.getIsGoToPreviousNavigationTargetKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getIsGoToPreviousNavigationTargetKey());
            }
            if (annotationPreference.getHighlightPreferenceKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getHighlightPreferenceKey());
            }
            if (annotationPreference.getTextStylePreferenceKey() == null) continue;
            iPreferenceStore.setToDefault(annotationPreference.getTextStylePreferenceKey());
        }
    }

    public static void useQuickDiffPreferencePage(IPreferenceStore iPreferenceStore) throws IllegalStateException {
        MarkerAnnotationPreferences.checkAccess();
        iPreferenceStore.putValue("useQuickDiffPrefPage", Boolean.toString(true));
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        for (AnnotationPreference annotationPreference : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (!annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") && !annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") && !annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            iPreferenceStore.setToDefault(annotationPreference.getTextPreferenceKey());
            iPreferenceStore.setToDefault(annotationPreference.getOverviewRulerPreferenceKey());
            if (annotationPreference.getVerticalRulerPreferenceKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getVerticalRulerPreferenceKey());
            }
            iPreferenceStore.setToDefault(annotationPreference.getColorPreferenceKey());
            if (annotationPreference.getShowInNextPrevDropdownToolbarActionKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getShowInNextPrevDropdownToolbarActionKey());
            }
            if (annotationPreference.getIsGoToNextNavigationTargetKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getIsGoToNextNavigationTargetKey());
            }
            if (annotationPreference.getIsGoToPreviousNavigationTargetKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getIsGoToPreviousNavigationTargetKey());
            }
            if (annotationPreference.getHighlightPreferenceKey() != null) {
                iPreferenceStore.setToDefault(annotationPreference.getHighlightPreferenceKey());
            }
            if (annotationPreference.getTextStylePreferenceKey() == null) continue;
            iPreferenceStore.setToDefault(annotationPreference.getTextStylePreferenceKey());
        }
    }

    private static void checkAccess() throws IllegalStateException {
        Class[] classArray = new AccessChecker().getClassContext();
        if (!classArray[3].equals(EditorsUI.class) && !classArray[4].equals(EditorsUI.class)) {
            throw new IllegalStateException();
        }
    }

    public MarkerAnnotationPreferences() {
        this(false);
    }

    private MarkerAnnotationPreferences(boolean bl) {
        if (bl) {
            this.initializeSharedMakerAnnotationPreferences();
        }
    }

    public List getAnnotationPreferences() {
        if (this.fPreferences == null) {
            this.initialize();
        }
        return this.fPreferences;
    }

    public List getAnnotationPreferenceFragments() {
        if (this.fFragments == null) {
            this.initialize();
        }
        return this.fFragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = EditorsPlugin.getDefault();
        synchronized (object) {
            if (!EditorsPlugin.getDefault().isMarkerAnnotationPreferencesInitialized()) {
                EditorsPlugin.getDefault().setMarkerAnnotationPreferences(new MarkerAnnotationPreferences(true));
            }
        }
        object = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.fFragments = this.cloneAnnotationPreferences(((MarkerAnnotationPreferences)object).fFragments);
        this.fPreferences = this.cloneAnnotationPreferences(((MarkerAnnotationPreferences)object).fPreferences);
    }

    private void initializeSharedMakerAnnotationPreferences() {
        this.fFragments = new ArrayList(2);
        this.fPreferences = new ArrayList(2);
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "markerAnnotationSpecification");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                AnnotationPreference annotationPreference = this.createSpec(iConfigurationElementArray[n]);
                if (annotationPreference != null) {
                    this.fFragments.add(annotationPreference);
                }
                if (MarkerAnnotationPreferences.isComplete(annotationPreference)) {
                    this.fPreferences.add(annotationPreference);
                }
                ++n;
            }
        }
    }

    private List cloneAnnotationPreferences(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<AnnotationPreference> arrayList = new ArrayList<AnnotationPreference>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.clone((AnnotationPreference)iterator.next()));
        }
        return arrayList;
    }

    private AnnotationPreference clone(AnnotationPreference annotationPreference) {
        if (annotationPreference == null) {
            return null;
        }
        AnnotationPreference annotationPreference2 = new AnnotationPreference();
        if (annotationPreference.getAnnotationType() != null) {
            annotationPreference2.setAnnotationType(annotationPreference.getAnnotationType());
            annotationPreference2.merge(annotationPreference);
        }
        return annotationPreference2;
    }

    private static boolean isComplete(AnnotationPreference annotationPreference) {
        return annotationPreference.getColorPreferenceKey() != null && annotationPreference.getColorPreferenceValue() != null && annotationPreference.getTextPreferenceKey() != null && annotationPreference.getOverviewRulerPreferenceKey() != null;
    }

    private AnnotationPreference createSpec(IConfigurationElement iConfigurationElement) {
        boolean bl;
        int n;
        ReadOnlyAnnotationPreference readOnlyAnnotationPreference = new ReadOnlyAnnotationPreference();
        String string = iConfigurationElement.getAttribute("annotationType");
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        readOnlyAnnotationPreference.setAnnotationType(string);
        string = iConfigurationElement.getAttribute("label");
        if (string != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setPreferenceLabel(string);
        }
        if ((string = iConfigurationElement.getAttribute("markerType")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setMarkerType(string);
        }
        if ((string = iConfigurationElement.getAttribute("markerSeverity")) != null && string.trim().length() > 0) {
            n = StringConverter.asInt((String)string, (int)0);
            readOnlyAnnotationPreference.setSeverity(n);
        }
        if ((string = iConfigurationElement.getAttribute("textPreferenceKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setTextPreferenceKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("textPreferenceValue")) != null && string.trim().length() > 0) {
            bl = StringConverter.asBoolean((String)string, (boolean)false);
            readOnlyAnnotationPreference.setTextPreferenceValue(bl);
        }
        if ((string = iConfigurationElement.getAttribute("highlightPreferenceKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setHighlightPreferenceKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("highlightPreferenceValue")) != null && string.trim().length() > 0) {
            bl = StringConverter.asBoolean((String)string, (boolean)false);
            readOnlyAnnotationPreference.setHighlightPreferenceValue(bl);
        }
        if ((string = iConfigurationElement.getAttribute("overviewRulerPreferenceKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setOverviewRulerPreferenceKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("overviewRulerPreferenceValue")) != null && string.trim().length() > 0) {
            bl = StringConverter.asBoolean((String)string, (boolean)false);
            readOnlyAnnotationPreference.setOverviewRulerPreferenceValue(bl);
        }
        if ((string = iConfigurationElement.getAttribute("verticalRulerPreferenceKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setVerticalRulerPreferenceKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("verticalRulerPreferenceValue")) != null && string.trim().length() > 0) {
            bl = StringConverter.asBoolean((String)string, (boolean)true);
            readOnlyAnnotationPreference.setVerticalRulerPreferenceValue(bl);
        }
        if ((string = iConfigurationElement.getAttribute("colorPreferenceKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setColorPreferenceKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("colorPreferenceValue")) != null && string.trim().length() > 0) {
            RGB rGB = StringConverter.asRGB((String)string);
            readOnlyAnnotationPreference.setColorPreferenceValue(rGB == null ? new RGB(0, 0, 0) : rGB);
        }
        if ((string = iConfigurationElement.getAttribute("presentationLayer")) != null && string.trim().length() > 0) {
            n = StringConverter.asInt((String)string, (int)0);
            readOnlyAnnotationPreference.setPresentationLayer(n);
        }
        if ((string = iConfigurationElement.getAttribute("contributesToHeader")) != null && string.trim().length() > 0) {
            bl = StringConverter.asBoolean((String)string, (boolean)false);
            readOnlyAnnotationPreference.setContributesToHeader(bl);
        }
        if ((string = iConfigurationElement.getAttribute("showInNextPrevDropdownToolbarActionKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setShowInNextPrevDropdownToolbarActionKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("showInNextPrevDropdownToolbarAction")) != null && string.trim().length() > 0) {
            bl = StringConverter.asBoolean((String)string, (boolean)false);
            readOnlyAnnotationPreference.setShowInNextPrevDropdownToolbarAction(bl);
        }
        if ((string = iConfigurationElement.getAttribute("isGoToNextNavigationTargetKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setIsGoToNextNavigationTargetKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("isGoToNextNavigationTarget")) != null && string.trim().length() > 0) {
            bl = StringConverter.asBoolean((String)string, (boolean)false);
            readOnlyAnnotationPreference.setIsGoToNextNavigationTarget(bl);
        }
        if ((string = iConfigurationElement.getAttribute("isGoToPreviousNavigationTargetKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setIsGoToPreviousNavigationTargetKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("isGoToPreviousNavigationTarget")) != null && string.trim().length() > 0) {
            bl = StringConverter.asBoolean((String)string, (boolean)false);
            readOnlyAnnotationPreference.setIsGoToPreviousNavigationTarget(bl);
        }
        if ((string = iConfigurationElement.getAttribute("symbolicIcon")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setSymbolicImageName(string);
        }
        if ((string = iConfigurationElement.getAttribute("icon")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setImageDescriptor(this.getImageDescriptor(string, iConfigurationElement));
        }
        if ((string = iConfigurationElement.getAttribute("quickFixIcon")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setQuickFixImageDescriptor(this.getImageDescriptor(string, iConfigurationElement));
        }
        if ((string = iConfigurationElement.getAttribute("annotationImageProvider")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setAnnotationImageProviderData(iConfigurationElement, "annotationImageProvider");
        }
        if ((string = iConfigurationElement.getAttribute("textStylePreferenceKey")) != null && string.trim().length() > 0) {
            readOnlyAnnotationPreference.setTextStylePreferenceKey(string);
        }
        if ((string = iConfigurationElement.getAttribute("textStylePreferenceValue")) != null && string.trim().length() > 0) {
            if ("BOX".equals(string) || "DASHED_BOX".equals(string) || "IBEAM".equals(string) || "SQUIGGLES".equals(string) || "PROBLEM_UNDERLINE".equals(string) || "UNDERLINE".equals(string)) {
                readOnlyAnnotationPreference.setTextStyleValue(string);
            } else {
                readOnlyAnnotationPreference.setTextStyleValue("NONE");
            }
        }
        readOnlyAnnotationPreference.setIncludeOnPreferencePage((string = iConfigurationElement.getAttribute("includeOnPreferencePage")) == null || StringConverter.asBoolean((String)string, (boolean)true));
        readOnlyAnnotationPreference.markReadOnly();
        return readOnlyAnnotationPreference;
    }

    private ImageDescriptor getImageDescriptor(String string, IConfigurationElement iConfigurationElement) {
        String string2 = iConfigurationElement.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)string2);
        if (bundle == null) {
            return null;
        }
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)new Path(string), null);
        if (uRL != null) {
            return ImageDescriptor.createFromURL((URL)uRL);
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    private static final class AccessChecker
    extends SecurityManager {
        private AccessChecker() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

