/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class MarkerAnnotation
extends SimpleMarkerAnnotation
implements IQuickFixableAnnotation {
    public static final int PROBLEM_LAYER = 5;
    private static Map fgImageRegistry;
    private Image fImage;
    private String fImageName;
    private int fPresentationLayer = -1;
    private boolean fIsQuickFixable;
    private boolean fIsQuickFixableStateSet;

    protected static Image getImage(Display display, ImageDescriptor imageDescriptor) {
        Map map = MarkerAnnotation.getImageRegistry(display);
        Image image = (Image)map.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            map.put(imageDescriptor, image);
        }
        return image;
    }

    protected static Map getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new HashMap();
            display.disposeExec(new Runnable(){

                @Override
                public void run() {
                    if (fgImageRegistry != null) {
                        Map map = fgImageRegistry;
                        fgImageRegistry = null;
                        for (Image image : map.values()) {
                            if (image.isDisposed()) continue;
                            image.dispose();
                        }
                    }
                }
            });
        }
        return fgImageRegistry;
    }

    public MarkerAnnotation(IMarker iMarker) {
        super(iMarker);
    }

    public MarkerAnnotation(String string, IMarker iMarker) {
        super(string, iMarker);
        this.initialize();
    }

    protected void setImage(Image image) {
        this.fImage = image;
    }

    protected void initialize() {
        IMarker iMarker = this.getMarker();
        String string = this.getUnknownImageName(iMarker);
        if (MarkerUtilities.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            string = "IMG_OBJS_TASK_TSK";
        } else if (MarkerUtilities.isMarkerType(iMarker, "org.eclipse.core.resources.bookmark")) {
            string = "IMG_OBJS_BKMRK_TSK";
        } else if (MarkerUtilities.isMarkerType(iMarker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtilities.getSeverity(iMarker)) {
                case 0: {
                    string = "IMG_OBJS_INFO_TSK";
                    break;
                }
                case 1: {
                    string = "IMG_OBJS_WARN_TSK";
                    break;
                }
                case 2: {
                    string = "IMG_OBJS_ERROR_TSK";
                }
            }
        }
        this.fImage = null;
        this.fImageName = string;
    }

    public int getLayer() {
        if (this.fPresentationLayer != -1) {
            return this.fPresentationLayer;
        }
        AnnotationPreference annotationPreference = EditorsPlugin.getDefault().getAnnotationPreferenceLookup().getAnnotationPreference(this);
        if (annotationPreference != null) {
            return annotationPreference.getPresentationLayer();
        }
        return 0;
    }

    protected void setLayer(int n) {
        this.fPresentationLayer = n;
    }

    public void paint(GC gC, Canvas canvas, Rectangle rectangle) {
        Image image = this.getImage(canvas.getDisplay());
        if (image != null) {
            ImageUtilities.drawImage((Image)image, (GC)gC, (Canvas)canvas, (Rectangle)rectangle, (int)0x1000000, (int)128);
        }
    }

    @Override
    public void update() {
        super.update();
        this.initialize();
    }

    protected String getUnknownImageName(IMarker iMarker) {
        return null;
    }

    protected Image getImage(String string) {
        if (string != null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage(string);
        }
        return null;
    }

    protected Image getImage(Display display) {
        if (this.fImage == null) {
            ImageDescriptor imageDescriptor;
            IWorkbenchAdapter iWorkbenchAdapter;
            IMarker iMarker = this.getMarker();
            if (iMarker.exists() && (iWorkbenchAdapter = (IWorkbenchAdapter)iMarker.getAdapter(IWorkbenchAdapter.class)) != null && (imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iMarker)) != null) {
                this.fImage = MarkerAnnotation.getImage(display, imageDescriptor);
            }
            if (this.fImage == null) {
                this.fImage = this.getImage(this.fImageName);
            }
        }
        return this.fImage;
    }

    public void setQuickFixable(boolean bl) {
        this.fIsQuickFixable = bl;
        this.fIsQuickFixableStateSet = true;
    }

    public boolean isQuickFixableStateSet() {
        return this.fIsQuickFixableStateSet;
    }

    public boolean isQuickFixable() {
        Assert.isTrue((boolean)this.isQuickFixableStateSet());
        return this.fIsQuickFixable;
    }
}

