/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public class DocumentProviderRegistry {
    private static DocumentProviderRegistry fgRegistry;
    private Map fExtensionMapping = new HashMap();
    private Map fInputTypeMapping = new HashMap();
    private Map fInstances = new HashMap();

    public static DocumentProviderRegistry getDefault() {
        if (fgRegistry == null) {
            fgRegistry = new DocumentProviderRegistry();
        }
        return fgRegistry;
    }

    private DocumentProviderRegistry() {
        this.initialize();
    }

    private void read(Map map, IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().trim();
                HashSet<IConfigurationElement> hashSet = (HashSet<IConfigurationElement>)map.get(string3);
                if (hashSet == null) {
                    hashSet = new HashSet<IConfigurationElement>();
                    map.put(string3, hashSet);
                }
                hashSet.add(iConfigurationElement);
            }
        }
    }

    private void initialize() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "documentProviders");
        if (iExtensionPoint == null) {
            String string = NLSUtility.format(TextEditorMessages.DocumentProviderRegistry_error_extension_point_not_found, "org.eclipse.ui");
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog iLog = Platform.getLog((Bundle)bundle);
            iLog.log((IStatus)new Status(4, "org.eclipse.ui", 0, string, null));
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            this.read(this.fExtensionMapping, iConfigurationElementArray[n], "extensions");
            this.read(this.fInputTypeMapping, iConfigurationElementArray[n], "inputTypes");
            ++n;
        }
    }

    private IDocumentProvider getDocumentProvider(IConfigurationElement iConfigurationElement) {
        IDocumentProvider iDocumentProvider = (IDocumentProvider)this.fInstances.get(iConfigurationElement);
        if (iDocumentProvider == null) {
            try {
                iDocumentProvider = (IDocumentProvider)iConfigurationElement.createExecutableExtension("class");
                this.fInstances.put(iConfigurationElement, iDocumentProvider);
            }
            catch (CoreException coreException) {}
        }
        return iDocumentProvider;
    }

    private IConfigurationElement selectConfigurationElement(Set set) {
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            return (IConfigurationElement)iterator.next();
        }
        return null;
    }

    public IDocumentProvider getDocumentProvider(String string) {
        Set set = (Set)this.fExtensionMapping.get(string);
        if (set != null) {
            IConfigurationElement iConfigurationElement = this.selectConfigurationElement(set);
            return this.getDocumentProvider(iConfigurationElement);
        }
        return null;
    }

    private List computeClassList(Class clazz) {
        ArrayList arrayList = new ArrayList();
        Class clazz2 = clazz;
        while (clazz2 != null) {
            arrayList.add(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    private List computeInterfaceList(List list) {
        ArrayList arrayList = new ArrayList(4);
        Hashtable hashtable = new Hashtable(4);
        for (Class clazz : list) {
            this.computeInterfaceList(clazz.getInterfaces(), arrayList, hashtable);
        }
        return arrayList;
    }

    private void computeInterfaceList(Class[] classArray, List list, Hashtable hashtable) {
        ArrayList<Class> arrayList = new ArrayList<Class>(classArray.length);
        int n = 0;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            if (hashtable.get(clazz) == null) {
                hashtable.put(clazz, clazz);
                list.add(clazz);
                arrayList.add(clazz);
            }
            ++n;
        }
        for (Class clazz : arrayList) {
            this.computeInterfaceList(clazz.getInterfaces(), list, hashtable);
        }
    }

    private Object getFirstInputTypeMapping(List list) {
        for (Class clazz : list) {
            Object v = this.fInputTypeMapping.get(clazz.getName());
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private Object findInputTypeMapping(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object object = this.fInputTypeMapping.get(clazz.getName());
        if (object != null) {
            return object;
        }
        List list = this.computeClassList(clazz);
        object = this.getFirstInputTypeMapping(list);
        if (object != null) {
            return object;
        }
        return this.getFirstInputTypeMapping(this.computeInterfaceList(list));
    }

    public IDocumentProvider getDocumentProvider(IEditorInput iEditorInput) {
        Set set;
        IDocumentProvider iDocumentProvider = null;
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile != null) {
            iDocumentProvider = this.getDocumentProvider(iFile.getFileExtension());
        }
        if (iDocumentProvider == null && (set = (Set)this.findInputTypeMapping(iEditorInput.getClass())) != null) {
            IConfigurationElement iConfigurationElement = this.selectConfigurationElement(set);
            iDocumentProvider = this.getDocumentProvider(iConfigurationElement);
        }
        return iDocumentProvider;
    }
}

