/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationAccessExtension2;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.AnnotationType;
import org.eclipse.ui.internal.texteditor.AnnotationTypeHierarchy;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class DefaultMarkerAnnotationAccess
implements IAnnotationAccess,
IAnnotationAccessExtension,
IAnnotationAccessExtension2 {
    public static final String UNKNOWN = "org.eclipse.text.annotation.unknown";
    public static final String ERROR_SYSTEM_IMAGE = "error";
    public static final String WARNING_SYSTEM_IMAGE = "warning";
    public static final String INFO_SYSTEM_IMAGE = "info";
    public static final String TASK_SYSTEM_IMAGE = "task";
    public static final String BOOKMARK_SYSTEM_IMAGE = "bookmark";
    private static final Map MAPPING = new HashMap();
    protected MarkerAnnotationPreferences fMarkerAnnotationPreferences;
    private IQuickAssistAssistant fQuickAssistAssistant;

    static {
        MAPPING.put(ERROR_SYSTEM_IMAGE, "IMG_OBJS_ERROR_TSK");
        MAPPING.put(WARNING_SYSTEM_IMAGE, "IMG_OBJS_WARN_TSK");
        MAPPING.put(INFO_SYSTEM_IMAGE, "IMG_OBJS_INFO_TSK");
        MAPPING.put(TASK_SYSTEM_IMAGE, "IMG_OBJS_TASK_TSK");
        MAPPING.put(BOOKMARK_SYSTEM_IMAGE, "IMG_OBJS_BKMRK_TSK");
    }

    public DefaultMarkerAnnotationAccess(MarkerAnnotationPreferences markerAnnotationPreferences) {
        this.fMarkerAnnotationPreferences = markerAnnotationPreferences;
    }

    public DefaultMarkerAnnotationAccess() {
    }

    public void setQuickAssistAssistant(IQuickAssistAssistant iQuickAssistAssistant) {
        this.fQuickAssistAssistant = iQuickAssistAssistant;
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        AnnotationPreferenceLookup annotationPreferenceLookup = this.getAnnotationPreferenceLookup();
        if (annotationPreferenceLookup != null) {
            return annotationPreferenceLookup.getAnnotationPreference(annotation);
        }
        return null;
    }

    protected AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
    }

    public Object getType(Annotation annotation) {
        return annotation.getType();
    }

    public boolean isMultiLine(Annotation annotation) {
        return true;
    }

    public boolean isTemporary(Annotation annotation) {
        return !annotation.isPersistent();
    }

    public String getTypeLabel(Annotation annotation) {
        AnnotationPreference annotationPreference = this.getAnnotationPreference(annotation);
        return annotationPreference != null ? annotationPreference.getPreferenceLabel() : null;
    }

    public int getLayer(Annotation annotation) {
        if (annotation instanceof IAnnotationPresentation) {
            IAnnotationPresentation iAnnotationPresentation = (IAnnotationPresentation)annotation;
            return iAnnotationPresentation.getLayer();
        }
        AnnotationPreference annotationPreference = this.getAnnotationPreference(annotation);
        if (annotationPreference != null) {
            return annotationPreference.getPresentationLayer();
        }
        try {
            Method method = annotation.getClass().getMethod("getLayer", null);
            Integer n = (Integer)method.invoke((Object)annotation, null);
            return n;
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return 0;
    }

    public void paint(Annotation annotation, GC gC, Canvas canvas, Rectangle rectangle) {
        Object object;
        String string;
        Image image;
        if (annotation instanceof IAnnotationPresentation) {
            IAnnotationPresentation iAnnotationPresentation = (IAnnotationPresentation)annotation;
            iAnnotationPresentation.paint(gC, canvas, rectangle);
            return;
        }
        AnnotationPreference annotationPreference = this.getAnnotationPreference(annotation);
        if (annotationPreference != null && (image = this.getImage(annotation, annotationPreference, string = (object = this.getType(annotation)) == null ? null : object.toString())) != null) {
            ImageUtilities.drawImage((Image)image, (GC)gC, (Canvas)canvas, (Rectangle)rectangle, (int)0x1000000, (int)128);
            return;
        }
        try {
            object = annotation.getClass().getMethod("paint", GC.class, Canvas.class, Rectangle.class);
            ((Method)object).invoke((Object)annotation, gC, canvas, rectangle);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public boolean isPaintable(Annotation annotation) {
        if (annotation instanceof IAnnotationPresentation) {
            return true;
        }
        AnnotationPreference annotationPreference = this.getAnnotationPreference(annotation);
        if (annotationPreference == null) {
            return false;
        }
        Object object = this.getType(annotation);
        String string = object == null ? null : object.toString();
        Image image = this.getImage(annotation, annotationPreference, string);
        return image != null;
    }

    public boolean isSubtype(Object object, Object object2) {
        AnnotationTypeHierarchy annotationTypeHierarchy = this.getAnnotationTypeHierarchy();
        return annotationTypeHierarchy.isSubtype(object2.toString(), object.toString());
    }

    public Object[] getSupertypes(Object object) {
        AnnotationTypeHierarchy annotationTypeHierarchy = this.getAnnotationTypeHierarchy();
        AnnotationType annotationType = annotationTypeHierarchy.getAnnotationType(object.toString());
        return annotationType.getSuperTypes();
    }

    protected AnnotationTypeHierarchy getAnnotationTypeHierarchy() {
        return EditorsPlugin.getDefault().getAnnotationTypeHierarchy();
    }

    public static String getSharedImageName(String string) {
        Assert.isLegal((string != null ? 1 : 0) != 0);
        String string2 = (String)MAPPING.get(string);
        Assert.isLegal((string2 != null ? 1 : 0) != 0);
        return string2;
    }

    private Image getImage(Annotation annotation, AnnotationPreference annotationPreference, String string) {
        String string2;
        Image image;
        AnnotationBag annotationBag;
        if (annotation instanceof AnnotationBag && !(annotationBag = (AnnotationBag)annotation).isEmpty()) {
            annotation = (Annotation)annotationBag.iterator().next();
        }
        annotationBag = EditorsPlugin.getDefault().getImageRegistry();
        IAnnotationImageProvider iAnnotationImageProvider = annotationPreference.getAnnotationImageProvider();
        if (iAnnotationImageProvider != null) {
            image = iAnnotationImageProvider.getManagedImage(annotation);
            if (image != null) {
                return image;
            }
            string2 = iAnnotationImageProvider.getImageDescriptorId(annotation);
            if (string2 != null) {
                image = annotationBag.get(string2);
                if (image == null) {
                    ImageDescriptor imageDescriptor = iAnnotationImageProvider.getImageDescriptor(string2);
                    annotationBag.put(string2, imageDescriptor);
                    image = annotationBag.get(string2);
                }
                return image;
            }
        }
        if (string == null) {
            return null;
        }
        if (this.hasQuickFix(annotation) && (image = annotationPreference.getQuickFixImageDescriptor()) != null) {
            string2 = annotationBag.get(image.toString());
            if (string2 == null) {
                annotationBag.put(image.toString(), (ImageDescriptor)image);
                string2 = annotationBag.get(image.toString());
            }
            if (string2 != null) {
                return string2;
            }
        }
        if ((image = annotationBag.get(string)) == null) {
            string2 = annotationPreference.getImageDescriptor();
            if (string2 != null) {
                annotationBag.put(string, (ImageDescriptor)string2);
                image = annotationBag.get(string);
            } else {
                String string3;
                String string4 = annotationPreference.getSymbolicImageName();
                if (string4 != null && (string3 = DefaultMarkerAnnotationAccess.getSharedImageName(annotationPreference.getSymbolicImageName())) != null) {
                    ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
                    image = iSharedImages.getImage(string3);
                }
            }
        }
        return image;
    }

    protected boolean hasQuickFix(Annotation annotation) {
        if (annotation instanceof IQuickFixableAnnotation) {
            IQuickFixableAnnotation iQuickFixableAnnotation = (IQuickFixableAnnotation)annotation;
            if (!iQuickFixableAnnotation.isQuickFixableStateSet()) {
                iQuickFixableAnnotation.setQuickFixable(this.fQuickAssistAssistant != null && this.fQuickAssistAssistant.canFix(annotation));
            }
            return iQuickFixableAnnotation.isQuickFixable();
        }
        return false;
    }
}

