/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.ide.dialogs.AbstractEncodingFieldEditor;
import org.eclipse.ui.ide.dialogs.EncodingFieldEditor;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MessageDialogPage;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextEditorMessages;

public class ChangeEncodingAction
extends TextEditorAction {
    private static final int APPLY_ID = 2;
    private String fDialogTitle;
    private static final String ENCODING_PREF_KEY = "encoding";

    public ChangeEncodingAction(ITextEditor iTextEditor) {
        this(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ChangeEncodingAction.", iTextEditor);
    }

    public ChangeEncodingAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
        super(resourceBundle, string, iTextEditor);
        String string2 = "dialog.title";
        if (string != null && string.length() > 0) {
            string2 = String.valueOf(string) + string2;
        }
        this.fDialogTitle = ChangeEncodingAction.getString((ResourceBundle)resourceBundle, (String)string2, null);
    }

    public void run() {
        final IResource iResource = this.getResource();
        Shell shell = this.getTextEditor().getSite().getShell();
        final IEncodingSupport iEncodingSupport = this.getEncodingSupport();
        if (iResource == null && iEncodingSupport == null) {
            MessageDialog.openInformation((Shell)shell, (String)this.fDialogTitle, (String)TextEditorMessages.ChangeEncodingAction_message_noEncodingSupport);
            return;
        }
        Dialog dialog = new Dialog(shell){
            private AbstractEncodingFieldEditor fEncodingEditor;
            private IPreferenceStore store;
            {
                super(shell);
                this.store = null;
            }

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(ChangeEncodingAction.this.fDialogTitle);
            }

            protected Control createDialogArea(Composite composite) {
                Composite composite2 = (Composite)super.createDialogArea(composite);
                composite2 = new Composite(composite2, 0);
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
                gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
                gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                composite2.setLayout((Layout)gridLayout);
                GridData gridData = new GridData(1808);
                composite2.setLayoutData((Object)gridData);
                composite2.setFont(composite.getFont());
                MessageDialogPage messageDialogPage = new MessageDialogPage(composite2){

                    @Override
                    public void setErrorMessage(String string) {
                        super.setErrorMessage(string);
                        this.setButtonEnabledState(0, string == null);
                        this.setButtonEnabledState(2, string == null);
                    }

                    private void setButtonEnabledState(int n, boolean bl) {
                        Button button = this.getButton(n);
                        if (button != null) {
                            button.setEnabled(bl);
                        }
                    }
                };
                if (iResource != null) {
                    this.fEncodingEditor = new ResourceEncodingFieldEditor("", composite2, iResource, null);
                    this.fEncodingEditor.setPage((DialogPage)messageDialogPage);
                    this.fEncodingEditor.load();
                } else {
                    this.fEncodingEditor = new EncodingFieldEditor(ChangeEncodingAction.ENCODING_PREF_KEY, "", null, composite2);
                    this.store = new PreferenceStore();
                    String string = iEncodingSupport.getDefaultEncoding();
                    this.store.setDefault(ChangeEncodingAction.ENCODING_PREF_KEY, string);
                    String string2 = iEncodingSupport.getEncoding();
                    if (string2 != null) {
                        this.store.setValue(ChangeEncodingAction.ENCODING_PREF_KEY, string2);
                    }
                    this.fEncodingEditor.setPreferenceStore(this.store);
                    this.fEncodingEditor.setPage((DialogPage)messageDialogPage);
                    this.fEncodingEditor.load();
                    if (string2 == null || string2.equals(string) || string2.length() == 0) {
                        this.fEncodingEditor.loadDefault();
                    }
                }
                return composite2;
            }

            protected void createButtonsForButtonBar(Composite composite) {
                this.createButton(composite, 2, TextEditorMessages.ChangeEncodingAction_button_apply_label, false);
                super.createButtonsForButtonBar(composite);
            }

            protected void buttonPressed(int n) {
                if (n == 2) {
                    this.apply();
                } else {
                    super.buttonPressed(n);
                }
            }

            protected void okPressed() {
                this.apply();
                super.okPressed();
            }

            private void apply() {
                this.fEncodingEditor.store();
                if (iResource == null) {
                    String string = this.fEncodingEditor.getPreferenceStore().getString(this.fEncodingEditor.getPreferenceName());
                    iEncodingSupport.setEncoding(string);
                }
            }
        };
        dialog.open();
    }

    public void update() {
        this.setEnabled((this.getResource() != null || this.getEncodingSupport() != null) && !this.getTextEditor().isDirty());
    }

    private IResource getResource() {
        if (this.getTextEditor() != null && this.getTextEditor().getEditorInput() != null) {
            return (IResource)this.getTextEditor().getEditorInput().getAdapter(IResource.class);
        }
        return null;
    }

    private IEncodingSupport getEncodingSupport() {
        if (this.getTextEditor() != null) {
            return (IEncodingSupport)this.getTextEditor().getAdapter(IEncodingSupport.class);
        }
        return null;
    }
}

