/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ChainedPreferenceStore
implements IPreferenceStore {
    private IPreferenceStore[] fPreferenceStores;
    private ListenerList fClientListeners = new ListenerList(1);
    private List fChildListeners = new ArrayList();

    public ChainedPreferenceStore(IPreferenceStore[] iPreferenceStoreArray) {
        Assert.isTrue((iPreferenceStoreArray != null && iPreferenceStoreArray.length > 0 ? 1 : 0) != 0);
        this.fPreferenceStores = new IPreferenceStore[iPreferenceStoreArray.length];
        System.arraycopy(iPreferenceStoreArray, 0, this.fPreferenceStores, 0, iPreferenceStoreArray.length);
        int n = 0;
        int n2 = this.fPreferenceStores.length;
        while (n < n2) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(this.fPreferenceStores[n]);
            this.fChildListeners.add(propertyChangeListener);
            ++n;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.fClientListeners.size() == 0) {
            this.registerChildListeners();
        }
        this.fClientListeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fClientListeners.remove((Object)iPropertyChangeListener);
        if (this.fClientListeners.size() == 0) {
            this.unregisterChildListeners();
        }
    }

    public boolean contains(String string) {
        return this.getVisibleStore(string) != null;
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        this.firePropertyChangeEvent(new PropertyChangeEvent((Object)this, string, object, object2));
    }

    private void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.fClientListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public boolean getBoolean(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getBoolean(string);
        }
        return false;
    }

    public boolean getDefaultBoolean(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getDefaultBoolean(string);
        }
        return false;
    }

    public double getDefaultDouble(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getDefaultDouble(string);
        }
        return 0.0;
    }

    public float getDefaultFloat(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getDefaultFloat(string);
        }
        return 0.0f;
    }

    public int getDefaultInt(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getDefaultInt(string);
        }
        return 0;
    }

    public long getDefaultLong(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getDefaultLong(string);
        }
        return 0L;
    }

    public String getDefaultString(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getDefaultString(string);
        }
        return "";
    }

    public double getDouble(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getDouble(string);
        }
        return 0.0;
    }

    public float getFloat(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getFloat(string);
        }
        return 0.0f;
    }

    public int getInt(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getInt(string);
        }
        return 0;
    }

    public long getLong(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getLong(string);
        }
        return 0L;
    }

    public String getString(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.getString(string);
        }
        return "";
    }

    public boolean isDefault(String string) {
        IPreferenceStore iPreferenceStore = this.getVisibleStore(string);
        if (iPreferenceStore != null) {
            return iPreferenceStore.isDefault(string);
        }
        return false;
    }

    public boolean needsSaving() {
        throw new UnsupportedOperationException();
    }

    public void putValue(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String string, double d) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String string, float f) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String string, int n) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String string, long l) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String string, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setToDefault(String string) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String string, double d) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String string, float f) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String string, int n) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String string, long l) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String string, boolean bl) {
        throw new UnsupportedOperationException();
    }

    private void handlePropertyChangeEvent(IPreferenceStore iPreferenceStore, PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        IPreferenceStore iPreferenceStore2 = this.getVisibleStore(string);
        if (iPreferenceStore2 == null && object2 != null) {
            iPreferenceStore2 = iPreferenceStore;
        }
        if (iPreferenceStore2 == null) {
            if (object != null) {
                this.firePropertyChangeEvent(propertyChangeEvent);
            }
        } else if (iPreferenceStore2 == iPreferenceStore) {
            if (object != null) {
                this.firePropertyChangeEvent(propertyChangeEvent);
            } else {
                IPreferenceStore iPreferenceStore3 = null;
                int n = 0;
                int n2 = this.fPreferenceStores.length;
                while (n < n2 && this.fPreferenceStores[n++] != iPreferenceStore2) {
                }
                while (iPreferenceStore3 == null && n < n2) {
                    if (this.fPreferenceStores[n].contains(string)) {
                        iPreferenceStore3 = this.fPreferenceStores[n];
                    }
                    ++n;
                }
                if (iPreferenceStore3 == null) {
                    this.firePropertyChangeEvent(propertyChangeEvent);
                } else {
                    object = this.getOtherValue(string, iPreferenceStore3, object2);
                    if (!object.equals(object2)) {
                        this.firePropertyChangeEvent(string, object, object2);
                    }
                }
            }
        } else {
            boolean bl = false;
            int n = 0;
            int n3 = this.fPreferenceStores.length;
            while (n < n3) {
                IPreferenceStore iPreferenceStore4 = this.fPreferenceStores[n];
                if (iPreferenceStore4 == iPreferenceStore2) break;
                if (iPreferenceStore4 == iPreferenceStore) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl && !(object2 = this.getOtherValue(string, iPreferenceStore2, object)).equals(object)) {
                this.firePropertyChangeEvent(string, object, object2);
            }
        }
    }

    private Object getOtherValue(String string, IPreferenceStore iPreferenceStore, Object object) {
        if (object instanceof Boolean) {
            return iPreferenceStore.getBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object instanceof Double) {
            return new Double(iPreferenceStore.getDouble(string));
        }
        if (object instanceof Float) {
            return new Float(iPreferenceStore.getFloat(string));
        }
        if (object instanceof Integer) {
            return new Integer(iPreferenceStore.getInt(string));
        }
        if (object instanceof Long) {
            return new Long(iPreferenceStore.getLong(string));
        }
        if (object instanceof String) {
            return iPreferenceStore.getString(string);
        }
        return iPreferenceStore.getString(string);
    }

    private IPreferenceStore getVisibleStore(String string) {
        IPreferenceStore iPreferenceStore = null;
        int n = 0;
        int n2 = this.fPreferenceStores.length;
        while (n < n2 && iPreferenceStore == null) {
            IPreferenceStore iPreferenceStore2 = this.fPreferenceStores[n];
            if (iPreferenceStore2.contains(string)) {
                iPreferenceStore = iPreferenceStore2;
            }
            ++n;
        }
        return iPreferenceStore;
    }

    private void registerChildListeners() {
        for (PropertyChangeListener propertyChangeListener : this.fChildListeners) {
            propertyChangeListener.register();
        }
    }

    private void unregisterChildListeners() {
        for (PropertyChangeListener propertyChangeListener : this.fChildListeners) {
            propertyChangeListener.unregister();
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private IPreferenceStore fPreferenceStore;

        public PropertyChangeListener(IPreferenceStore iPreferenceStore) {
            this.setPreferenceStore(iPreferenceStore);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            ChainedPreferenceStore.this.handlePropertyChangeEvent(iPreferenceStore, propertyChangeEvent);
        }

        public void register() {
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void unregister() {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }

        public IPreferenceStore getPreferenceStore() {
            return this.fPreferenceStore;
        }

        public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
            this.fPreferenceStore = iPreferenceStore;
        }
    }
}

