/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public final class BasicMarkerUpdater
implements IMarkerUpdater {
    private static final String[] ATTRIBUTES = new String[]{"charStart", "charEnd", "lineNumber"};

    @Override
    public String[] getAttribute() {
        return ATTRIBUTES;
    }

    @Override
    public String getMarkerType() {
        return null;
    }

    @Override
    public boolean updateMarker(IMarker iMarker, IDocument iDocument, Position position) {
        if (position == null) {
            return true;
        }
        if (position.isDeleted()) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = MarkerUtilities.getCharStart(iMarker);
        int n2 = MarkerUtilities.getCharEnd(iMarker);
        if (n != -1 && n2 != -1) {
            bl = true;
            int n3 = position.getOffset();
            if (n != n3) {
                MarkerUtilities.setCharStart(iMarker, n3);
                bl2 = true;
            }
            if (n2 != (n3 += position.getLength())) {
                MarkerUtilities.setCharEnd(iMarker, n3);
                bl2 = true;
            }
        }
        if (!bl || bl2 && MarkerUtilities.getLineNumber(iMarker) != -1) {
            try {
                MarkerUtilities.setLineNumber(iMarker, iDocument.getLineOfOffset(position.getOffset()) + 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        return true;
    }
}

