/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.ui.texteditor.MarkerUtilities;

public final class AnnotationTypeLookup {
    private Map fMapping;

    public String getAnnotationType(IMarker iMarker) {
        String string = MarkerUtilities.getMarkerType(iMarker);
        if (string != null) {
            int n = MarkerUtilities.getSeverity(iMarker);
            return this.getAnnotationType(string, n);
        }
        return null;
    }

    public String getAnnotationType(String string, int n) {
        String string2 = this.lookupAnnotationType(string, n);
        if (string2 != null) {
            return string2;
        }
        String[] stringArray = MarkerUtilities.getSuperTypes(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            string2 = this.lookupAnnotationType(stringArray[n2], n);
            if (string2 != null) {
                return string2;
            }
            ++n2;
        }
        return null;
    }

    private String lookupAnnotationType(String string, int n) {
        Object v;
        if (this.fMapping == null) {
            this.initializeMapping();
        }
        if ((v = this.fMapping.get(string)) instanceof String) {
            return (String)v;
        }
        if (v instanceof Map) {
            Map map = (Map)v;
            return (String)map.get(new Integer(n));
        }
        return null;
    }

    private void initializeMapping() {
        this.fMapping = new HashMap();
        List list = this.getAnnotationTypeMappings();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            AnnotationTypeMapping annotationTypeMapping = (AnnotationTypeMapping)list.get(n);
            if (annotationTypeMapping.isMarkerSeverityDefined()) {
                Object object = this.fMapping.get(annotationTypeMapping.fMarkerType);
                if (!(object instanceof Map)) {
                    object = new HashMap();
                    this.fMapping.put(annotationTypeMapping.fMarkerType, object);
                }
                Map map = (Map)object;
                map.put(new Integer(annotationTypeMapping.fMarkerSeverity), annotationTypeMapping.fAnnotationType);
            } else {
                this.fMapping.put(annotationTypeMapping.fMarkerType, annotationTypeMapping.fAnnotationType);
            }
            ++n;
        }
    }

    private List getAnnotationTypeMappings() {
        ArrayList arrayList = new ArrayList();
        this.readExtensionPoint(arrayList, "markerAnnotationSpecification", "annotationType");
        this.readExtensionPoint(arrayList, "annotationTypes", "name");
        return arrayList;
    }

    private void readExtensionPoint(List list, String string, String string2) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", string);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                AnnotationTypeMapping annotationTypeMapping = this.createMapping(iConfigurationElementArray[n], string2);
                if (annotationTypeMapping != null) {
                    list.add(annotationTypeMapping);
                }
                ++n;
            }
        }
    }

    private AnnotationTypeMapping createMapping(IConfigurationElement iConfigurationElement, String string) {
        AnnotationTypeMapping annotationTypeMapping = new AnnotationTypeMapping();
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        annotationTypeMapping.fAnnotationType = string2;
        string2 = iConfigurationElement.getAttribute("markerType");
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        annotationTypeMapping.fMarkerType = string2;
        string2 = iConfigurationElement.getAttribute("markerSeverity");
        if (string2 != null && string2.trim().length() > 0) {
            annotationTypeMapping.fMarkerSeverity = StringConverter.asInt((String)string2, (int)-1);
        }
        return annotationTypeMapping;
    }

    private static class AnnotationTypeMapping {
        static final int UNDEFINED = -1;
        String fAnnotationType;
        String fMarkerType;
        int fMarkerSeverity = -1;

        private AnnotationTypeMapping() {
        }

        boolean isMarkerSeverityDefined() {
            return this.fMarkerSeverity != -1;
        }
    }
}

