/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.AnnotationType;
import org.eclipse.ui.internal.texteditor.AnnotationTypeHierarchy;
import org.eclipse.ui.internal.texteditor.DelegatingAnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class AnnotationPreferenceLookup {
    private Map fFragments;

    public AnnotationPreference getAnnotationPreference(Annotation annotation) {
        return this.getAnnotationPreference(annotation.getType());
    }

    public AnnotationPreference getAnnotationPreference(String string) {
        if (string == null || string == "org.eclipse.text.annotation.unknown") {
            return null;
        }
        AnnotationTypeHierarchy annotationTypeHierarchy = this.getAnnotationTypeHierarchy();
        AnnotationType annotationType = annotationTypeHierarchy.getAnnotationType(string);
        AnnotationPreference annotationPreference = annotationType.getPreference();
        if (annotationPreference == null) {
            annotationPreference = new DelegatingAnnotationPreference(annotationType, this);
            annotationType.setAnnotationPreference(annotationPreference);
        }
        return annotationPreference;
    }

    public AnnotationPreference getAnnotationPreferenceFragment(String string) {
        Map map = this.getPreferenceFragments();
        return (AnnotationPreference)map.get(string);
    }

    private AnnotationTypeHierarchy getAnnotationTypeHierarchy() {
        return EditorsPlugin.getDefault().getAnnotationTypeHierarchy();
    }

    private synchronized Map getPreferenceFragments() {
        if (this.fFragments == null) {
            this.fFragments = new HashMap();
            MarkerAnnotationPreferences markerAnnotationPreferences = new MarkerAnnotationPreferences();
            for (AnnotationPreference annotationPreference : markerAnnotationPreferences.getAnnotationPreferenceFragments()) {
                Object object = annotationPreference.getAnnotationType();
                AnnotationPreference annotationPreference2 = (AnnotationPreference)this.fFragments.get(object);
                if (annotationPreference2 == null) {
                    this.fFragments.put(object, annotationPreference);
                    continue;
                }
                annotationPreference2.merge(annotationPreference);
            }
        }
        return this.fFragments;
    }
}

