/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public class AddMarkerAction
extends TextEditorAction {
    private static final int MAX_LABEL_LENGTH = 80;
    private String fMarkerType;
    private boolean fAskForLabel;
    private ResourceBundle fBundle;
    private String fPrefix;

    public AddMarkerAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor, String string2, boolean bl) {
        super(resourceBundle, string, iTextEditor);
        this.fBundle = resourceBundle;
        this.fPrefix = string;
        this.fMarkerType = string2;
        this.fAskForLabel = bl;
    }

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected String getResourceKeyPrefix() {
        return this.fPrefix;
    }

    public void run() {
        IResource iResource = this.getResource();
        if (iResource == null) {
            return;
        }
        Map map = this.getInitialAttributes();
        if (this.fAskForLabel && !this.askForLabel(map)) {
            return;
        }
        String string = this.getToolTipText();
        string = string == null ? TextEditorMessages.AddMarkerAction_addMarker : string;
        final Shell shell = this.getTextEditor().getSite().getShell();
        IAdaptable iAdaptable = new IAdaptable(){

            public Object getAdapter(Class clazz) {
                if (clazz == Shell.class) {
                    return shell;
                }
                return null;
            }
        };
        CreateMarkersOperation createMarkersOperation = new CreateMarkersOperation(this.fMarkerType, map, iResource, string);
        IOperationHistory iOperationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        try {
            iOperationHistory.execute((IUndoableOperation)createMarkersOperation, null, iAdaptable);
        }
        catch (ExecutionException executionException) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog iLog = Platform.getLog((Bundle)bundle);
            String string2 = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "error.dialog.message"), (String)(String.valueOf(this.fPrefix) + "error.dialog.message"));
            iLog.log((IStatus)new Status(4, "org.eclipse.ui", 0, string2, (Throwable)executionException));
        }
    }

    public void update() {
        this.setEnabled(this.getResource() != null);
    }

    protected boolean askForLabel(Map map) {
        Object v = map.get("message");
        String string = v instanceof String ? (String)v : "";
        String string2 = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "dialog.title"), (String)(String.valueOf(this.fPrefix) + "dialog.title"));
        String string3 = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(String.valueOf(this.fPrefix) + "dialog.message"), (String)(String.valueOf(this.fPrefix) + "dialog.message"));
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                return string == null || string.trim().length() == 0 ? " " : null;
            }
        };
        InputDialog inputDialog = new InputDialog(this.getTextEditor().getSite().getShell(), string2, string3, string, iInputValidator);
        String string4 = null;
        if (inputDialog.open() != 1) {
            string4 = inputDialog.getValue();
        }
        if (string4 == null) {
            return false;
        }
        if ((string4 = string4.trim()).length() == 0) {
            return false;
        }
        map.put("message", string4);
        return true;
    }

    protected Map getInitialAttributes() {
        HashMap hashMap = new HashMap(11);
        ITextSelection iTextSelection = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
        if (!iTextSelection.isEmpty()) {
            int n = iTextSelection.getOffset();
            int n2 = iTextSelection.getLength();
            if (n2 < 0) {
                n2 = -n2;
                n -= n2;
            }
            MarkerUtilities.setCharStart(hashMap, n);
            MarkerUtilities.setCharEnd(hashMap, n + n2);
            int n3 = iTextSelection.getStartLine();
            MarkerUtilities.setLineNumber(hashMap, n3 == -1 ? -1 : n3 + 1);
            IDocument iDocument = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
            MarkerUtilities.setMessage(hashMap, this.getLabelProposal(iDocument, n, n2));
        }
        return hashMap;
    }

    protected String getLabelProposal(IDocument iDocument, int n, int n2) {
        char c;
        int n3;
        int n4;
        block10: {
            if (n2 > 0) {
                int n5 = 0;
                boolean bl = true;
                while (n5 < n2) {
                    boolean bl2 = Character.isWhitespace(iDocument.getChar(n + n5));
                    if (!bl && bl2) break;
                    if (bl && !bl2) {
                        bl = false;
                    }
                    ++n5;
                }
                String string = iDocument.get(n, n5);
                return string.trim();
            }
            n4 = n;
            int n6 = iDocument.getLineOfOffset(n);
            n3 = iDocument.getLineOffset(n6);
            while (n4 > n3) {
                c = iDocument.getChar(n4);
                if (Character.isWhitespace(c)) break;
                --n4;
            }
            n3 += iDocument.getLineLength(n6);
            while (n4 <= n3) {
                c = iDocument.getChar(n4);
                if (!Character.isWhitespace(c)) break;
                ++n4;
            }
            if (n4 <= n3) break block10;
            return null;
        }
        try {
            n3 = Math.min(n3, n4 + 80);
            int n7 = n + n2 > n3 ? n3 : n + n2;
            while (n7 < n3) {
                c = iDocument.getChar(n7);
                if (Character.isWhitespace(c)) break;
                ++n7;
            }
            if (n4 != n7) {
                String string = iDocument.get(n4, n7 - n4);
                return string.trim();
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    protected IResource getResource() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor != null) {
            IEditorInput iEditorInput = iTextEditor.getEditorInput();
            return (IResource)iEditorInput.getAdapter(IResource.class);
        }
        return null;
    }
}

