/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.IPersistableAnnotationModel;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationMap;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.osgi.framework.Bundle;

public abstract class AbstractMarkerAnnotationModel
extends AnnotationModel
implements IPersistableAnnotationModel {
    private List fDeletedAnnotations = new ArrayList(2);
    private List fInstantiatedMarkerUpdaters = null;
    private List fMarkerUpdaterSpecifications = null;

    protected abstract IMarker[] retrieveMarkers() throws CoreException;

    protected abstract void deleteMarkers(IMarker[] var1) throws CoreException;

    protected abstract void listenToMarkerChanges(boolean var1);

    protected abstract boolean isAcceptable(IMarker var1);

    protected AbstractMarkerAnnotationModel() {
    }

    protected void addMarkerUpdater(IMarkerUpdater iMarkerUpdater) {
        if (!this.fInstantiatedMarkerUpdaters.contains(iMarkerUpdater)) {
            this.fInstantiatedMarkerUpdaters.add(iMarkerUpdater);
        }
    }

    protected void removeMarkerUpdater(IMarkerUpdater iMarkerUpdater) {
        this.fInstantiatedMarkerUpdaters.remove(iMarkerUpdater);
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker iMarker) {
        return new MarkerAnnotation(iMarker);
    }

    protected void handleCoreException(CoreException coreException, String string) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog iLog = Platform.getLog((Bundle)bundle);
        if (string != null) {
            iLog.log((IStatus)new Status(4, "org.eclipse.ui", 0, string, (Throwable)coreException));
        } else {
            iLog.log(coreException.getStatus());
        }
    }

    protected Position createPositionFromMarker(IMarker iMarker) {
        int n;
        int n2;
        int n3 = MarkerUtilities.getCharStart(iMarker);
        if (n3 > (n2 = MarkerUtilities.getCharEnd(iMarker))) {
            n2 = n3 + n2;
            n3 = n2 - n3;
            n2 -= n3;
        }
        if (n3 == -1 && n2 == -1 && (n = MarkerUtilities.getLineNumber(iMarker)) > 0 && this.fDocument != null) {
            try {
                n2 = n3 = this.fDocument.getLineOffset(n - 1);
            }
            catch (BadLocationException badLocationException) {}
        }
        if (n3 > -1 && n2 > -1) {
            return new Position(n3, n2 - n3);
        }
        return null;
    }

    protected final void addMarkerAnnotation(IMarker iMarker) {
        Position position;
        if (this.isAcceptable(iMarker) && (position = this.createPositionFromMarker(iMarker)) != null) {
            try {
                MarkerAnnotation markerAnnotation = this.createMarkerAnnotation(iMarker);
                if (markerAnnotation != null) {
                    this.addAnnotation(markerAnnotation, position, false);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected void connected() {
        block2: {
            this.listenToMarkerChanges(true);
            try {
                this.catchupWithMarkers();
            }
            catch (CoreException coreException) {
                if (coreException.getStatus().getCode() == 368) break block2;
                this.handleCoreException(coreException, TextEditorMessages.AbstractMarkerAnnotationModel_connected);
            }
        }
        this.fireModelChanged();
    }

    private void installMarkerUpdaters() {
        this.fMarkerUpdaterSpecifications = new ArrayList(2);
        this.fInstantiatedMarkerUpdaters = new ArrayList(2);
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "markerUpdaters");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                this.fMarkerUpdaterSpecifications.add(iConfigurationElementArray[n]);
                ++n;
            }
        }
    }

    private void uninstallMarkerUpdaters() {
        if (this.fInstantiatedMarkerUpdaters != null) {
            this.fInstantiatedMarkerUpdaters.clear();
            this.fInstantiatedMarkerUpdaters = null;
        }
        if (this.fMarkerUpdaterSpecifications != null) {
            this.fMarkerUpdaterSpecifications.clear();
            this.fMarkerUpdaterSpecifications = null;
        }
    }

    protected void disconnected() {
        this.listenToMarkerChanges(false);
        this.uninstallMarkerUpdaters();
    }

    public Position getMarkerPosition(IMarker iMarker) {
        MarkerAnnotation markerAnnotation = this.getMarkerAnnotation(iMarker);
        if (markerAnnotation != null) {
            return (Position)this.getAnnotationMap().get((Object)markerAnnotation);
        }
        return null;
    }

    protected void modifyMarkerAnnotation(IMarker iMarker) {
        MarkerAnnotation markerAnnotation = this.getMarkerAnnotation(iMarker);
        if (markerAnnotation != null) {
            Position position = this.createPositionFromMarker(iMarker);
            if (position != null) {
                markerAnnotation.update();
                this.modifyAnnotationPosition(markerAnnotation, position, false);
            }
        } else {
            this.addMarkerAnnotation(iMarker);
        }
    }

    protected void removeAnnotations(List list, boolean bl, boolean bl2) {
        if (list != null && list.size() > 0) {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
            for (Annotation annotation : list) {
                if (annotation instanceof MarkerAnnotation) {
                    arrayList.add(annotation);
                }
                this.removeAnnotation(annotation, false);
            }
            if (arrayList.size() > 0) {
                if (bl2) {
                    this.listenToMarkerChanges(false);
                    try {
                        IMarker[] iMarkerArray = new IMarker[arrayList.size()];
                        int n = 0;
                        while (n < iMarkerArray.length) {
                            MarkerAnnotation markerAnnotation = (MarkerAnnotation)((Object)arrayList.get(n));
                            iMarkerArray[n] = markerAnnotation.getMarker();
                            ++n;
                        }
                        this.deleteMarkers(iMarkerArray);
                    }
                    catch (CoreException coreException) {
                        this.handleCoreException(coreException, TextEditorMessages.AbstractMarkerAnnotationModel_removeAnnotations);
                    }
                    this.listenToMarkerChanges(true);
                } else {
                    this.fDeletedAnnotations.addAll(arrayList);
                }
            }
            if (bl) {
                this.fireModelChanged();
            }
        }
    }

    protected final void removeMarkerAnnotation(IMarker iMarker) {
        MarkerAnnotation markerAnnotation = this.getMarkerAnnotation(iMarker);
        if (markerAnnotation != null) {
            this.removeAnnotation(markerAnnotation, false);
        }
    }

    private void catchupWithMarkers() throws CoreException {
        IMarker[] iMarkerArray = this.getAnnotationIterator(false);
        while (iMarkerArray.hasNext()) {
            Annotation annotation = (Annotation)iMarkerArray.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            this.removeAnnotation(annotation, false);
        }
        iMarkerArray = this.retrieveMarkers();
        if (iMarkerArray != null) {
            int n = 0;
            while (n < iMarkerArray.length) {
                this.addMarkerAnnotation(iMarkerArray[n]);
                ++n;
            }
        }
    }

    public final MarkerAnnotation getMarkerAnnotation(IMarker iMarker) {
        Iterator iterator = this.getAnnotationIterator(false);
        while (iterator.hasNext()) {
            MarkerAnnotation markerAnnotation;
            Object e = iterator.next();
            if (!(e instanceof MarkerAnnotation) || !iMarker.equals((Object)(markerAnnotation = (MarkerAnnotation)((Object)e)).getMarker())) continue;
            return markerAnnotation;
        }
        return null;
    }

    private IMarkerUpdater createMarkerUpdater(IConfigurationElement iConfigurationElement) {
        try {
            return (IMarkerUpdater)iConfigurationElement.createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, TextEditorMessages.AbstractMarkerAnnotationModel_createMarkerUpdater);
            return null;
        }
    }

    private void checkMarkerUpdaters(IMarker iMarker) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        int n = 0;
        while (n < this.fMarkerUpdaterSpecifications.size()) {
            IConfigurationElement iConfigurationElement = (IConfigurationElement)this.fMarkerUpdaterSpecifications.get(n);
            String string = iConfigurationElement.getAttribute("markerType");
            if (string == null || MarkerUtilities.isMarkerType(iMarker, string)) {
                arrayList.add(iConfigurationElement);
                IMarkerUpdater iMarkerUpdater = this.createMarkerUpdater(iConfigurationElement);
                if (iMarkerUpdater != null) {
                    this.addMarkerUpdater(iMarkerUpdater);
                }
            }
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            this.fMarkerUpdaterSpecifications.remove(arrayList.get(n));
            ++n;
        }
    }

    public boolean updateMarker(IMarker iMarker, IDocument iDocument, Position position) throws CoreException {
        if (this.fMarkerUpdaterSpecifications == null) {
            this.installMarkerUpdaters();
        }
        if (!this.fMarkerUpdaterSpecifications.isEmpty()) {
            this.checkMarkerUpdaters(iMarker);
        }
        boolean bl = true;
        int n = 0;
        while (n < this.fInstantiatedMarkerUpdaters.size()) {
            IMarkerUpdater iMarkerUpdater = (IMarkerUpdater)this.fInstantiatedMarkerUpdaters.get(n);
            String string = iMarkerUpdater.getMarkerType();
            if (string == null || MarkerUtilities.isMarkerType(iMarker, string)) {
                if (position == null) {
                    position = this.createPositionFromMarker(iMarker);
                }
                bl = bl && iMarkerUpdater.updateMarker(iMarker, iDocument, position);
            }
            ++n;
        }
        return bl;
    }

    public boolean updateMarker(IDocument iDocument, IMarker iMarker, Position position) throws CoreException {
        this.listenToMarkerChanges(false);
        try {
            boolean bl = this.updateMarker(iMarker, iDocument, position);
            return bl;
        }
        finally {
            this.listenToMarkerChanges(true);
        }
    }

    public void updateMarkers(IDocument iDocument) throws CoreException {
        Assert.isTrue((this.fDocument == iDocument ? 1 : 0) != 0);
        IAnnotationMap iAnnotationMap = this.getAnnotationMap();
        if (iAnnotationMap.size() == 0 && this.fDeletedAnnotations.size() == 0) {
            return;
        }
        if (this.fMarkerUpdaterSpecifications == null) {
            this.installMarkerUpdaters();
        }
        this.listenToMarkerChanges(false);
        try {
            Iterator iterator = this.getAnnotationIterator(false);
            while (iterator.hasNext()) {
                Position position;
                MarkerAnnotation markerAnnotation;
                IMarker iMarker;
                Object e = iterator.next();
                if (!(e instanceof MarkerAnnotation) || this.updateMarker(iMarker = (markerAnnotation = (MarkerAnnotation)((Object)e)).getMarker(), iDocument, position = (Position)iAnnotationMap.get((Object)markerAnnotation)) || this.fDeletedAnnotations.contains((Object)markerAnnotation)) continue;
                this.fDeletedAnnotations.add(markerAnnotation);
            }
            if (!this.fDeletedAnnotations.isEmpty()) {
                this.removeAnnotations(this.fDeletedAnnotations, true, true);
                this.fDeletedAnnotations.clear();
            }
        }
        finally {
            this.listenToMarkerChanges(true);
        }
    }

    public void resetMarkers() {
        MarkerAnnotation markerAnnotation;
        Position position;
        Iterator iterator = this.getAnnotationIterator(false);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MarkerAnnotation) || (position = this.createPositionFromMarker((markerAnnotation = (MarkerAnnotation)((Object)e)).getMarker())) == null) continue;
            this.removeAnnotation(markerAnnotation, false);
            try {
                this.addAnnotation(markerAnnotation, position, false);
            }
            catch (BadLocationException badLocationException) {}
        }
        for (Object e : this.fDeletedAnnotations) {
            if (!(e instanceof MarkerAnnotation) || (position = this.createPositionFromMarker((markerAnnotation = (MarkerAnnotation)((Object)e)).getMarker())) == null) continue;
            try {
                this.addAnnotation(markerAnnotation, position, false);
            }
            catch (BadLocationException badLocationException) {}
        }
        this.fDeletedAnnotations.clear();
        this.fireModelChanged();
    }

    public void commit(IDocument iDocument) throws CoreException {
        this.updateMarkers(iDocument);
    }

    public void revert(IDocument iDocument) {
        this.resetMarkers();
    }

    public void reinitialize(IDocument iDocument) {
        this.resetMarkers();
    }
}

