/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.EditorsPluginPreferenceInitializer;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class AbstractDecoratedTextEditorPreferenceConstants {
    public static final String EDITOR_CURRENT_LINE = "currentLine";
    public static final String EDITOR_CURRENT_LINE_COLOR = "currentLineColor";
    public static final String EDITOR_TAB_WIDTH = "tabWidth";
    public static final String EDITOR_SPACES_FOR_TABS = "spacesForTabs";
    public static final String EDITOR_UNDO_HISTORY_SIZE = "undoHistorySize";
    public static final String EDITOR_PRINT_MARGIN = "printMargin";
    public static final String EDITOR_PRINT_MARGIN_COLOR = "printMarginColor";
    public static final String EDITOR_PRINT_MARGIN_COLUMN = "printMarginColumn";
    public static final String EDITOR_UNKNOWN_INDICATION = "othersIndication";
    public static final String EDITOR_UNKNOWN_INDICATION_COLOR = "othersIndicationColor";
    public static final String EDITOR_UNKNOWN_INDICATION_IN_OVERVIEW_RULER = "othersIndicationInOverviewRuler";
    public static final String EDITOR_OVERVIEW_RULER = "overviewRuler";
    public static final String EDITOR_LINE_NUMBER_RULER = "lineNumberRuler";
    public static final String EDITOR_LINE_NUMBER_RULER_COLOR = "lineNumberColor";
    public static final String USE_ANNOTATIONS_PREFERENCE_PAGE = "useAnnotationsPrefPage";
    public static final String USE_QUICK_DIFF_PREFERENCE_PAGE = "useQuickDiffPrefPage";
    public static final String QUICK_DIFF_ALWAYS_ON = "quickdiff.quickDiff";
    public static final String QUICK_DIFF_DEFAULT_PROVIDER = "quickdiff.defaultProvider";
    public static final String QUICK_DIFF_CHARACTER_MODE = "quickdiff.characterMode";
    public static final String EDITOR_USE_CUSTOM_CARETS = "AbstractTextEditor.Accessibility.UseCustomCarets";
    public static final String EDITOR_WIDE_CARET = "AbstractTextEditor.Accessibility.WideCaret";
    public static final String USE_SATURATED_COLORS_IN_OVERVIEW_RULER = "Accessibility.UseSaturatedColors";
    public static final String EDITOR_SELECTION_FOREGROUND_COLOR = "AbstractTextEditor.Color.SelectionForeground";
    public static final String EDITOR_SELECTION_FOREGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.SelectionForeground.SystemDefault";
    public static final String EDITOR_SELECTION_BACKGROUND_COLOR = "AbstractTextEditor.Color.SelectionBackground";
    public static final String EDITOR_SELECTION_BACKGROUND_DEFAULT_COLOR = "AbstractTextEditor.Color.SelectionBackground.SystemDefault";
    public static final String EDITOR_HYPERLINKS_ENABLED = "hyperlinksEnabled";
    public static final String EDITOR_HYPERLINK_KEY_MODIFIER = "hyperlinkKeyModifier";
    public static final String EDITOR_HYPERLINK_KEY_MODIFIER_MASK = "hyperlinkKeyModifierMask";
    public static final String EDITOR_HYPERLINK_COLOR = "hyperlinkColor";
    public static final String EDITOR_HYPERLINK_COLOR_SYSTEM_DEFAULT = "hyperlinkColor.SystemDefault";
    public static final String EDITOR_DISABLE_OVERWRITE_MODE = "disable_overwrite_mode";
    public static final String EDITOR_WARN_IF_INPUT_DERIVED = "warn_if_input_derived";
    public static final String EDITOR_SMART_HOME_END = "AbstractTextEditor.Navigation.SmartHomeEnd";
    public static final String EDITOR_SHOW_WHITESPACE_CHARACTERS = "showWhitespaceCharacters";
    public static final String EDITOR_SHOW_LEADING_SPACES = "showLeadingSpaces";
    public static final String EDITOR_SHOW_ENCLOSED_SPACES = "showEnclosedSpaces";
    public static final String EDITOR_SHOW_TRAILING_SPACES = "showTrailingSpaces";
    public static final String EDITOR_SHOW_LEADING_IDEOGRAPHIC_SPACES = "showLeadingIdeographicSpaces";
    public static final String EDITOR_SHOW_ENCLOSED_IDEOGRAPHIC_SPACES = "showEnclosedIdeographicSpaces";
    public static final String EDITOR_SHOW_TRAILING_IDEOGRAPHIC_SPACES = "showTrailingIdeographicSpaces";
    public static final String EDITOR_SHOW_LEADING_TABS = "showLeadingTabs";
    public static final String EDITOR_SHOW_ENCLOSED_TABS = "showEnclosedTabs";
    public static final String EDITOR_SHOW_TRAILING_TABS = "showTrailingTabs";
    public static final String EDITOR_SHOW_CARRIAGE_RETURN = "showCarriageReturn";
    public static final String EDITOR_SHOW_LINE_FEED = "showLineFeed";
    public static final String EDITOR_WHITESPACE_CHARACTER_ALPHA_VALUE = "whitespaceCharacterAlphaValue";
    public static final String SHOW_RANGE_INDICATOR = "show_range_indicator";
    public static final String REVISION_ASK_BEFORE_QUICKDIFF_SWITCH = "quickdiff.nowarn.before.switch";
    public static final String REVISION_RULER_RENDERING_MODE = "revisionRulerRenderingMode";
    public static final String REVISION_RULER_SHOW_AUTHOR = "revisionRulerShowAuthor";
    public static final String REVISION_RULER_SHOW_REVISION = "revisionRulerShowRevision";
    public static final String EDITOR_TEXT_DRAG_AND_DROP_ENABLED = "textDragAndDropEnabled";
    public static final String EDITOR_SHOW_TEXT_HOVER_AFFORDANCE = "showTextHoverAffordance";
    public static final String EDITOR_HOVER_ENRICH_MODE = "hoverReplaceMode";

    private AbstractDecoratedTextEditorPreferenceConstants() {
    }

    public static void initializeDefaultValues(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault(USE_ANNOTATIONS_PREFERENCE_PAGE, false);
        iPreferenceStore.setDefault(USE_QUICK_DIFF_PREFERENCE_PAGE, false);
        iPreferenceStore.setDefault(EDITOR_CURRENT_LINE, true);
        iPreferenceStore.setDefault(EDITOR_TAB_WIDTH, 4);
        iPreferenceStore.setDefault(EDITOR_SPACES_FOR_TABS, false);
        iPreferenceStore.setDefault(EDITOR_UNDO_HISTORY_SIZE, 200);
        iPreferenceStore.setDefault(EDITOR_PRINT_MARGIN, false);
        iPreferenceStore.setDefault(EDITOR_PRINT_MARGIN_COLUMN, 80);
        iPreferenceStore.setDefault(EDITOR_LINE_NUMBER_RULER, false);
        if (!iPreferenceStore.getBoolean(USE_QUICK_DIFF_PREFERENCE_PAGE)) {
            iPreferenceStore.setDefault(QUICK_DIFF_ALWAYS_ON, true);
            iPreferenceStore.setDefault(QUICK_DIFF_CHARACTER_MODE, false);
            iPreferenceStore.setDefault(QUICK_DIFF_DEFAULT_PROVIDER, "org.eclipse.ui.internal.editors.quickdiff.LastSaveReferenceProvider");
        }
        iPreferenceStore.setDefault(EDITOR_OVERVIEW_RULER, true);
        iPreferenceStore.setDefault(EDITOR_UNKNOWN_INDICATION, false);
        iPreferenceStore.setDefault(EDITOR_UNKNOWN_INDICATION_IN_OVERVIEW_RULER, false);
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)EDITOR_UNKNOWN_INDICATION_COLOR, (RGB)new RGB(0, 0, 0));
        iPreferenceStore.setDefault(EDITOR_USE_CUSTOM_CARETS, false);
        iPreferenceStore.setDefault(EDITOR_WIDE_CARET, true);
        iPreferenceStore.setDefault(USE_SATURATED_COLORS_IN_OVERVIEW_RULER, false);
        iPreferenceStore.setDefault(EDITOR_SELECTION_FOREGROUND_DEFAULT_COLOR, true);
        iPreferenceStore.setDefault(EDITOR_SELECTION_BACKGROUND_DEFAULT_COLOR, true);
        iPreferenceStore.setDefault("AbstractTextEditor.Color.Background.SystemDefault", true);
        iPreferenceStore.setDefault("AbstractTextEditor.Color.Foreground.SystemDefault", true);
        String string = Action.findModifierString((int)SWT.MOD1);
        iPreferenceStore.setDefault(EDITOR_HYPERLINKS_ENABLED, true);
        iPreferenceStore.setDefault(EDITOR_HYPERLINK_COLOR_SYSTEM_DEFAULT, true);
        iPreferenceStore.setDefault(EDITOR_HYPERLINK_KEY_MODIFIER, string);
        iPreferenceStore.setDefault(EDITOR_HYPERLINK_KEY_MODIFIER_MASK, SWT.MOD1);
        HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
        int n = 0;
        while (n < hyperlinkDetectorDescriptorArray.length) {
            int n2 = AbstractDecoratedTextEditorPreferenceConstants.computeStateMask(hyperlinkDetectorDescriptorArray[n].getModifierKeys());
            if (n2 == 131072) {
                EditorsPlugin.logErrorMessage("The '" + hyperlinkDetectorDescriptorArray[n].getId() + "' hyperlink detector specifies 'Shift' as modifier. This is not allowed and hence replaced with the default modifier.");
                n2 = -1;
            }
            iPreferenceStore.setDefault(String.valueOf(hyperlinkDetectorDescriptorArray[n].getId()) + "_stateMask", n2);
            ++n;
        }
        n = EditorsUI.getSpellingService().getSpellingEngineDescriptors().length > 0 ? 1 : 0;
        iPreferenceStore.setDefault("spellingEnabled", n != 0);
        iPreferenceStore.setDefault("spellingEngine", "");
        iPreferenceStore.setDefault(SHOW_RANGE_INDICATOR, true);
        iPreferenceStore.setDefault(REVISION_ASK_BEFORE_QUICKDIFF_SWITCH, "");
        iPreferenceStore.setDefault("rulerContributions", "");
        iPreferenceStore.setDefault(REVISION_RULER_RENDERING_MODE, IRevisionRulerColumnExtension.AGE.name());
        iPreferenceStore.setDefault(REVISION_RULER_SHOW_AUTHOR, false);
        iPreferenceStore.setDefault(REVISION_RULER_SHOW_REVISION, false);
        iPreferenceStore.setDefault(EDITOR_WARN_IF_INPUT_DERIVED, true);
        iPreferenceStore.setDefault(EDITOR_SMART_HOME_END, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_WHITESPACE_CHARACTERS, false);
        iPreferenceStore.setDefault(EDITOR_SHOW_LEADING_SPACES, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_ENCLOSED_SPACES, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_TRAILING_SPACES, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_LEADING_IDEOGRAPHIC_SPACES, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_ENCLOSED_IDEOGRAPHIC_SPACES, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_TRAILING_IDEOGRAPHIC_SPACES, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_LEADING_TABS, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_ENCLOSED_TABS, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_TRAILING_TABS, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_CARRIAGE_RETURN, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_LINE_FEED, true);
        iPreferenceStore.setDefault(EDITOR_WHITESPACE_CHARACTER_ALPHA_VALUE, 80);
        iPreferenceStore.setDefault(EDITOR_TEXT_DRAG_AND_DROP_ENABLED, true);
        iPreferenceStore.setDefault(EDITOR_SHOW_TEXT_HOVER_AFFORDANCE, true);
        iPreferenceStore.setDefault(EDITOR_HOVER_ENRICH_MODE, 0);
        MarkerAnnotationPreferences.initializeDefaultValues(iPreferenceStore);
        EditorsPluginPreferenceInitializer.setThemeBasedPreferences(iPreferenceStore, false);
    }

    private static final int computeStateMask(String string) {
        if (string == null) {
            return -1;
        }
        if (string.length() == 0) {
            return 0;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;.:+-* ");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = AbstractDecoratedTextEditorPreferenceConstants.findLocalizedModifier(stringTokenizer.nextToken());
            if (n2 == 0 || (n & n2) == n2) {
                return -1;
            }
            n |= n2;
        }
        return n;
    }

    private static final int findLocalizedModifier(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("M1")) {
            return SWT.MOD1;
        }
        if (string.equalsIgnoreCase("M2")) {
            return SWT.MOD2;
        }
        if (string.equalsIgnoreCase("M3")) {
            return SWT.MOD3;
        }
        if (string.equalsIgnoreCase("M4")) {
            return SWT.MOD4;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }
}

