/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.ChangeRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension2;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IOverviewRulerExtension;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.LineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.ITextEditorHelpContextIds;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.editors.quickdiff.CompositeRevertAction;
import org.eclipse.ui.internal.editors.quickdiff.RestoreAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertBlockAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertLineAction;
import org.eclipse.ui.internal.editors.quickdiff.RevertSelectionAction;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.RefreshEditorAction;
import org.eclipse.ui.internal.texteditor.AnnotationColumn;
import org.eclipse.ui.internal.texteditor.BooleanPreferenceToggleAction;
import org.eclipse.ui.internal.texteditor.FocusedInformationPresenter;
import org.eclipse.ui.internal.texteditor.LineNumberColumn;
import org.eclipse.ui.internal.texteditor.TextChangeHover;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.operations.NonLocalUndoUserApprover;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AddMarkerAction;
import org.eclipse.ui.texteditor.AddTaskAction;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ChangeEncodingAction;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.RevisionHoverInformationControlCreator;
import org.eclipse.ui.texteditor.ShowWhitespaceCharactersAction;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorMessages;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnPreferenceAdapter;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.eclipse.ui.views.markers.MarkerViewUtil;

public abstract class AbstractDecoratedTextEditor
extends StatusTextEditor {
    private static final String LINE_NUMBER_RULER = "lineNumberRuler";
    private static final String OVERVIEW_RULER = "overviewRuler";
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private static final String PRINT_MARGIN = "printMargin";
    private static final String PRINT_MARGIN_COLOR = "printMarginColor";
    private static final String PRINT_MARGIN_COLUMN = "printMarginColumn";
    private static final String DISABLE_OVERWRITE_MODE = "disable_overwrite_mode";
    public static final String DEFAULT_OVERVIEW_RULER_CONTEXT_MENU_ID = "#OverviewRulerContext";
    private static final String USE_SATURATED_COLORS_IN_OVERVIEW_RULER = "Accessibility.UseSaturatedColors";
    private MarkerAnnotationPreferences fAnnotationPreferences;
    protected IOverviewRuler fOverviewRuler;
    private String fOverviewRulerContextMenuId;
    protected IAnnotationAccess fAnnotationAccess;
    protected SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    protected LineNumberRulerColumn fLineNumberRulerColumn;
    private LineNumberColumn fLineColumn;
    private IDocumentProvider fImplicitDocumentProvider;
    private Object fGotoMarkerAdapter = new GotoMarkerAdapter();
    protected boolean fIsUpdatingMarkerViews = false;
    private boolean fIsComingFromGotoMarker = false;
    private boolean fIsEditingDerivedFileAllowed = true;
    private boolean fIsDerivedStateValidated = false;
    private FocusedInformationPresenter fInformationPresenter;

    private IVerticalRuler internalGetVerticalRuler() {
        return this.getVerticalRuler();
    }

    public AbstractDecoratedTextEditor() {
        this.fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.initializeKeyBindingScopes();
        this.initializeEditor();
    }

    protected void initializeEditor() {
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
    }

    public void dispose() {
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        this.fAnnotationAccess = null;
        this.fAnnotationPreferences = null;
        this.fLineNumberRulerColumn = null;
        this.fLineColumn = null;
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.uninstall();
            this.fInformationPresenter = null;
        }
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SourceViewer sourceViewer = new SourceViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n);
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        return sourceViewer;
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsPlugin.getDefault().getSharedTextColors();
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors iSharedTextColors) {
        OverviewRuler overviewRuler = new OverviewRuler(this.getAnnotationAccess(), 12, iSharedTextColors);
        for (AnnotationPreference annotationPreference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!annotationPreference.contributesToHeader()) continue;
            overviewRuler.addHeaderAnnotationType(annotationPreference.getAnnotationType());
        }
        return overviewRuler;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        Iterator iterator = this.fAnnotationPreferences.getAnnotationPreferences().iterator();
        while (iterator.hasNext()) {
            sourceViewerDecorationSupport.setAnnotationPreference((AnnotationPreference)iterator.next());
        }
        sourceViewerDecorationSupport.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        sourceViewerDecorationSupport.setMarginPainterPreferenceKeys(PRINT_MARGIN, PRINT_MARGIN_COLOR, PRINT_MARGIN_COLUMN);
        sourceViewerDecorationSupport.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    public void createPartControl(Composite composite) {
        RulerColumnDescriptor rulerColumnDescriptor;
        super.createPartControl(composite);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        IColumnSupport iColumnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
        if (this.isLineNumberRulerVisible() && (rulerColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers")) != null) {
            iColumnSupport.setColumnVisible(rulerColumnDescriptor, true);
        }
        if (this.isPrefQuickDiffAlwaysOn()) {
            this.showChangeInformation(true);
        }
        if (this.fOverviewRuler instanceof IOverviewRulerExtension) {
            ((IOverviewRulerExtension)this.fOverviewRuler).setUseSaturatedColors(this.isPrefUseSaturatedColorsOn());
        }
        if (!this.isOverwriteModeEnabled()) {
            this.enableOverwriteMode(false);
        }
        if (!this.isRangeIndicatorEnabled()) {
            this.getSourceViewer().removeRangeIndication();
            this.getSourceViewer().setRangeIndicator(null);
        }
        rulerColumnDescriptor = this.getSourceViewer();
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension2 && rulerColumnDescriptor instanceof ISourceViewerExtension3) {
            ((IAnnotationAccessExtension2)this.fAnnotationAccess).setQuickAssistAssistant(((ISourceViewerExtension3)rulerColumnDescriptor).getQuickAssistAssistant());
        }
        this.createOverviewRulerContextMenu();
    }

    protected void createOverviewRulerContextMenu() {
        if (this.fOverviewRulerContextMenuId == null) {
            this.fOverviewRulerContextMenuId = DEFAULT_OVERVIEW_RULER_CONTEXT_MENU_ID;
        }
        if (this.fOverviewRuler == null || this.fOverviewRuler.getControl() == null) {
            return;
        }
        MenuManager menuManager = new MenuManager(this.fOverviewRulerContextMenuId, this.fOverviewRulerContextMenuId);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.getContextMenuListener());
        Menu menu = menuManager.createContextMenu(this.getOverviewRuler().getControl());
        this.getOverviewRuler().getControl().setMenu(menu);
        this.getEditorSite().registerContextMenu(this.fOverviewRulerContextMenuId, menuManager, this.getSelectionProvider(), false);
    }

    protected IMenuListener createContextMenuListener() {
        final IMenuListener iMenuListener = super.createContextMenuListener();
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                if (!AbstractDecoratedTextEditor.this.getOverviewRulerContextMenuId().equals(iMenuManager.getId())) {
                    iMenuListener.menuAboutToShow(iMenuManager);
                    return;
                }
                AbstractDecoratedTextEditor.this.setFocus();
                AbstractDecoratedTextEditor.this.overviewRulerContextMenuAboutToShow(iMenuManager);
            }
        };
    }

    protected Control createStatusControl(Composite composite, IStatus iStatus) {
        Object object = this.getAdapter(IEncodingSupport.class);
        DefaultEncodingSupport defaultEncodingSupport = null;
        if (object instanceof DefaultEncodingSupport) {
            defaultEncodingSupport = (DefaultEncodingSupport)object;
        }
        if (defaultEncodingSupport == null || !defaultEncodingSupport.isEncodingError(iStatus)) {
            return super.createStatusControl(composite, iStatus);
        }
        Shell shell = this.getSite().getShell();
        Display display = shell.getDisplay();
        Color color = display.getSystemColor(25);
        Color color2 = display.getSystemColor(24);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setBackground(color);
        composite2.setForeground(color2);
        Control control = super.createStatusControl(composite2, iStatus);
        control.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(1808));
        composite3.setBackground(color);
        composite3.setForeground(color2);
        defaultEncodingSupport.createStatusEncodingChangeControl(composite3, iStatus);
        return composite2;
    }

    protected boolean isOverviewRulerVisible() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore != null ? iPreferenceStore.getBoolean(OVERVIEW_RULER) : false;
    }

    public void showChangeInformation(boolean bl) {
        if (bl == this.isChangeInformationShowing()) {
            return;
        }
        IColumnSupport iColumnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
        if (bl && this.fLineColumn == null) {
            RulerColumnDescriptor rulerColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers");
            if (rulerColumnDescriptor != null) {
                iColumnSupport.setColumnVisible(rulerColumnDescriptor, true);
            }
        } else if (!bl && this.fLineColumn != null && !this.isLineNumberRulerVisible()) {
            iColumnSupport.setColumnVisible(this.fLineColumn.getDescriptor(), false);
            this.fLineColumn = null;
        }
    }

    public boolean isChangeInformationShowing() {
        return this.fLineColumn != null && this.fLineColumn.isShowingChangeInformation();
    }

    public void showRevisionInformation(RevisionInformation revisionInformation, String string) {
        if (revisionInformation.getHoverControlCreator() == null) {
            revisionInformation.setHoverControlCreator((IInformationControlCreator)new RevisionHoverInformationControlCreator(false));
        }
        if (revisionInformation.getInformationPresenterControlCreator() == null) {
            revisionInformation.setInformationPresenterControlCreator((IInformationControlCreator)new RevisionHoverInformationControlCreator(true));
        }
        this.showChangeInformation(true);
        if (this.fLineColumn != null) {
            this.fLineColumn.showRevisionInformation(revisionInformation, string);
        }
    }

    protected boolean isLineNumberRulerVisible() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore != null ? iPreferenceStore.getBoolean(LINE_NUMBER_RULER) : false;
    }

    protected boolean isOverwriteModeEnabled() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore != null ? !iPreferenceStore.getBoolean(DISABLE_OVERWRITE_MODE) : true;
    }

    private boolean isRangeIndicatorEnabled() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore != null ? iPreferenceStore.getBoolean("show_range_indicator") : true;
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        boolean bl;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl2 = bl = iPreferenceStore != null ? iPreferenceStore.getBoolean("quickdiff.quickDiff") : false;
        return bl && this.isEditorInputModifiable();
    }

    private boolean isPrefUseSaturatedColorsOn() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore != null ? iPreferenceStore.getBoolean(USE_SATURATED_COLORS_IN_OVERVIEW_RULER) : false;
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn lineNumberRulerColumn) {
        if (this.fLineColumn != null) {
            this.fLineColumn.initializeLineNumberRulerColumn(lineNumberRulerColumn);
        }
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new LineNumberChangeRulerColumn(this.getSharedColors());
        ((IChangeRulerColumn)this.fLineNumberRulerColumn).setHover((IAnnotationHover)this.createChangeHover());
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected LineChangeHover createChangeHover() {
        return new TextChangeHover();
    }

    protected IChangeRulerColumn createChangeRulerColumn() {
        return new ChangeRulerColumn(this.getSharedColors());
    }

    protected IVerticalRuler createVerticalRuler() {
        return this.createCompositeRuler();
    }

    protected CompositeRuler createCompositeRuler() {
        return new CompositeRuler();
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler compositeRuler) {
        return new AnnotationRulerColumn(12, this.getAnnotationAccess());
    }

    protected final IColumnSupport createColumnSupport() {
        return new AbstractTextEditor.ColumnSupport((AbstractTextEditor)this, RulerColumnRegistry.getDefault()){

            protected void initializeColumn(IContributedRulerColumn iContributedRulerColumn) {
                super.initializeColumn(iContributedRulerColumn);
                RulerColumnDescriptor rulerColumnDescriptor = iContributedRulerColumn.getDescriptor();
                IVerticalRuler iVerticalRuler = AbstractDecoratedTextEditor.this.internalGetVerticalRuler();
                if (iVerticalRuler instanceof CompositeRuler) {
                    if ("org.eclipse.ui.editors.columns.annotations".equals(rulerColumnDescriptor.getId())) {
                        ((AnnotationColumn)iContributedRulerColumn).setDelegate(AbstractDecoratedTextEditor.this.createAnnotationRulerColumn((CompositeRuler)iVerticalRuler));
                    } else if ("org.eclipse.ui.editors.columns.linenumbers".equals(rulerColumnDescriptor.getId())) {
                        AbstractDecoratedTextEditor.this.fLineColumn = (LineNumberColumn)iContributedRulerColumn;
                        AbstractDecoratedTextEditor.this.fLineColumn.setForwarder(new LineNumberColumn.ICompatibilityForwarder(){

                            @Override
                            public IVerticalRulerColumn createLineNumberRulerColumn() {
                                return AbstractDecoratedTextEditor.this.createLineNumberRulerColumn();
                            }

                            @Override
                            public boolean isQuickDiffEnabled() {
                                return AbstractDecoratedTextEditor.this.isPrefQuickDiffAlwaysOn();
                            }

                            @Override
                            public boolean isLineNumberRulerVisible() {
                                return AbstractDecoratedTextEditor.this.isLineNumberRulerVisible();
                            }
                        });
                    }
                }
            }

            public void dispose() {
                AbstractDecoratedTextEditor.this.fLineColumn = null;
                super.dispose();
            }
        };
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        try {
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (iSourceViewer == null) {
                return;
            }
            String string = propertyChangeEvent.getProperty();
            if (this.fSourceViewerDecorationSupport != null && this.fOverviewRuler != null && OVERVIEW_RULER.equals(string)) {
                if (this.isOverviewRulerVisible()) {
                    this.showOverviewRuler();
                } else {
                    this.hideOverviewRuler();
                }
                return;
            }
            if (USE_SATURATED_COLORS_IN_OVERVIEW_RULER.equals(string) && this.fOverviewRuler instanceof IOverviewRulerExtension) {
                ((IOverviewRulerExtension)this.fOverviewRuler).setUseSaturatedColors(this.isPrefUseSaturatedColorsOn());
                this.fOverviewRuler.update();
            }
            if (DISABLE_OVERWRITE_MODE.equals(string)) {
                this.enableOverwriteMode(this.isOverwriteModeEnabled());
                return;
            }
            if (LINE_NUMBER_RULER.equals(string)) {
                IColumnSupport iColumnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
                if (this.isLineNumberRulerVisible() && this.fLineColumn == null) {
                    RulerColumnDescriptor rulerColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers");
                    if (rulerColumnDescriptor != null) {
                        iColumnSupport.setColumnVisible(rulerColumnDescriptor, true);
                    }
                } else if (!this.isLineNumberRulerVisible() && this.fLineColumn != null && !this.fLineColumn.isShowingChangeInformation()) {
                    iColumnSupport.setColumnVisible(this.fLineColumn.getDescriptor(), false);
                    this.fLineColumn = null;
                }
                return;
            }
            if ("quickdiff.quickDiff".equals(string)) {
                this.showChangeInformation(this.isPrefQuickDiffAlwaysOn());
            }
            if ("tabWidth".equals(string)) {
                IPreferenceStore iPreferenceStore = this.getPreferenceStore();
                if (iPreferenceStore != null) {
                    iSourceViewer.getTextWidget().setTabs(iPreferenceStore.getInt("tabWidth"));
                }
                if (this.isTabsToSpacesConversionEnabled()) {
                    this.uninstallTabsToSpacesConverter();
                    this.installTabsToSpacesConverter();
                }
                return;
            }
            if ("spacesForTabs".equals(string)) {
                if (this.isTabsToSpacesConversionEnabled()) {
                    this.installTabsToSpacesConverter();
                } else {
                    this.uninstallTabsToSpacesConverter();
                }
                return;
            }
            if ("undoHistorySize".equals(string) && iSourceViewer instanceof ITextViewerExtension6) {
                IPreferenceStore iPreferenceStore = this.getPreferenceStore();
                if (iPreferenceStore != null) {
                    ((ITextViewerExtension6)iSourceViewer).getUndoManager().setMaximalUndoLevel(iPreferenceStore.getInt("undoHistorySize"));
                }
                return;
            }
            if ("show_range_indicator".equals(string)) {
                if (this.isRangeIndicatorEnabled()) {
                    this.getSourceViewer().setRangeIndicator(this.getRangeIndicator());
                } else {
                    this.getSourceViewer().removeRangeIndication();
                    this.getSourceViewer().setRangeIndicator(null);
                }
            }
            if (iSourceViewer instanceof ITextViewerExtension6) {
                HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
                int n = 0;
                while (n < hyperlinkDetectorDescriptorArray.length) {
                    if (hyperlinkDetectorDescriptorArray[n].getId().equals(string) || (String.valueOf(hyperlinkDetectorDescriptorArray[n].getId()) + "_stateMask").equals(string)) {
                        IHyperlinkDetector[] iHyperlinkDetectorArray = this.getSourceViewerConfiguration().getHyperlinkDetectors(iSourceViewer);
                        int n2 = this.getSourceViewerConfiguration().getHyperlinkStateMask(iSourceViewer);
                        ITextViewerExtension6 iTextViewerExtension6 = (ITextViewerExtension6)iSourceViewer;
                        iTextViewerExtension6.setHyperlinkDetectors(iHyperlinkDetectorArray, n2);
                        return;
                    }
                    ++n;
                }
            }
        }
        finally {
            super.handlePreferenceStoreChanged(propertyChangeEvent);
        }
    }

    protected void showOverviewRuler() {
        if (this.fOverviewRuler != null && this.getSourceViewer() instanceof ISourceViewerExtension) {
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(true);
            this.fSourceViewerDecorationSupport.updateOverviewDecorations();
        }
    }

    protected void hideOverviewRuler() {
        if (this.getSourceViewer() instanceof ISourceViewerExtension) {
            this.fSourceViewerDecorationSupport.hideAnnotationOverview();
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(false);
        }
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
    }

    protected IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer iSourceViewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(iSourceViewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected MarkerAnnotationPreferences getAnnotationPreferences() {
        return this.fAnnotationPreferences;
    }

    public void gotoMarker(IMarker iMarker) {
        int n;
        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel;
        if (this.fIsUpdatingMarkerViews) {
            return;
        }
        if (this.getSourceViewer() == null) {
            return;
        }
        int n2 = MarkerUtilities.getCharStart(iMarker);
        int n3 = MarkerUtilities.getCharEnd(iMarker);
        boolean bl = n2 < 0 || n3 < 0;
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (iAnnotationModel instanceof AbstractMarkerAnnotationModel) {
            abstractMarkerAnnotationModel = (AbstractMarkerAnnotationModel)iAnnotationModel;
            Position position = abstractMarkerAnnotationModel.getMarkerPosition(iMarker);
            if (position != null && !position.isDeleted()) {
                n2 = position.getOffset();
                n3 = position.getOffset() + position.getLength();
            }
            if (position != null && position.isDeleted()) {
                return;
            }
        }
        abstractMarkerAnnotationModel = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (bl) {
            try {
                int n4;
                if (n2 >= 0) {
                    n4 = abstractMarkerAnnotationModel.getLineOfOffset(n2);
                } else {
                    n4 = MarkerUtilities.getLineNumber(iMarker);
                    n2 = abstractMarkerAnnotationModel.getLineOffset(--n4);
                }
                n3 = n2 + abstractMarkerAnnotationModel.getLineLength(n4) - 1;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
        if (n3 <= (n = abstractMarkerAnnotationModel.getLength()) && n2 <= n) {
            this.fIsComingFromGotoMarker = true;
            this.selectAndReveal(n2, n3 - n2);
        }
    }

    public boolean isEditable() {
        if (!super.isEditable()) {
            return false;
        }
        return this.fIsEditingDerivedFileAllowed;
    }

    public boolean validateEditorInputState() {
        if (!super.validateEditorInputState()) {
            return false;
        }
        return this.validateEditorInputDerived();
    }

    private boolean validateEditorInputDerived() {
        IStatus iStatus;
        IPreferenceStore iPreferenceStore;
        if (this.fIsDerivedStateValidated) {
            return this.fIsEditingDerivedFileAllowed;
        }
        if (this.getDocumentProvider() instanceof IDocumentProviderExtension) {
            boolean bl;
            iPreferenceStore = (IDocumentProviderExtension)this.getDocumentProvider();
            iStatus = iPreferenceStore.getStatus((Object)this.getEditorInput());
            String string = iStatus.getPlugin();
            boolean bl2 = bl = iStatus.getCode() == 5 && ("org.eclipse.core.filebuffers".equals(string) || "org.eclipse.ui.editors".equals(string));
            if (!bl) {
                return true;
            }
        }
        if (!(iPreferenceStore = this.getPreferenceStore()).getBoolean("warn_if_input_derived")) {
            return true;
        }
        iStatus = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getSite().getShell(), (String)TextEditorMessages.AbstractDecoratedTextEditor_warning_derived_title, (String)TextEditorMessages.AbstractDecoratedTextEditor_warning_derived_message, (String)TextEditorMessages.AbstractDecoratedTextEditor_warning_derived_dontShowAgain, (boolean)false, null, null);
        EditorsUI.getPreferenceStore().setValue("warn_if_input_derived", !iStatus.getToggleState());
        this.fIsDerivedStateValidated = true;
        this.fIsEditingDerivedFileAllowed = iStatus.getReturnCode() == 2;
        return this.fIsEditingDerivedFileAllowed;
    }

    protected boolean isErrorStatus(IStatus iStatus) {
        if (!super.isErrorStatus(iStatus)) {
            return false;
        }
        if (!iStatus.isMultiStatus()) {
            return !this.isReadOnlyLocalStatus(iStatus);
        }
        IStatus[] iStatusArray = iStatus.getChildren();
        int n = 0;
        while (n < iStatusArray.length) {
            if (iStatusArray[n].getSeverity() == 4 && !this.isReadOnlyLocalStatus(iStatusArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isReadOnlyLocalStatus(IStatus iStatus) {
        return iStatus.getCode() == 279;
    }

    protected void createActions() {
        super.createActions();
        Object object = new AddMarkerAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.AddBookmark.", (ITextEditor)this, "org.eclipse.core.resources.bookmark", true);
        object.setHelpContextId(ITextEditorHelpContextIds.BOOKMARK_ACTION);
        object.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.setAction(IDEActionFactory.BOOKMARK.getId(), (IAction)object);
        object = new AddTaskAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.AddTask.", (ITextEditor)this);
        object.setHelpContextId(ITextEditorHelpContextIds.ADD_TASK_ACTION);
        object.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.setAction(IDEActionFactory.ADD_TASK.getId(), (IAction)object);
        object = new ChangeEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ChangeEncodingAction.", (ITextEditor)this);
        object.setHelpContextId("org.eclipse.ui.ChangeEncoding_action_context");
        object.setActionDefinitionId("org.eclipse.ui.edit.text.changeEncoding");
        this.setAction("ChangeEncoding", (IAction)object);
        this.markAsPropertyDependentAction("ChangeEncoding", true);
        object = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleLineNumbersAction.", 2){

            public void run() {
                AbstractDecoratedTextEditor.this.toggleLineNumberRuler();
            }
        };
        object.setActionDefinitionId("org.eclipse.ui.editors.lineNumberToggle");
        this.setAction("Linenumbers.Toggle", (IAction)object);
        object = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleQuickDiffAction.", 2){

            public void run() {
                AbstractDecoratedTextEditor.this.toggleQuickDiffRuler();
            }
        };
        object.setActionDefinitionId("org.eclipse.quickdiff.toggle");
        this.setAction("QuickDiff.Toggle", (IAction)object);
        object = new RevertLineAction((ITextEditor)this, false);
        object.setActionDefinitionId("org.eclipse.ui.editors.quickdiff.revertLine");
        this.setAction("QuickDiff.RevertLine", (IAction)object);
        object = new RevertSelectionAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertSelection", (IAction)object);
        object = new RevertBlockAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertBlock", (IAction)object);
        object = new RestoreAction((ITextEditor)this, false);
        this.setAction("QuickDiff.RevertDeletion", (IAction)object);
        CompositeRevertAction compositeRevertAction = new CompositeRevertAction((ITextEditor)this, new IAction[]{this.getAction("QuickDiff.RevertSelection"), this.getAction("QuickDiff.RevertBlock"), this.getAction("QuickDiff.RevertDeletion"), this.getAction("QuickDiff.RevertLine")});
        compositeRevertAction.setActionDefinitionId("org.eclipse.ui.editors.quickdiff.revert");
        this.setAction("QuickDiff.Revert", (IAction)compositeRevertAction);
        object = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.HideRevisionInformationAction."){

            public void run() {
                if (AbstractDecoratedTextEditor.this.fLineColumn != null) {
                    AbstractDecoratedTextEditor.this.fLineColumn.hideRevisionInformation();
                }
            }
        };
        this.setAction("Revision.HideInfo", (IAction)object);
        object = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.CycleRevisionRenderingAction."){

            public void run() {
                IRevisionRulerColumnExtension.RenderingMode[] renderingModeArray = new IRevisionRulerColumnExtension.RenderingMode[]{IRevisionRulerColumnExtension.AGE, IRevisionRulerColumnExtension.AUTHOR, IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE};
                IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
                String string = iPreferenceStore.getString("revisionRulerRenderingMode");
                int n = 0;
                while (n < renderingModeArray.length) {
                    String string2 = renderingModeArray[n].name();
                    if (string2.equals(string)) {
                        int n2 = (n + 1) % renderingModeArray.length;
                        IRevisionRulerColumnExtension.RenderingMode renderingMode = renderingModeArray[n2];
                        iPreferenceStore.setValue("revisionRulerRenderingMode", renderingMode.name());
                    }
                    ++n;
                }
            }
        };
        object.setActionDefinitionId("org.eclipse.ui.editors.revisions.rendering.cycle");
        this.setAction("Revision.Rendering.Cycle", (IAction)object);
        object = new BooleanPreferenceToggleAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleRevisionAuthorAction.", 2, EditorsUI.getPreferenceStore(), "revisionRulerShowAuthor");
        object.setActionDefinitionId("org.eclipse.ui.editors.revisions.author.toggle");
        this.setAction("Revision.ShowAuthor.Toggle", (IAction)object);
        object = new BooleanPreferenceToggleAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ToggleRevisionIdAction.", 2, EditorsUI.getPreferenceStore(), "revisionRulerShowRevision");
        object.setActionDefinitionId("org.eclipse.ui.editors.revisions.id.toggle");
        this.setAction("Revision.ShowId.Toggle", (IAction)object);
        final Shell shell = this.getSourceViewer() != null ? this.getSourceViewer().getTextWidget().getShell() : null;
        object = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.RulerPreferencesAction."){

            public void run() {
                String[] stringArray = AbstractDecoratedTextEditor.this.collectRulerMenuPreferencePages();
                if (!(stringArray.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)stringArray[0], (String[])stringArray, null).open();
                }
            }
        };
        this.setAction("Preferences.RulerAction", (IAction)object);
        object = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ContextPreferencesAction."){

            public void run() {
                String[] stringArray = AbstractDecoratedTextEditor.this.collectContextMenuPreferencePages();
                if (!(stringArray.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)stringArray[0], (String[])stringArray, null).open();
                }
            }
        };
        this.setAction("Preferences.ContextAction", (IAction)object);
        IAction iAction = this.getAction("ShowWhitespaceCharacters");
        if (iAction instanceof ShowWhitespaceCharactersAction) {
            ((ShowWhitespaceCharactersAction)iAction).setPreferenceStore(EditorsUI.getPreferenceStore());
        }
        this.setAction(ITextEditorActionConstants.REFRESH, (IAction)new RefreshEditorAction((ITextEditor)this));
        this.markAsPropertyDependentAction(ITextEditorActionConstants.REFRESH, true);
        if (this.getAction(ITextEditorActionConstants.PRINT).isEnabled() && this.getSourceViewer() instanceof ITextViewerExtension8) {
            this.createPrintAction();
        }
        object = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ShowChangeRulerInformation.", 1){

            public void run() {
                AbstractDecoratedTextEditor.this.showChangeRulerInformation();
            }
        };
        object.setActionDefinitionId("org.eclipse.ui.edit.text.showChangeRulerInformation");
        this.setAction("ShowChangeRulerInformation", (IAction)object);
        object = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ShowRulerAnnotationInformation.", 1){

            public void run() {
                AbstractDecoratedTextEditor.this.showRulerAnnotationInformation();
            }
        };
        object.setActionDefinitionId("org.eclipse.ui.edit.text.showRulerAnnotationInformation");
        this.setAction("ShowRulerAnnotationInformation", (IAction)object);
    }

    private void showChangeRulerInformation() {
        IVerticalRuler iVerticalRuler = this.getVerticalRuler();
        if (!(iVerticalRuler instanceof CompositeRuler) || this.fLineColumn == null) {
            return;
        }
        CompositeRuler compositeRuler = (CompositeRuler)iVerticalRuler;
        int n = this.fLineColumn.getControl().getLocation().x;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        StyledText styledText = iSourceViewer.getTextWidget();
        int n2 = styledText.getCaretOffset();
        int n3 = styledText.getLineAtOffset(n2);
        int n4 = styledText.getLinePixel(n3);
        compositeRuler.setLocationOfLastMouseButtonActivity(n, n4);
        IAnnotationHover iAnnotationHover = this.fLineColumn.getHover();
        this.showFocusedRulerHover(iAnnotationHover, iSourceViewer, n2);
    }

    private void showRulerAnnotationInformation() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        IAnnotationHover iAnnotationHover = this.getSourceViewerConfiguration().getAnnotationHover(iSourceViewer);
        int n = iSourceViewer.getTextWidget().getCaretOffset();
        this.showFocusedRulerHover(iAnnotationHover, iSourceViewer, n);
    }

    private void showFocusedRulerHover(IAnnotationHover iAnnotationHover, ISourceViewer iSourceViewer, int n) {
        if (iAnnotationHover == null) {
            return;
        }
        int n2 = AbstractDecoratedTextEditor.widgetOffset2ModelOffset((ISourceViewer)iSourceViewer, (int)n);
        if (n2 == -1) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        try {
            int n3 = iDocument.getLineOfOffset(n2);
            if (this.fInformationPresenter == null) {
                this.fInformationPresenter = new FocusedInformationPresenter(iSourceViewer, this.getSourceViewerConfiguration());
            }
            this.fInformationPresenter.openFocusedAnnotationHover(iAnnotationHover, n3);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    private void createPrintAction() {
        final ISourceViewer iSourceViewer = this.getSourceViewer();
        ResourceAction resourceAction = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.Print."){

            public void run() {
                StyledTextPrintOptions styledTextPrintOptions = new StyledTextPrintOptions();
                styledTextPrintOptions.printTextFontStyle = true;
                styledTextPrintOptions.printTextForeground = true;
                styledTextPrintOptions.printTextBackground = true;
                styledTextPrintOptions.jobName = AbstractDecoratedTextEditor.this.getTitle();
                styledTextPrintOptions.header = "\t" + AbstractDecoratedTextEditor.this.getTitle();
                styledTextPrintOptions.footer = "\t" + NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_printPageNumber, "<page>");
                if (AbstractDecoratedTextEditor.this.isLineNumberRulerVisible()) {
                    styledTextPrintOptions.printLineNumbers = true;
                    styledTextPrintOptions.lineLabels = new String[iSourceViewer.getTextWidget().getLineCount()];
                    int n = 0;
                    while (n < styledTextPrintOptions.lineLabels.length) {
                        styledTextPrintOptions.lineLabels[n] = String.valueOf(JFaceTextUtil.widgetLine2ModelLine((ITextViewer)iSourceViewer, (int)n) + 1);
                        ++n;
                    }
                }
                ((ITextViewerExtension8)iSourceViewer).print(styledTextPrintOptions);
            }
        };
        resourceAction.setHelpContextId(IAbstractTextEditorHelpContextIds.PRINT_ACTION);
        resourceAction.setActionDefinitionId("org.eclipse.ui.file.print");
        this.setAction(ITextEditorActionConstants.PRINT, (IAction)resourceAction);
    }

    public Object getAdapter(Class clazz) {
        if (IGotoMarker.class.equals((Object)clazz)) {
            return this.fGotoMarkerAdapter;
        }
        if (IAnnotationAccess.class.equals((Object)clazz)) {
            return this.getAnnotationAccess();
        }
        if (clazz == IShowInSource.class) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    ISelection iSelection = null;
                    ISelectionProvider iSelectionProvider = AbstractDecoratedTextEditor.this.getSelectionProvider();
                    if (iSelectionProvider != null) {
                        iSelection = iSelectionProvider.getSelection();
                    }
                    return new ShowInContext((Object)AbstractDecoratedTextEditor.this.getEditorInput(), iSelection);
                }
            };
        }
        if (IRevisionRulerColumn.class.equals((Object)clazz) && this.fLineNumberRulerColumn instanceof IRevisionRulerColumn) {
            return this.fLineNumberRulerColumn;
        }
        if (MarkerAnnotationPreferences.class.equals((Object)clazz)) {
            return EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        }
        return super.getAdapter(clazz);
    }

    protected void setDocumentProvider(IEditorInput iEditorInput) {
        this.fImplicitDocumentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider(iEditorInput);
        IDocumentProvider iDocumentProvider = super.getDocumentProvider();
        if (iDocumentProvider instanceof ForwardingDocumentProvider) {
            ForwardingDocumentProvider forwardingDocumentProvider = (ForwardingDocumentProvider)iDocumentProvider;
            forwardingDocumentProvider.setParentProvider(this.fImplicitDocumentProvider);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        IDocumentProvider iDocumentProvider = super.getDocumentProvider();
        if (iDocumentProvider == null) {
            return this.fImplicitDocumentProvider;
        }
        return iDocumentProvider;
    }

    protected void disposeDocumentProvider() {
        super.disposeDocumentProvider();
        this.fImplicitDocumentProvider = null;
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        this.fIsDerivedStateValidated = false;
        this.fIsEditingDerivedFileAllowed = true;
        if (this.fLineColumn != null) {
            this.fLineColumn.hideRevisionInformation();
        }
        super.doSetInput(iEditorInput);
        RulerColumnDescriptor rulerColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers");
        if (rulerColumnDescriptor != null) {
            IColumnSupport iColumnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
            iColumnSupport.setColumnVisible(rulerColumnDescriptor, this.isLineNumberRulerVisible() || this.isPrefQuickDiffAlwaysOn());
        }
    }

    protected void handleEditorInputChanged() {
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        IEditorInput iEditorInput = this.getEditorInput();
        if (iDocumentProvider != null && iEditorInput != null && !this.isDirty() && iEditorInput.getAdapter(IFile.class) != null && Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null)) {
            return;
        }
        super.handleEditorInputChanged();
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        boolean bl;
        block26: {
            Object object;
            Object object2;
            Object object3;
            String string;
            IFile iFile;
            SaveAsDialog saveAsDialog;
            Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
            IEditorInput iEditorInput = this.getEditorInput();
            IDocumentProvider iDocumentProvider = this.getDocumentProvider();
            if (iEditorInput instanceof IURIEditorInput && !(iEditorInput instanceof IFileEditorInput)) {
                saveAsDialog = new FileDialog(shell, 8192);
                iFile = URIUtil.toPath((URI)((IURIEditorInput)iEditorInput).getURI());
                if (iFile != null) {
                    saveAsDialog.setFileName(iFile.lastSegment());
                    saveAsDialog.setFilterPath(iFile.toOSString());
                }
                if ((string = saveAsDialog.open()) == null) {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.setCanceled(true);
                    }
                    return;
                }
                object3 = new File(string);
                if (((File)object3).exists() && (object2 = new MessageDialog(shell, TextEditorMessages.AbstractDecoratedTextEditor_saveAs_overwrite_title, null, NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_saveAs_overwrite_message, string), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0 && iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                    return;
                }
                try {
                    object2 = EFS.getStore((URI)((File)object3).toURI());
                }
                catch (CoreException coreException) {
                    EditorsPlugin.log(coreException.getStatus());
                    String string2 = TextEditorMessages.AbstractDecoratedTextEditor_error_saveAs_title;
                    String string3 = NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_error_saveAs_message, coreException.getMessage());
                    MessageDialog.openError((Shell)shell, (String)string2, (String)string3);
                    return;
                }
                IFile iFile2 = this.getWorkspaceFile((IFileStore)object2);
                object = iFile2 != null ? new FileEditorInput(iFile2) : new FileStoreEditorInput(object2);
            } else {
                saveAsDialog = new SaveAsDialog(shell);
                IFile iFile3 = iFile = iEditorInput instanceof IFileEditorInput ? ((IFileEditorInput)iEditorInput).getFile() : null;
                if (iFile != null) {
                    saveAsDialog.setOriginalFile(iFile);
                } else {
                    saveAsDialog.setOriginalName(iEditorInput.getName());
                }
                saveAsDialog.create();
                if (iDocumentProvider.isDeleted((Object)iEditorInput) && iFile != null) {
                    string = NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_warning_saveAs_deleted, iFile.getName());
                    saveAsDialog.setErrorMessage(null);
                    saveAsDialog.setMessage(string, 2);
                }
                if (saveAsDialog.open() == 1) {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.setCanceled(true);
                    }
                    return;
                }
                string = saveAsDialog.getResult();
                if (string == null) {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.setCanceled(true);
                    }
                    return;
                }
                object3 = ResourcesPlugin.getWorkspace();
                object2 = object3.getRoot().getFile((IPath)string);
                object = new FileEditorInput((IFile)object2);
            }
            if (iDocumentProvider == null) {
                return;
            }
            bl = false;
            try {
                try {
                    iDocumentProvider.aboutToChange(object);
                    iDocumentProvider.saveDocument(iProgressMonitor, object, iDocumentProvider.getDocument((Object)iEditorInput), true);
                    bl = true;
                }
                catch (CoreException coreException) {
                    string = coreException.getStatus();
                    if (string == null || string.getSeverity() != 8) {
                        object3 = TextEditorMessages.AbstractDecoratedTextEditor_error_saveAs_title;
                        object2 = NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_error_saveAs_message, coreException.getMessage());
                        MessageDialog.openError((Shell)shell, (String)object3, (String)object2);
                    }
                    iDocumentProvider.changed(object);
                    if (bl) {
                        this.setInput((IEditorInput)object);
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                iDocumentProvider.changed(object);
                if (bl) {
                    this.setInput((IEditorInput)object);
                }
                throw throwable;
            }
            iDocumentProvider.changed(object);
            if (bl) {
                this.setInput((IEditorInput)object);
            }
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
    }

    protected void openSaveErrorDialog(String string, String string2, CoreException coreException) {
        IStatus iStatus = coreException.getStatus();
        IDocumentProvider iDocumentProvider = this.getDocumentProvider();
        if (iStatus.getCode() != 3 || !(iDocumentProvider instanceof IStorageDocumentProvider)) {
            super.openSaveErrorDialog(string, string2, coreException);
            return;
        }
        final Charset charset = this.getCharset();
        ErrorDialog errorDialog = new ErrorDialog(this.getSite().getShell(), string, string2, iStatus, 4){

            protected void createButtonsForButtonBar(Composite composite) {
                super.createButtonsForButtonBar(composite);
                this.createButton(composite, 2, TextEditorMessages.AbstractDecoratedTextEditor_save_error_Dialog_button_saveAsUTF8, false);
                if (charset != null) {
                    this.createButton(composite, 3, TextEditorMessages.AbstractDecoratedTextEditor_save_error_Dialog_button_selectUnmappable, false);
                }
            }

            protected void buttonPressed(int n) {
                if (n == 2 || n == 3) {
                    this.setReturnCode(n);
                    this.close();
                } else {
                    super.buttonPressed(n);
                }
            }

            protected boolean shouldShowDetailsButton() {
                return false;
            }
        };
        int n = errorDialog.open();
        if (n == 2) {
            ((IStorageDocumentProvider)iDocumentProvider).setEncoding(this.getEditorInput(), "UTF-8");
            this.doSave(this.getProgressMonitor());
        } else if (n == 3) {
            CharsetEncoder charsetEncoder = charset.newEncoder();
            IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int n2 = iDocument.getLength();
            int n3 = 0;
            BreakIterator breakIterator = BreakIterator.getCharacterInstance();
            breakIterator.setText(iDocument.get());
            while (n3 < n2) {
                try {
                    int n4 = breakIterator.next();
                    String string3 = iDocument.get(n3, n4 - n3);
                    if (!charsetEncoder.canEncode(string3)) {
                        this.selectAndReveal(n3, n4 - n3);
                        return;
                    }
                    n3 = n4;
                }
                catch (BadLocationException badLocationException) {
                    EditorsPlugin.log(badLocationException);
                }
            }
        }
    }

    private Charset getCharset() {
        IEncodingSupport iEncodingSupport = (IEncodingSupport)this.getAdapter(IEncodingSupport.class);
        if (iEncodingSupport == null) {
            return null;
        }
        try {
            return Charset.forName(iEncodingSupport.getEncoding());
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            return null;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return null;
        }
    }

    private IFile getWorkspaceFile(IFileStore iFileStore) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] iFileArray = iWorkspaceRoot.findFilesForLocationURI(iFileStore.toURI());
        if (iFileArray != null && iFileArray.length == 1) {
            return iFileArray[0];
        }
        return null;
    }

    protected void setOverviewRulerContextMenuId(String string) {
        Assert.isNotNull((Object)string);
        this.fOverviewRulerContextMenuId = string;
    }

    protected final String getOverviewRulerContextMenuId() {
        return this.fOverviewRulerContextMenuId;
    }

    protected void overviewRulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        final String string = this.findSelectedOverviewRulerAnnotationLabel();
        final Shell shell = this.getSite().getShell();
        ResourceAction resourceAction = new ResourceAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.RulerPreferencesAction."){

            public void run() {
                String[] stringArray = AbstractDecoratedTextEditor.this.collectOverviewRulerMenuPreferencePages();
                if (!(stringArray.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)stringArray[0], (String[])stringArray, (Object)string).open();
                }
            }
        };
        iMenuManager.add((IContributionItem)new Separator("group.rest"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IAction)resourceAction);
    }

    private String findSelectedOverviewRulerAnnotationLabel() {
        AnnotationPreference annotationPreference;
        Point point = this.getSourceViewer().getSelectedRange();
        IAnnotationModel iAnnotationModel = this.getSourceViewer().getAnnotationModel();
        Annotation annotation = null;
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            annotation = (Annotation)iterator.next();
            annotationPreference = iAnnotationModel.getPosition(annotation);
            if (annotationPreference.getOffset() == point.x && annotationPreference.getLength() == point.y) break;
        }
        if (annotation != null && (annotationPreference = this.getAnnotationPreferenceLookup().getAnnotationPreference(annotation)) != null) {
            return annotationPreference.getPreferenceLabel();
        }
        return null;
    }

    protected void rulerContextMenuAboutToShow(IMenuManager iMenuManager) {
        RestoreAction restoreAction;
        IRevisionRulerColumnExtension.RenderingMode[] renderingModeArray;
        String[] stringArray;
        Object object;
        IAction iAction;
        iMenuManager.add((IContributionItem)new Separator("debug"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new GroupMarker("restore"));
        iMenuManager.add((IContributionItem)new Separator("add"));
        iMenuManager.add((IContributionItem)new Separator("rulers"));
        iMenuManager.add((IContributionItem)new Separator("group.rest"));
        super.rulerContextMenuAboutToShow(iMenuManager);
        this.addRulerContributionActions(iMenuManager);
        if (this.isEditorInputModifiable()) {
            iAction = this.getAction("QuickDiff.Toggle");
            iAction.setChecked(this.isChangeInformationShowing());
            iMenuManager.appendToGroup("rulers", iAction);
            if (this.isChangeInformationShowing()) {
                object = new RevertLineAction((ITextEditor)this, true);
                stringArray = new RevertSelectionAction((ITextEditor)this, true);
                renderingModeArray = new RevertBlockAction((ITextEditor)this, true);
                restoreAction = new RestoreAction((ITextEditor)this, true);
                stringArray.update();
                renderingModeArray.update();
                object.update();
                restoreAction.update();
                if (stringArray.isEnabled()) {
                    iMenuManager.appendToGroup("restore", (IAction)stringArray);
                } else if (renderingModeArray.isEnabled()) {
                    iMenuManager.appendToGroup("restore", (IAction)renderingModeArray);
                }
                if (object.isEnabled()) {
                    iMenuManager.appendToGroup("restore", object);
                }
                if (restoreAction.isEnabled()) {
                    iMenuManager.appendToGroup("restore", (IAction)restoreAction);
                }
            }
        }
        if (this.fLineColumn != null && this.fLineColumn.isShowingRevisionInformation()) {
            iAction = new MenuManager(TextEditorMessages.AbstractDecoratedTextEditor_revisions_menu);
            iMenuManager.appendToGroup("rulers", (IContributionItem)iAction);
            object = this.getAction("Revision.HideInfo");
            iAction.add(object);
            iAction.add((IContributionItem)new Separator());
            stringArray = new String[]{TextEditorMessages.AbstractDecoratedTextEditor_revision_colors_option_by_date, TextEditorMessages.AbstractDecoratedTextEditor_revision_colors_option_by_author, TextEditorMessages.AbstractDecoratedTextEditor_revision_colors_option_by_author_and_date};
            renderingModeArray = new IRevisionRulerColumnExtension.RenderingMode[]{IRevisionRulerColumnExtension.AGE, IRevisionRulerColumnExtension.AUTHOR, IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE};
            restoreAction = EditorsUI.getPreferenceStore();
            String string = restoreAction.getString("revisionRulerRenderingMode");
            int n = 0;
            while (n < renderingModeArray.length) {
                String string2 = renderingModeArray[n].name();
                Action action = new Action(stringArray[n], 8, (IPreferenceStore)restoreAction, string2){
                    private final /* synthetic */ IPreferenceStore val$uiStore;
                    private final /* synthetic */ String val$mode;
                    {
                        this.val$uiStore = iPreferenceStore;
                        this.val$mode = string2;
                        super(string, n);
                    }

                    public void run() {
                        this.val$uiStore.setValue("revisionRulerRenderingMode", this.val$mode);
                    }
                };
                action.setChecked(string2.equals(string));
                iAction.add((IAction)action);
                ++n;
            }
            iAction.add((IContributionItem)new Separator());
            IAction iAction2 = this.getAction("Revision.ShowAuthor.Toggle");
            if (iAction2 instanceof IUpdate) {
                ((IUpdate)iAction2).update();
            }
            iAction.add(iAction2);
            iAction2 = this.getAction("Revision.ShowId.Toggle");
            if (iAction2 instanceof IUpdate) {
                ((IUpdate)iAction2).update();
            }
            iAction.add(iAction2);
        }
        iAction = this.getAction("Linenumbers.Toggle");
        iAction.setChecked(this.fLineColumn != null && this.fLineColumn.isShowingLineNumbers());
        iMenuManager.appendToGroup("rulers", iAction);
        object = this.getAction("Preferences.RulerAction");
        iMenuManager.appendToGroup("rulers", (IContributionItem)new Separator("settings"));
        iMenuManager.appendToGroup("settings", object);
    }

    private void addRulerContributionActions(IMenuManager iMenuManager) {
        final IColumnSupport iColumnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        final RulerColumnPreferenceAdapter rulerColumnPreferenceAdapter = new RulerColumnPreferenceAdapter(iPreferenceStore, "rulerContributions");
        List list = RulerColumnRegistry.getDefault().getColumnDescriptors();
        for (final RulerColumnDescriptor rulerColumnDescriptor : list) {
            if (!rulerColumnDescriptor.isIncludedInMenu() || !iColumnSupport.isColumnSupported(rulerColumnDescriptor)) continue;
            final boolean bl = iColumnSupport.isColumnVisible(rulerColumnDescriptor);
            Action action = new Action(MessageFormat.format((String)TextEditorMessages.AbstractDecoratedTextEditor_show_ruler_label, (Object[])new Object[]{rulerColumnDescriptor.getName()}), 2){

                public void run() {
                    if (rulerColumnDescriptor.isGlobal()) {
                        rulerColumnPreferenceAdapter.setEnabled(rulerColumnDescriptor, !bl);
                    } else {
                        iColumnSupport.setColumnVisible(rulerColumnDescriptor, !bl);
                    }
                }
            };
            action.setChecked(bl);
            action.setImageDescriptor(rulerColumnDescriptor.getIcon());
            iMenuManager.appendToGroup("rulers", (IAction)action);
        }
    }

    private void toggleLineNumberRuler() {
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        iPreferenceStore.setValue(LINE_NUMBER_RULER, !this.isLineNumberRulerVisible());
    }

    private void toggleQuickDiffRuler() {
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("quickdiff.quickDiff");
        if (bl == this.isChangeInformationShowing()) {
            iPreferenceStore.setValue("quickdiff.quickDiff", !bl);
        } else {
            this.showChangeInformation(bl);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        MenuManager menuManager;
        super.editorContextMenuAboutToShow(iMenuManager);
        IAction iAction = this.getAction("Preferences.ContextAction");
        iMenuManager.appendToGroup("additions", (IContributionItem)new Separator("settings"));
        iMenuManager.appendToGroup("settings", iAction);
        iMenuManager.appendToGroup("group.save", (IContributionItem)new Separator("group.open"));
        IEditorInput iEditorInput = this.getEditorInput();
        if ((IResource)iEditorInput.getAdapter(IResource.class) instanceof IFile) {
            menuManager = new MenuManager(TextEditorMessages.AbstractDecoratedTextEditor_openWith_menu);
            final IWorkbenchPage iWorkbenchPage = this.getEditorSite().getPage();
            menuManager.add((IContributionItem)new OpenWithMenu(iWorkbenchPage, (IAdaptable)iEditorInput){

                protected void openEditor(IEditorDescriptor iEditorDescriptor, boolean bl) {
                    super.openEditor(iEditorDescriptor, bl);
                    ISelection iSelection = AbstractDecoratedTextEditor.this.getSelectionProvider().getSelection();
                    if (iSelection instanceof ITextSelection) {
                        AbstractDecoratedTextEditor.revealInEditor(iWorkbenchPage.getActiveEditor(), ((ITextSelection)iSelection).getOffset(), ((ITextSelection)iSelection).getLength());
                    }
                }
            });
            iMenuManager.appendToGroup("group.open", (IContributionItem)menuManager);
        }
        menuManager = new MenuManager(this.getShowInMenuLabel());
        menuManager.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getEditorSite().getWorkbenchWindow()));
        iMenuManager.appendToGroup("group.open", (IContributionItem)menuManager);
    }

    private static void revealInEditor(IEditorPart iEditorPart, final int n, final int n2) {
        IGotoMarker iGotoMarker;
        if (iEditorPart instanceof ITextEditor) {
            ((ITextEditor)iEditorPart).selectAndReveal(n, n2);
            return;
        }
        if (iEditorPart instanceof IGotoMarker) {
            iGotoMarker = (IGotoMarker)iEditorPart;
        } else {
            IGotoMarker iGotoMarker2 = iGotoMarker = iEditorPart != null ? (IGotoMarker)iEditorPart.getAdapter(IGotoMarker.class) : null;
        }
        if (iGotoMarker != null) {
            final IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                        IMarker iMarker = null;
                        try {
                            iMarker = ((IFileEditorInput)iEditorInput).getFile().createMarker("org.eclipse.core.resources.textmarker");
                            iMarker.setAttribute("charStart", n);
                            iMarker.setAttribute("charEnd", n + n2);
                            iGotoMarker.gotoMarker(iMarker);
                        }
                        finally {
                            if (iMarker != null) {
                                iMarker.delete();
                            }
                        }
                    }
                };
                try {
                    workspaceModifyOperation.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
    }

    private String getShowInMenuLabel() {
        String string = null;
        IBindingService iBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (iBindingService != null) {
            string = iBindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (string == null) {
            string = "";
        }
        return NLSUtility.format(TextEditorMessages.AbstractDecoratedTextEditor_showIn_menu, string);
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.Spelling", "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage", "org.eclipse.ui.preferencePages.ColorsAndFonts"};
    }

    protected String[] collectRulerMenuPreferencePages() {
        return this.collectContextMenuPreferencePages();
    }

    protected String[] collectOverviewRulerMenuPreferencePages() {
        return new String[]{"org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.preferencePages.ColorsAndFonts"};
    }

    protected IOperationApprover getUndoRedoOperationApprover(IUndoContext iUndoContext) {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput != null && iEditorInput.getAdapter(IResource.class) != null) {
            return new NonLocalUndoUserApprover(iUndoContext, (IEditorPart)this, new Object[]{iEditorInput}, IResource.class);
        }
        return super.getUndoRedoOperationApprover(iUndoContext);
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        String string;
        AnnotationPreference annotationPreference = this.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string2 = string = annotationPreference == null ? null : annotationPreference.getIsGoToNextNavigationTargetKey();
        return string != null && this.getPreferenceStore().getBoolean(string);
    }

    public Annotation gotoAnnotation(boolean bl) {
        Annotation annotation = super.gotoAnnotation(bl);
        if (annotation != null) {
            this.updateMarkerViews(annotation);
        }
        return annotation;
    }

    protected void updateMarkerViews(Annotation annotation) {
        if (this.fIsComingFromGotoMarker) {
            this.fIsComingFromGotoMarker = false;
            return;
        }
        IMarker iMarker = null;
        if (annotation instanceof MarkerAnnotation) {
            iMarker = ((MarkerAnnotation)annotation).getMarker();
        }
        if (iMarker != null) {
            try {
                this.fIsUpdatingMarkerViews = true;
                IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
                MarkerViewUtil.showMarker((IWorkbenchPage)iWorkbenchPage, (IMarker)iMarker, (boolean)false);
            }
            finally {
                this.fIsUpdatingMarkerViews = false;
            }
        }
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return this.getPreferenceStore() != null && this.getPreferenceStore().getBoolean("spacesForTabs");
    }

    private class GotoMarkerAdapter
    implements IGotoMarker {
        private GotoMarkerAdapter() {
        }

        public void gotoMarker(IMarker iMarker) {
            AbstractDecoratedTextEditor.this.gotoMarker(iMarker);
        }
    }
}

