/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

class SourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
IInformationControlExtension5,
DisposeListener {
    private Shell fShell;
    private StyledText fText;
    private final String fSymbolicFontName;
    private Font fTextFont;
    private SourceViewer fViewer;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;
    private Color fStatusTextForegroundColor;
    private int fMaxWidth;
    private int fMaxHeight;
    private int fHorizontalScrollPixel;

    public SourceViewerInformationControl(Shell shell, boolean bl, String string, String string2) {
        int n = 0x4004 | (bl ? 16 : 0);
        int n2 = bl ? 768 : 0;
        this.fShell = new Shell(shell, n);
        Display display = this.fShell.getDisplay();
        Shell shell2 = this.fShell;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        shell2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        shell2.setLayoutData((Object)gridData);
        if (string2 != null) {
            shell2 = new Composite((Composite)shell2, 0);
            gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            shell2.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            shell2.setLayoutData((Object)gridData);
            shell2.setForeground(display.getSystemColor(28));
            shell2.setBackground(display.getSystemColor(29));
        }
        this.fViewer = new SourceViewer((Composite)shell2, null, n2);
        this.fViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsPlugin.getDefault().getPreferenceStore()));
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gridData = new GridData(1809);
        this.fText.setLayoutData((Object)gridData);
        this.fText.setForeground(shell.getDisplay().getSystemColor(28));
        this.fText.setBackground(shell.getDisplay().getSystemColor(29));
        this.fSymbolicFontName = string;
        this.fTextFont = JFaceResources.getFont((String)string);
        this.fText.setFont(this.fTextFont);
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    SourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        if (string2 != null) {
            this.fSeparator = new Label((Composite)shell2, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)shell2, 131072);
            this.fStatusField.setText(string2);
            Font font = this.fStatusField.getFont();
            FontData[] fontDataArray = font.getFontData();
            int n3 = 0;
            while (n3 < fontDataArray.length) {
                fontDataArray[n3].setHeight(fontDataArray[n3].getHeight() * 9 / 10);
                ++n3;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDataArray);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gridData2 = new GridData(1842);
            this.fStatusField.setLayoutData((Object)gridData2);
            this.fStatusTextForegroundColor = new Color((Device)this.fStatusField.getDisplay(), SourceViewerInformationControl.blend(display.getSystemColor(29).getRGB(), display.getSystemColor(28).getRGB(), 0.56f));
            this.fStatusField.setForeground(this.fStatusTextForegroundColor);
            this.fStatusField.setBackground(display.getSystemColor(29));
        }
        this.addDisposeListener(this);
    }

    private static RGB blend(RGB rGB, RGB rGB2, float f) {
        Assert.isLegal((rGB != null ? 1 : 0) != 0);
        Assert.isLegal((rGB2 != null ? 1 : 0) != 0);
        Assert.isLegal((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0);
        float f2 = 1.0f - f;
        return new RGB((int)(f2 * (float)rGB.red + f * (float)rGB2.red), (int)(f2 * (float)rGB.green + f * (float)rGB2.green), (int)(f2 * (float)rGB.blue + f * (float)rGB2.blue));
    }

    public void setInput(Object object) {
        if (object instanceof String) {
            this.setInformation((String)object);
        } else {
            this.setInformation(null);
        }
    }

    public void setInformation(String string) {
        if (string == null) {
            this.fViewer.setInput(null);
            return;
        }
        Document document = new Document(string);
        this.fViewer.setInput((Object)document);
        this.ensureScrollable();
        this.fViewer.getTextWidget().setHorizontalPixel(this.fHorizontalScrollPixel);
    }

    public void setVisible(boolean bl) {
        this.fShell.setVisible(bl);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fStatusTextFont = null;
        if (this.fStatusTextForegroundColor != null && !this.fStatusTextForegroundColor.isDisposed()) {
            this.fStatusTextForegroundColor.dispose();
        }
        this.fStatusTextForegroundColor = null;
        this.fTextFont = null;
        this.fShell = null;
        this.fText = null;
    }

    public final void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void setSize(int n, int n2) {
        if (this.fStatusField != null) {
            GridData gridData = (GridData)this.fViewer.getTextWidget().getLayoutData();
            Point point = this.fStatusField.computeSize(-1, -1, true);
            Point point2 = this.fSeparator.computeSize(-1, -1, true);
            gridData.heightHint = n2 - point.y - point2.y;
        }
        this.fShell.setSize(n, n2);
        if (this.fStatusField != null) {
            this.fShell.pack(true);
        }
    }

    public void setLocation(Point point) {
        this.fShell.setLocation(point);
    }

    public void setSizeConstraints(int n, int n2) {
        this.fMaxWidth = n;
        this.fMaxHeight = n2;
    }

    public Point computeSizeHint() {
        int n = -1;
        int n2 = -1;
        Point point = this.fShell.computeSize(n, n2);
        if (point.x > this.fMaxWidth) {
            n = this.fMaxWidth;
        }
        if (point.y > this.fMaxHeight) {
            n2 = this.fMaxHeight;
        }
        if (n != -1 || n2 != -1) {
            point = this.fShell.computeSize(n, n2, false);
        }
        return point;
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.fShell.addDisposeListener(disposeListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.fShell.removeDisposeListener(disposeListener);
    }

    public void setForegroundColor(Color color) {
        this.fText.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.fText.setBackground(color);
    }

    public boolean isFocusControl() {
        return this.fShell.getDisplay().getActiveShell() == this.fShell;
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener focusListener) {
        this.fText.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.fText.removeFocusListener(focusListener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    void setHorizontalScrollPixel(int n) {
        this.fHorizontalScrollPixel = n = Math.max(0, n);
    }

    private void ensureScrollable() {
        IDocument iDocument = this.fViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return;
        }
        int n = iDocument.getNumberOfLines() - 1;
        GC gC = new GC((Drawable)styledText);
        gC.setFont(styledText.getFont());
        int n2 = 0;
        String string = new String();
        try {
            try {
                int n3 = 0;
                while (n3 <= n) {
                    IRegion iRegion = iDocument.getLineInformation(n3);
                    string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                    int n4 = gC.textExtent((String)string).x;
                    if (n4 > n2) {
                        n2 = n4;
                    }
                    ++n3;
                }
            }
            catch (BadLocationException badLocationException) {
                gC.dispose();
                return;
            }
        }
        finally {
            gC.dispose();
        }
        this.fMaxWidth = Math.max(0, Math.min(this.fMaxWidth, n2 - this.fHorizontalScrollPixel + 8));
    }

    public Rectangle computeTrim() {
        Rectangle rectangle = this.fShell.computeTrim(0, 0, 0, 0);
        this.addInternalTrim(rectangle);
        return rectangle;
    }

    private void addInternalTrim(Rectangle rectangle) {
        if (this.fStatusField != null) {
            rectangle.height += this.fSeparator.computeSize((int)-1, (int)-1).y;
            rectangle.height += this.fStatusField.computeSize((int)-1, (int)-1).y;
        }
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new SourceViewerInformationControl(shell, true, SourceViewerInformationControl.this.fSymbolicFontName, null);
            }
        };
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this.fShell) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public boolean isVisible() {
        return this.fShell != null && !this.fShell.isDisposed() && this.fShell.isVisible();
    }

    public Point computeSizeConstraints(int n, int n2) {
        GC gC = new GC((Drawable)this.fText);
        gC.setFont(this.fTextFont);
        int n3 = gC.getFontMetrics().getAverageCharWidth();
        int n4 = this.fText.getLineHeight();
        gC.dispose();
        return new Point(n * n3, n2 * n4);
    }
}

