/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class PropertyEventDispatcher {
    private final Map fHandlerMap = new HashMap();
    private final Map fReverseMap = new HashMap();
    private final IPreferenceStore fStore;
    private final IPropertyChangeListener fListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyEventDispatcher.this.firePropertyChange(propertyChangeEvent);
        }
    };

    public PropertyEventDispatcher(IPreferenceStore iPreferenceStore) {
        Assert.isLegal((iPreferenceStore != null ? 1 : 0) != 0);
        this.fStore = iPreferenceStore;
    }

    public void dispose() {
        if (!this.fReverseMap.isEmpty()) {
            this.fStore.removePropertyChangeListener(this.fListener);
        }
        this.fReverseMap.clear();
        this.fHandlerMap.clear();
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object v = this.fHandlerMap.get(propertyChangeEvent.getProperty());
        if (v instanceof IPropertyChangeListener) {
            ((IPropertyChangeListener)v).propertyChange(propertyChangeEvent);
        } else if (v instanceof Set) {
            Iterator iterator = ((Set)v).iterator();
            while (iterator.hasNext()) {
                ((IPropertyChangeListener)iterator.next()).propertyChange(propertyChangeEvent);
            }
        }
    }

    public void addPropertyChangeListener(String string, IPropertyChangeListener iPropertyChangeListener) {
        Assert.isLegal((string != null ? 1 : 0) != 0);
        Assert.isLegal((iPropertyChangeListener != null ? 1 : 0) != 0);
        if (this.fReverseMap.isEmpty()) {
            this.fStore.addPropertyChangeListener(this.fListener);
        }
        this.multiMapPut(this.fHandlerMap, string, iPropertyChangeListener);
        this.multiMapPut(this.fReverseMap, iPropertyChangeListener, string);
    }

    private void multiMapPut(Map map, Object object, Object object2) {
        Object v = map.get(object);
        if (v == null) {
            map.put(object, object2);
        } else if (v instanceof Set) {
            ((Set)v).add(object2);
        } else {
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            linkedHashSet.add(v);
            linkedHashSet.add(object2);
            map.put(object, linkedHashSet);
        }
    }

    private void multiMapRemove(Map map, Object object, Object object2) {
        Object v = map.get(object);
        if (v instanceof Set) {
            ((Set)v).remove(object2);
        } else if (v != null) {
            map.remove(object);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        Object v = this.fReverseMap.get(iPropertyChangeListener);
        if (v == null) {
            return;
        }
        if (v instanceof String) {
            this.fReverseMap.remove(iPropertyChangeListener);
            this.multiMapRemove(this.fHandlerMap, v, iPropertyChangeListener);
        } else if (v instanceof Set) {
            this.fReverseMap.remove(iPropertyChangeListener);
            Iterator iterator = ((Set)v).iterator();
            while (iterator.hasNext()) {
                this.multiMapRemove(this.fHandlerMap, iterator.next(), iPropertyChangeListener);
            }
        }
        if (this.fReverseMap.isEmpty()) {
            this.fStore.removePropertyChangeListener(this.fListener);
        }
    }
}

