/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineDifferExtension;
import org.eclipse.jface.text.source.ILineDifferExtension2;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.PropertyEventDispatcher;
import org.eclipse.ui.internal.texteditor.RulerMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.quickdiff.QuickDiff;
import org.eclipse.ui.texteditor.rulers.AbstractContributedRulerColumn;

public class LineNumberColumn
extends AbstractContributedRulerColumn
implements IVerticalRulerInfo,
IVerticalRulerInfoExtension {
    public static final String ID = "org.eclipse.ui.editors.columns.linenumbers";
    private static final String FG_COLOR_KEY = "lineNumberColor";
    private static final String BG_COLOR_KEY = "AbstractTextEditor.Color.Background";
    private static final String USE_DEFAULT_BG_KEY = "AbstractTextEditor.Color.Background.SystemDefault";
    private static final String LINE_NUMBER_KEY = "lineNumberRuler";
    private static final String REVISION_ASK_BEFORE_QUICKDIFF_SWITCH_KEY = "quickdiff.nowarn.before.switch";
    private IVerticalRulerColumn fDelegate;
    private final MarkerAnnotationPreferences fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
    private PropertyEventDispatcher fDispatcher;
    private ISourceViewer fViewer;
    private ICompatibilityForwarder fForwarder;

    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        Assert.isTrue((this.fDelegate != null ? 1 : 0) != 0);
        ITextViewer iTextViewer = compositeRuler.getTextViewer();
        Assert.isLegal((boolean)(iTextViewer instanceof ISourceViewer));
        this.fViewer = (ISourceViewer)iTextViewer;
        this.initialize();
        Control control = this.fDelegate.createControl(compositeRuler, composite);
        return control;
    }

    public Control getControl() {
        return this.fDelegate.getControl();
    }

    public int getWidth() {
        return this.fDelegate.getWidth();
    }

    public void redraw() {
        this.fDelegate.redraw();
    }

    public void setFont(Font font) {
        this.fDelegate.setFont(font);
    }

    public void setModel(IAnnotationModel iAnnotationModel) {
        if (this.getQuickDiffPreference()) {
            this.fDelegate.setModel(iAnnotationModel);
        }
    }

    public int getLineOfLastMouseButtonActivity() {
        if (this.fDelegate instanceof IVerticalRulerInfo) {
            return ((IVerticalRulerInfo)this.fDelegate).getLineOfLastMouseButtonActivity();
        }
        return -1;
    }

    public int toDocumentLineNumber(int n) {
        if (this.fDelegate instanceof IVerticalRulerInfo) {
            return ((IVerticalRulerInfo)this.fDelegate).toDocumentLineNumber(n);
        }
        return -1;
    }

    public void addVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            ((IVerticalRulerInfoExtension)this.fDelegate).addVerticalRulerListener(iVerticalRulerListener);
        }
    }

    public IAnnotationHover getHover() {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            return ((IVerticalRulerInfoExtension)this.fDelegate).getHover();
        }
        return null;
    }

    public IAnnotationModel getModel() {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            return ((IVerticalRulerInfoExtension)this.fDelegate).getModel();
        }
        return null;
    }

    public void removeVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            ((IVerticalRulerInfoExtension)this.fDelegate).removeVerticalRulerListener(iVerticalRulerListener);
        }
    }

    public void columnRemoved() {
        if (this.fDispatcher != null) {
            this.fDispatcher.dispose();
            this.fDispatcher = null;
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return EditorsUI.getPreferenceStore();
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    private void initialize() {
        final IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore == null) {
            return;
        }
        this.updateForegroundColor(iPreferenceStore, this.fDelegate);
        this.updateBackgroundColor(iPreferenceStore, this.fDelegate);
        this.updateLineNumbersVisibility(this.fDelegate);
        this.updateQuickDiffVisibility(this.fDelegate);
        this.updateCharacterMode(iPreferenceStore, this.fDelegate);
        this.updateRevisionRenderingMode(iPreferenceStore, this.fDelegate);
        this.updateRevisionAuthorVisibility(iPreferenceStore, this.fDelegate);
        this.updateRevisionIdVisibility(iPreferenceStore, this.fDelegate);
        Map map = this.getAnnotationPreferenceMap();
        final AnnotationPreference annotationPreference = (AnnotationPreference)map.get("org.eclipse.ui.workbench.texteditor.quickdiffChange");
        final AnnotationPreference annotationPreference2 = (AnnotationPreference)map.get("org.eclipse.ui.workbench.texteditor.quickdiffAddition");
        final AnnotationPreference annotationPreference3 = (AnnotationPreference)map.get("org.eclipse.ui.workbench.texteditor.quickdiffDeletion");
        this.updateChangedColor(annotationPreference, iPreferenceStore, this.fDelegate);
        this.updateAddedColor(annotationPreference2, iPreferenceStore, this.fDelegate);
        this.updateDeletedColor(annotationPreference3, iPreferenceStore, this.fDelegate);
        this.fDelegate.redraw();
        this.fDispatcher = new PropertyEventDispatcher(iPreferenceStore);
        this.fDispatcher.addPropertyChangeListener(FG_COLOR_KEY, new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineNumberColumn.this.updateForegroundColor(iPreferenceStore, LineNumberColumn.this.fDelegate);
                LineNumberColumn.this.fDelegate.redraw();
            }
        });
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineNumberColumn.this.updateBackgroundColor(iPreferenceStore, LineNumberColumn.this.fDelegate);
                LineNumberColumn.this.fDelegate.redraw();
            }
        };
        this.fDispatcher.addPropertyChangeListener(BG_COLOR_KEY, iPropertyChangeListener);
        this.fDispatcher.addPropertyChangeListener(USE_DEFAULT_BG_KEY, iPropertyChangeListener);
        this.fDispatcher.addPropertyChangeListener(LINE_NUMBER_KEY, new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineNumberColumn.this.updateLineNumbersVisibility(LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("quickdiff.characterMode", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineNumberColumn.this.updateCharacterMode(iPreferenceStore, LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("revisionRulerRenderingMode", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineNumberColumn.this.updateRevisionRenderingMode(iPreferenceStore, LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("revisionRulerShowAuthor", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineNumberColumn.this.updateRevisionAuthorVisibility(iPreferenceStore, LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("revisionRulerShowRevision", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineNumberColumn.this.updateRevisionIdVisibility(iPreferenceStore, LineNumberColumn.this.fDelegate);
            }
        });
        this.fDispatcher.addPropertyChangeListener("quickdiff.quickDiff", new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LineNumberColumn.this.updateQuickDiffVisibility(LineNumberColumn.this.fDelegate);
            }
        });
        if (annotationPreference != null) {
            this.fDispatcher.addPropertyChangeListener(annotationPreference.getColorPreferenceKey(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LineNumberColumn.this.updateChangedColor(annotationPreference, iPreferenceStore, LineNumberColumn.this.fDelegate);
                    LineNumberColumn.this.fDelegate.redraw();
                }
            });
        }
        if (annotationPreference2 != null) {
            this.fDispatcher.addPropertyChangeListener(annotationPreference2.getColorPreferenceKey(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LineNumberColumn.this.updateAddedColor(annotationPreference2, iPreferenceStore, LineNumberColumn.this.fDelegate);
                    LineNumberColumn.this.fDelegate.redraw();
                }
            });
        }
        if (annotationPreference3 != null) {
            this.fDispatcher.addPropertyChangeListener(annotationPreference3.getColorPreferenceKey(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LineNumberColumn.this.updateDeletedColor(annotationPreference3, iPreferenceStore, LineNumberColumn.this.fDelegate);
                    LineNumberColumn.this.fDelegate.redraw();
                }
            });
        }
    }

    private Map getAnnotationPreferenceMap() {
        HashMap<Object, AnnotationPreference> hashMap = new HashMap<Object, AnnotationPreference>();
        for (AnnotationPreference annotationPreference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            Object object = annotationPreference.getAnnotationType();
            hashMap.put(object, annotationPreference);
        }
        return hashMap;
    }

    private void updateForegroundColor(IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        RGB rGB = LineNumberColumn.getColorFromStore(iPreferenceStore, FG_COLOR_KEY);
        if (rGB == null) {
            rGB = new RGB(0, 0, 0);
        }
        ISharedTextColors iSharedTextColors = this.getSharedColors();
        if (iVerticalRulerColumn instanceof LineNumberRulerColumn) {
            ((LineNumberRulerColumn)iVerticalRulerColumn).setForeground(iSharedTextColors.getColor(rGB));
        }
    }

    private void updateBackgroundColor(IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        RGB rGB = iPreferenceStore.getBoolean(USE_DEFAULT_BG_KEY) ? null : LineNumberColumn.getColorFromStore(iPreferenceStore, BG_COLOR_KEY);
        ISharedTextColors iSharedTextColors = this.getSharedColors();
        if (iVerticalRulerColumn instanceof LineNumberRulerColumn) {
            ((LineNumberRulerColumn)iVerticalRulerColumn).setBackground(iSharedTextColors.getColor(rGB));
        }
    }

    private void updateChangedColor(AnnotationPreference annotationPreference, IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        if (annotationPreference != null && iVerticalRulerColumn instanceof IChangeRulerColumn) {
            RGB rGB = LineNumberColumn.getColorFromAnnotationPreference(iPreferenceStore, annotationPreference);
            ((IChangeRulerColumn)iVerticalRulerColumn).setChangedColor(this.getSharedColors().getColor(rGB));
        }
    }

    private void updateAddedColor(AnnotationPreference annotationPreference, IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        if (annotationPreference != null && iVerticalRulerColumn instanceof IChangeRulerColumn) {
            RGB rGB = LineNumberColumn.getColorFromAnnotationPreference(iPreferenceStore, annotationPreference);
            ((IChangeRulerColumn)iVerticalRulerColumn).setAddedColor(this.getSharedColors().getColor(rGB));
        }
    }

    private void updateDeletedColor(AnnotationPreference annotationPreference, IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        if (annotationPreference != null && iVerticalRulerColumn instanceof IChangeRulerColumn) {
            RGB rGB = LineNumberColumn.getColorFromAnnotationPreference(iPreferenceStore, annotationPreference);
            ((IChangeRulerColumn)iVerticalRulerColumn).setDeletedColor(this.getSharedColors().getColor(rGB));
        }
    }

    private void updateCharacterMode(IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        if (iVerticalRulerColumn instanceof LineNumberChangeRulerColumn) {
            LineNumberChangeRulerColumn lineNumberChangeRulerColumn = (LineNumberChangeRulerColumn)iVerticalRulerColumn;
            lineNumberChangeRulerColumn.setDisplayMode(iPreferenceStore.getBoolean("quickdiff.characterMode"));
        }
    }

    private void updateLineNumbersVisibility(IVerticalRulerColumn iVerticalRulerColumn) {
        if (iVerticalRulerColumn instanceof LineNumberChangeRulerColumn) {
            ((LineNumberChangeRulerColumn)iVerticalRulerColumn).showLineNumbers(this.getLineNumberPreference());
        }
    }

    private void updateRevisionRenderingMode(IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        if (iVerticalRulerColumn instanceof IRevisionRulerColumnExtension) {
            String string = iPreferenceStore.getString("revisionRulerRenderingMode");
            IRevisionRulerColumnExtension.RenderingMode[] renderingModeArray = new IRevisionRulerColumnExtension.RenderingMode[]{IRevisionRulerColumnExtension.AUTHOR, IRevisionRulerColumnExtension.AGE, IRevisionRulerColumnExtension.AUTHOR_SHADED_BY_AGE};
            int n = 0;
            while (n < renderingModeArray.length) {
                if (renderingModeArray[n].name().equals(string)) {
                    ((IRevisionRulerColumnExtension)iVerticalRulerColumn).setRevisionRenderingMode(renderingModeArray[n]);
                    return;
                }
                ++n;
            }
        }
    }

    private void updateRevisionAuthorVisibility(IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        if (iVerticalRulerColumn instanceof IRevisionRulerColumnExtension) {
            boolean bl = iPreferenceStore.getBoolean("revisionRulerShowAuthor");
            ((IRevisionRulerColumnExtension)iVerticalRulerColumn).showRevisionAuthor(bl);
        }
    }

    private void updateRevisionIdVisibility(IPreferenceStore iPreferenceStore, IVerticalRulerColumn iVerticalRulerColumn) {
        if (iVerticalRulerColumn instanceof IRevisionRulerColumnExtension) {
            boolean bl = iPreferenceStore.getBoolean("revisionRulerShowRevision");
            ((IRevisionRulerColumnExtension)iVerticalRulerColumn).showRevisionId(bl);
        }
    }

    private void updateQuickDiffVisibility(IVerticalRulerColumn iVerticalRulerColumn) {
        boolean bl = this.getQuickDiffPreference();
        if (bl == this.isShowingChangeInformation()) {
            return;
        }
        if (bl) {
            this.installChangeRulerModel(iVerticalRulerColumn);
        } else {
            this.uninstallChangeRulerModel(iVerticalRulerColumn);
        }
    }

    private boolean getLineNumberPreference() {
        if (this.fForwarder != null) {
            return this.fForwarder.isLineNumberRulerVisible();
        }
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return iPreferenceStore != null ? iPreferenceStore.getBoolean(LINE_NUMBER_KEY) : false;
    }

    private boolean getQuickDiffPreference() {
        boolean bl;
        boolean bl2;
        if (this.fForwarder != null) {
            return this.fForwarder.isQuickDiffEnabled();
        }
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl3 = bl2 = iPreferenceStore != null ? iPreferenceStore.getBoolean("quickdiff.quickDiff") : false;
        if (!bl2) {
            return false;
        }
        ITextEditor iTextEditor = this.getEditor();
        if (iTextEditor instanceof ITextEditorExtension2) {
            ITextEditorExtension2 iTextEditorExtension2 = (ITextEditorExtension2)iTextEditor;
            bl = iTextEditorExtension2.isEditorInputModifiable();
        } else if (iTextEditor instanceof ITextEditorExtension) {
            ITextEditorExtension iTextEditorExtension = (ITextEditorExtension)iTextEditor;
            bl = iTextEditorExtension.isEditorInputReadOnly();
        } else {
            bl = iTextEditor != null ? iTextEditor.isEditable() : true;
        }
        return bl;
    }

    private static RGB getColorFromAnnotationPreference(IPreferenceStore iPreferenceStore, AnnotationPreference annotationPreference) {
        String string = annotationPreference.getColorPreferenceKey();
        RGB rGB = null;
        if (iPreferenceStore.contains(string)) {
            rGB = iPreferenceStore.isDefault(string) ? annotationPreference.getColorPreferenceValue() : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        }
        if (rGB == null) {
            rGB = annotationPreference.getColorPreferenceValue();
        }
        return rGB;
    }

    private static RGB getColorFromStore(IPreferenceStore iPreferenceStore, String string) {
        RGB rGB = null;
        if (iPreferenceStore.contains(string)) {
            rGB = iPreferenceStore.isDefault(string) ? PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string) : PreferenceConverter.getColor((IPreferenceStore)iPreferenceStore, (String)string);
        }
        return rGB;
    }

    private boolean ensureQuickDiffProvider(String string) {
        IAnnotationModelExtension iAnnotationModelExtension;
        if (!this.isShowingChangeInformation()) {
            this.installChangeRulerModel(this.fDelegate);
        }
        IAnnotationModel iAnnotationModel = this.fViewer.getAnnotationModel();
        IAnnotationModel iAnnotationModel2 = this.getDiffer();
        if (iAnnotationModel2 == null && iAnnotationModel != null) {
            return false;
        }
        if (iAnnotationModel == null) {
            iAnnotationModel = new AnnotationModel();
        }
        if (!(iAnnotationModel instanceof IAnnotationModelExtension)) {
            return false;
        }
        QuickDiff quickDiff = new QuickDiff();
        Object object = quickDiff.getConfiguredQuickDiffProvider(iAnnotationModel2);
        if (object.equals(string)) {
            if (iAnnotationModel2 instanceof ILineDifferExtension) {
                ((ILineDifferExtension)iAnnotationModel2).resume();
            }
            return true;
        }
        IAnnotationModel iAnnotationModel3 = quickDiff.createQuickDiffAnnotationModel(this.getEditor(), string);
        if (quickDiff.getConfiguredQuickDiffProvider(iAnnotationModel3).equals(object)) {
            if (iAnnotationModel2 instanceof ILineDifferExtension) {
                ((ILineDifferExtension)iAnnotationModel2).resume();
            }
            return true;
        }
        IPreferenceStore iPreferenceStore = EditorsUI.getPreferenceStore();
        if (iAnnotationModel2 != null && !iPreferenceStore.getString(REVISION_ASK_BEFORE_QUICKDIFF_SWITCH_KEY).equals("always") && (iAnnotationModelExtension = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.fViewer.getTextWidget().getShell(), (String)RulerMessages.AbstractDecoratedTextEditor_revision_quickdiff_switch_title, (String)RulerMessages.AbstractDecoratedTextEditor_revision_quickdiff_switch_message, (String)RulerMessages.AbstractDecoratedTextEditor_revision_quickdiff_switch_rememberquestion, (boolean)true, (IPreferenceStore)iPreferenceStore, (String)REVISION_ASK_BEFORE_QUICKDIFF_SWITCH_KEY)).getReturnCode() != 0) {
            return false;
        }
        iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
        iAnnotationModelExtension.removeAnnotationModel((Object)"diff");
        iAnnotationModelExtension.addAnnotationModel((Object)"diff", iAnnotationModel3);
        if (this.fDelegate instanceof IChangeRulerColumn) {
            ((IChangeRulerColumn)this.fDelegate).setModel(iAnnotationModel);
        }
        return true;
    }

    private void installChangeRulerModel(IVerticalRulerColumn iVerticalRulerColumn) {
        if (iVerticalRulerColumn instanceof IChangeRulerColumn) {
            ISourceViewer iSourceViewer;
            IAnnotationModel iAnnotationModel = this.getAnnotationModelWithDiffer();
            ((IChangeRulerColumn)iVerticalRulerColumn).setModel(iAnnotationModel);
            if (iAnnotationModel != null && (iSourceViewer = this.fViewer) != null && iSourceViewer.getAnnotationModel() == null && iVerticalRulerColumn.getControl() != null) {
                iSourceViewer.showAnnotations(true);
            }
        }
    }

    private void uninstallChangeRulerModel(IVerticalRulerColumn iVerticalRulerColumn) {
        ISourceViewer iSourceViewer;
        IAnnotationModel iAnnotationModel;
        if (iVerticalRulerColumn instanceof IChangeRulerColumn) {
            ((IChangeRulerColumn)iVerticalRulerColumn).setModel(null);
        }
        if ((iAnnotationModel = this.getDiffer()) instanceof ILineDifferExtension) {
            ((ILineDifferExtension)iAnnotationModel).suspend();
        }
        if ((iSourceViewer = this.fViewer) != null && iSourceViewer.getAnnotationModel() == null) {
            iSourceViewer.showAnnotations(false);
        }
    }

    private IAnnotationModel getAnnotationModelWithDiffer() {
        IAnnotationModel iAnnotationModel;
        ISourceViewer iSourceViewer = this.fViewer;
        if (iSourceViewer == null) {
            return null;
        }
        IAnnotationModel iAnnotationModel2 = iSourceViewer.getAnnotationModel();
        IAnnotationModelExtension iAnnotationModelExtension = null;
        if (iAnnotationModel2 instanceof IAnnotationModelExtension) {
            iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel2;
        }
        if ((iAnnotationModel = this.getDiffer()) == null) {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            if (iPreferenceStore != null) {
                String string = iPreferenceStore.getString("quickdiff.defaultProvider");
                iAnnotationModel = new QuickDiff().createQuickDiffAnnotationModel(this.getEditor(), string);
                if (iAnnotationModel != null) {
                    if (iAnnotationModelExtension == null) {
                        iAnnotationModelExtension = new AnnotationModel();
                    }
                    iAnnotationModelExtension.addAnnotationModel((Object)"diff", iAnnotationModel);
                }
            }
        } else if (iAnnotationModel instanceof ILineDifferExtension2) {
            if (((ILineDifferExtension2)iAnnotationModel).isSuspended()) {
                ((ILineDifferExtension)iAnnotationModel).resume();
            }
        } else if (iAnnotationModel instanceof ILineDifferExtension) {
            ((ILineDifferExtension)iAnnotationModel).resume();
        }
        return (IAnnotationModel)iAnnotationModelExtension;
    }

    private IAnnotationModel getDiffer() {
        ISourceViewer iSourceViewer = this.fViewer;
        if (iSourceViewer == null) {
            return null;
        }
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        if (iAnnotationModel == null && this.fDelegate instanceof IChangeRulerColumn) {
            iAnnotationModel = ((IChangeRulerColumn)this.fDelegate).getModel();
        }
        if (!(iAnnotationModel instanceof IAnnotationModelExtension)) {
            return null;
        }
        IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
        return iAnnotationModelExtension.getAnnotationModel((Object)"diff");
    }

    public void setForwarder(ICompatibilityForwarder iCompatibilityForwarder) {
        this.fForwarder = iCompatibilityForwarder;
        this.fDelegate = iCompatibilityForwarder.createLineNumberRulerColumn();
    }

    public void initializeLineNumberRulerColumn(LineNumberRulerColumn lineNumberRulerColumn) {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (iPreferenceStore != null) {
            this.updateForegroundColor(iPreferenceStore, (IVerticalRulerColumn)lineNumberRulerColumn);
            this.updateBackgroundColor(iPreferenceStore, (IVerticalRulerColumn)lineNumberRulerColumn);
            this.updateLineNumbersVisibility((IVerticalRulerColumn)lineNumberRulerColumn);
            lineNumberRulerColumn.redraw();
        }
    }

    public boolean isShowingLineNumbers() {
        return this.fDelegate instanceof LineNumberChangeRulerColumn && ((LineNumberChangeRulerColumn)this.fDelegate).isShowingLineNumbers();
    }

    public boolean isShowingChangeInformation() {
        return this.fDelegate instanceof LineNumberChangeRulerColumn && ((LineNumberChangeRulerColumn)this.fDelegate).isShowingChangeInformation();
    }

    public void showRevisionInformation(RevisionInformation revisionInformation, String string) {
        if (!this.ensureQuickDiffProvider(string)) {
            return;
        }
        if (this.fDelegate instanceof IRevisionRulerColumn) {
            ((IRevisionRulerColumn)this.fDelegate).setRevisionInformation(revisionInformation);
        }
    }

    public void hideRevisionInformation() {
        if (this.fDelegate instanceof IRevisionRulerColumn) {
            ((IRevisionRulerColumn)this.fDelegate).setRevisionInformation(null);
        }
    }

    public boolean isShowingRevisionInformation() {
        if (this.fDelegate instanceof LineNumberChangeRulerColumn) {
            return ((LineNumberChangeRulerColumn)this.fDelegate).isShowingRevisionInformation();
        }
        return false;
    }

    public ISelectionProvider getRevisionSelectionProvider() {
        if (this.fDelegate instanceof IRevisionRulerColumnExtension) {
            return ((IRevisionRulerColumnExtension)this.fDelegate).getRevisionSelectionProvider();
        }
        return null;
    }

    public static interface ICompatibilityForwarder {
        public IVerticalRulerColumn createLineNumberRulerColumn();

        public boolean isQuickDiffEnabled();

        public boolean isLineNumberRulerVisible();
    }
}

