/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.texteditor.AnnotationType;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;

public class DelegatingAnnotationPreference
extends AnnotationPreference {
    private AnnotationType fType;
    private AnnotationPreferenceLookup fLookup;
    private Set fCache = new HashSet();

    public DelegatingAnnotationPreference(AnnotationType annotationType, AnnotationPreferenceLookup annotationPreferenceLookup) {
        this.fType = annotationType;
        this.fLookup = annotationPreferenceLookup;
    }

    private boolean isCached(Object object) {
        return this.fCache.contains(object);
    }

    private void markCached(Object object) {
        this.fCache.add(object);
    }

    private AnnotationPreference getDefiningPreference(Object object) {
        AnnotationPreference annotationPreference = this.fLookup.getAnnotationPreferenceFragment(this.fType.getType());
        if (annotationPreference != null && annotationPreference.hasValue(object)) {
            return annotationPreference;
        }
        String[] stringArray = this.fType.getSuperTypes();
        int n = 0;
        while (n < stringArray.length) {
            annotationPreference = this.fLookup.getAnnotationPreferenceFragment(stringArray[n]);
            if (annotationPreference != null && annotationPreference.hasValue(object)) {
                return annotationPreference;
            }
            ++n;
        }
        return null;
    }

    private Object getAttributeValue(Object object) {
        if (!this.isCached(object)) {
            AnnotationPreference annotationPreference = this.getDefiningPreference(object);
            if (annotationPreference != null) {
                this.setValue(object, annotationPreference.getValue(object));
            }
            this.markCached(object);
        }
        return super.getValue(object);
    }

    private boolean getBooleanAttributeValue(Object object) {
        Object object2 = this.getAttributeValue(object);
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        return false;
    }

    public Object getAnnotationType() {
        return this.fType.getType();
    }

    public boolean contributesToHeader() {
        return this.getBooleanAttributeValue(HEADER_VALUE);
    }

    public IAnnotationImageProvider getAnnotationImageProvider() {
        if (!this.isCached(IMAGE_PROVIDER)) {
            AnnotationPreference annotationPreference = this.getDefiningPreference(IMAGE_PROVIDER);
            if (annotationPreference != null) {
                this.fAnnotationImageProvider = annotationPreference.fAnnotationImageProvider;
                this.fAnnotationImageProviderAttribute = annotationPreference.fAnnotationImageProviderAttribute;
                this.fConfigurationElement = annotationPreference.fConfigurationElement;
            }
            this.markCached(IMAGE_PROVIDER);
        }
        return super.getAnnotationImageProvider();
    }

    public String getColorPreferenceKey() {
        return (String)this.getAttributeValue(COLOR_PREFERENCE_KEY);
    }

    public RGB getColorPreferenceValue() {
        return (RGB)this.getAttributeValue(COLOR_PREFERENCE_VALUE);
    }

    public String getHighlightPreferenceKey() {
        return (String)this.getAttributeValue(HIGHLIGHT_PREFERENCE_KEY);
    }

    public boolean getHighlightPreferenceValue() {
        return this.getBooleanAttributeValue(HIGHLIGHT_PREFERENCE_VALUE);
    }

    public ImageDescriptor getImageDescriptor() {
        return (ImageDescriptor)this.getAttributeValue(IMAGE_DESCRIPTOR);
    }

    public ImageDescriptor getQuickFixImageDescriptor() {
        return (ImageDescriptor)this.getAttributeValue(QUICK_FIX_IMAGE_DESCRIPTOR);
    }

    public String getIsGoToNextNavigationTargetKey() {
        return (String)this.getAttributeValue(IS_GO_TO_NEXT_TARGET_KEY);
    }

    public String getIsGoToPreviousNavigationTargetKey() {
        return (String)this.getAttributeValue(IS_GO_TO_PREVIOUS_TARGET_KEY);
    }

    public String getOverviewRulerPreferenceKey() {
        return (String)this.getAttributeValue(OVERVIEW_RULER_PREFERENCE_KEY);
    }

    public boolean getOverviewRulerPreferenceValue() {
        return this.getBooleanAttributeValue(OVERVIEW_RULER_PREFERENCE_VALUE);
    }

    public String getPreferenceLabel() {
        return (String)this.getAttributeValue(PREFERENCE_LABEL);
    }

    public int getPresentationLayer() {
        Object object = this.getAttributeValue(PRESENTATION_LAYER);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public String getShowInNextPrevDropdownToolbarActionKey() {
        return (String)this.getAttributeValue(SHOW_IN_NAVIGATION_DROPDOWN_KEY);
    }

    public String getSymbolicImageName() {
        return (String)this.getAttributeValue(SYMBOLIC_IMAGE_NAME);
    }

    public String getTextPreferenceKey() {
        return (String)this.getAttributeValue(TEXT_PREFERENCE_KEY);
    }

    public boolean getTextPreferenceValue() {
        return this.getBooleanAttributeValue(TEXT_PREFERENCE_VALUE);
    }

    public String getVerticalRulerPreferenceKey() {
        return (String)this.getAttributeValue(VERTICAL_RULER_PREFERENCE_KEY);
    }

    public boolean getVerticalRulerPreferenceValue() {
        return this.getBooleanAttributeValue(VERTICAL_RULER_PREFERENCE_VALUE);
    }

    public boolean isGoToNextNavigationTarget() {
        return this.getBooleanAttributeValue(IS_GO_TO_NEXT_TARGET_VALUE);
    }

    public boolean isGoToPreviousNavigationTarget() {
        return this.getBooleanAttributeValue(IS_GO_TO_PREVIOUS_TARGET_VALUE);
    }

    public boolean isShowInNextPrevDropdownToolbarAction() {
        return this.getBooleanAttributeValue(SHOW_IN_NAVIGATION_DROPDOWN_VALUE);
    }

    public String getTextStylePreferenceKey() {
        return (String)this.getAttributeValue(TEXT_STYLE_PREFERENCE_KEY);
    }

    public String getTextStyleValue() {
        return (String)this.getAttributeValue(TEXT_STYLE_PREFERENCE_VALUE);
    }

    public Object getValue(Object object) {
        return this.getAttributeValue(object);
    }
}

