/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.texteditor.AnnotationType;

public final class AnnotationTypeHierarchy {
    private Map fTypeMap;
    private Map fTypesCache = new HashMap();

    public AnnotationType getAnnotationType(String string) {
        AnnotationType annotationType = (AnnotationType)this.fTypesCache.get(string);
        if (annotationType == null) {
            String[] stringArray = this.computeSuperTypes(string);
            annotationType = new AnnotationType(string, stringArray);
            this.fTypesCache.put(string, annotationType);
        }
        return annotationType;
    }

    public boolean isSubtype(String string, String string2) {
        AnnotationType annotationType = this.getAnnotationType(string2);
        return annotationType.isSubtype(string);
    }

    private String[] computeSuperTypes(String string) {
        String[] stringArray;
        ArrayList arrayList = new ArrayList();
        this.append(arrayList, this.getDirectSuperType(string));
        int n = 0;
        while (n < arrayList.size()) {
            stringArray = (String)arrayList.get(n++);
            this.append(arrayList, this.getDirectSuperType((String)stringArray));
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String getDirectSuperType(String string) {
        return (String)this.getTypeMap().get(string);
    }

    private void append(List list, String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (!list.contains(string)) {
            list.add(string);
        }
    }

    private Map getTypeMap() {
        if (this.fTypeMap == null) {
            this.fTypeMap = this.readTypes();
        }
        return this.fTypeMap;
    }

    private Map readTypes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "annotationTypes");
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                String string = iConfigurationElement.getAttribute("name");
                if (string != null && string.trim().length() != 0) {
                    String string2 = iConfigurationElement.getAttribute("super");
                    if (string2 == null || string2.trim().length() == 0) {
                        string2 = "";
                    }
                    hashMap.put(string, string2);
                }
                ++n;
            }
        }
        return hashMap;
    }
}

