/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.rulers.AbstractContributedRulerColumn;

public class AnnotationColumn
extends AbstractContributedRulerColumn
implements IVerticalRulerInfo,
IVerticalRulerInfoExtension {
    public static final String ID = "org.eclipse.ui.editors.columns.annotations";
    private static final int VERTICAL_RULER_WIDTH = 12;
    private IVerticalRulerColumn fDelegate;
    private final MarkerAnnotationPreferences fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
    private IPropertyChangeListener fPropertyListener;

    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        this.initialize();
        Control control = this.fDelegate.createControl(compositeRuler, composite);
        return control;
    }

    public Control getControl() {
        return this.fDelegate.getControl();
    }

    public int getWidth() {
        return this.fDelegate.getWidth();
    }

    public void redraw() {
        this.fDelegate.redraw();
    }

    public void setFont(Font font) {
        this.fDelegate.setFont(font);
    }

    public void setModel(IAnnotationModel iAnnotationModel) {
        this.fDelegate.setModel(iAnnotationModel);
    }

    public void columnRemoved() {
        if (this.fPropertyListener != null) {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            if (iPreferenceStore != null) {
                iPreferenceStore.removePropertyChangeListener(this.fPropertyListener);
            }
            this.fPropertyListener = null;
        }
    }

    private void initialize() {
        IPreferenceStore iPreferenceStore;
        if (this.fDelegate == null) {
            this.fDelegate = new AnnotationRulerColumn(12, (IAnnotationAccess)new DefaultMarkerAnnotationAccess());
        }
        if ((iPreferenceStore = this.getPreferenceStore()) != null && this.fDelegate instanceof AnnotationRulerColumn) {
            final AnnotationRulerColumn annotationRulerColumn = (AnnotationRulerColumn)this.fDelegate;
            for (AnnotationPreference annotationPreference : this.fAnnotationPreferences.getAnnotationPreferences()) {
                String string = annotationPreference.getVerticalRulerPreferenceKey();
                boolean bl = true;
                if (string != null && iPreferenceStore.contains(string)) {
                    bl = iPreferenceStore.getBoolean(string);
                }
                if (!bl) continue;
                annotationRulerColumn.addAnnotationType(annotationPreference.getAnnotationType());
            }
            annotationRulerColumn.addAnnotationType((Object)"org.eclipse.text.annotation.unknown");
            this.fPropertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getProperty();
                    AnnotationPreference annotationPreference = AnnotationColumn.this.getVerticalRulerAnnotationPreference(string);
                    if (annotationPreference != null && string.equals(annotationPreference.getVerticalRulerPreferenceKey())) {
                        Object object = annotationPreference.getAnnotationType();
                        if (AnnotationColumn.this.getPreferenceStore().getBoolean(string)) {
                            annotationRulerColumn.addAnnotationType(object);
                        } else {
                            annotationRulerColumn.removeAnnotationType(object);
                        }
                        annotationRulerColumn.redraw();
                    }
                }
            };
            iPreferenceStore.addPropertyChangeListener(this.fPropertyListener);
        }
    }

    private AnnotationPreference getVerticalRulerAnnotationPreference(String string) {
        if (string == null) {
            return null;
        }
        for (AnnotationPreference annotationPreference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (annotationPreference == null || !string.equals(annotationPreference.getVerticalRulerPreferenceKey())) continue;
            return annotationPreference;
        }
        return null;
    }

    private IPreferenceStore getPreferenceStore() {
        return EditorsUI.getPreferenceStore();
    }

    public void setDelegate(IVerticalRulerColumn iVerticalRulerColumn) {
        Assert.isLegal((this.fDelegate == null ? 1 : 0) != 0);
        Assert.isLegal((iVerticalRulerColumn != null ? 1 : 0) != 0);
        this.fDelegate = iVerticalRulerColumn;
    }

    public void addVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            ((IVerticalRulerInfoExtension)this.fDelegate).addVerticalRulerListener(iVerticalRulerListener);
        }
    }

    public IAnnotationHover getHover() {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            return ((IVerticalRulerInfoExtension)this.fDelegate).getHover();
        }
        return null;
    }

    public IAnnotationModel getModel() {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            return ((IVerticalRulerInfoExtension)this.fDelegate).getModel();
        }
        return null;
    }

    public void removeVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        if (this.fDelegate instanceof IVerticalRulerInfoExtension) {
            ((IVerticalRulerInfoExtension)this.fDelegate).removeVerticalRulerListener(iVerticalRulerListener);
        }
    }

    public int getLineOfLastMouseButtonActivity() {
        if (this.fDelegate instanceof IVerticalRulerInfo) {
            return ((IVerticalRulerInfo)this.fDelegate).getLineOfLastMouseButtonActivity();
        }
        return -1;
    }

    public int toDocumentLineNumber(int n) {
        if (this.fDelegate instanceof IVerticalRulerInfo) {
            return ((IVerticalRulerInfo)this.fDelegate).toDocumentLineNumber(n);
        }
        return -1;
    }
}

