/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class UntitledTextFileWizard
extends Wizard
implements INewWizard {
    private IWorkbenchWindow fWindow;

    public void dispose() {
        this.fWindow = null;
    }

    private IFileStore queryFileStore() {
        IPath iPath = EditorsPlugin.getDefault().getStateLocation();
        IPath iPath2 = iPath.append("/_" + new Object().hashCode());
        return EFS.getLocalFileSystem().getStore(iPath2);
    }

    private String getEditorId(IFileStore iFileStore) {
        IWorkbench iWorkbench = this.fWindow.getWorkbench();
        IEditorRegistry iEditorRegistry = iWorkbench.getEditorRegistry();
        IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(iFileStore.getName());
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    private IEditorInput createEditorInput(IFileStore iFileStore) {
        return new NonExistingFileEditorInput(iFileStore, TextEditorMessages.NewTextEditorAction_namePrefix);
    }

    public boolean performFinish() {
        IFileStore iFileStore = this.queryFileStore();
        IEditorInput iEditorInput = this.createEditorInput(iFileStore);
        String string = this.getEditorId(iFileStore);
        IWorkbenchPage iWorkbenchPage = this.fWindow.getActivePage();
        try {
            iWorkbenchPage.openEditor(iEditorInput, string);
        }
        catch (PartInitException partInitException) {
            EditorsPlugin.log(partInitException);
            return false;
        }
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fWindow = iWorkbench.getActiveWorkbenchWindow();
    }
}

