/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class TextEditorDefaultsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String[][] fAppearanceColorListModel;
    private OverlayPreferenceStore fOverlayStore;
    private org.eclipse.swt.widgets.List fAppearanceColorList;
    private ColorSelector fAppearanceColorEditor;
    private Button fAppearanceColorDefault;
    private boolean fFieldsInitialized;
    private ArrayList fMasterSlaveListeners;
    private List fInitializers;
    private InitializerFactory fInitializerFactory;
    private Map fDomains;

    public TextEditorDefaultsPreferencePage() {
        String[][] stringArrayArray = new String[9][];
        String[] stringArray = new String[3];
        stringArray[0] = TextEditorMessages.TextEditorPreferencePage_lineNumberForegroundColor;
        stringArray[1] = "lineNumberColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = TextEditorMessages.TextEditorPreferencePage_currentLineHighlighColor;
        stringArray2[1] = "currentLineColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = TextEditorMessages.TextEditorPreferencePage_printMarginColor;
        stringArray3[1] = "printMarginColor";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = TextEditorMessages.TextEditorPreferencePage_findScopeColor;
        stringArray4[1] = "AbstractTextEditor.Color.FindScope";
        stringArrayArray[3] = stringArray4;
        stringArrayArray[4] = new String[]{TextEditorMessages.TextEditorPreferencePage_selectionForegroundColor, "AbstractTextEditor.Color.SelectionForeground", "AbstractTextEditor.Color.SelectionForeground.SystemDefault"};
        stringArrayArray[5] = new String[]{TextEditorMessages.TextEditorPreferencePage_selectionBackgroundColor, "AbstractTextEditor.Color.SelectionBackground", "AbstractTextEditor.Color.SelectionBackground.SystemDefault"};
        stringArrayArray[6] = new String[]{TextEditorMessages.TextEditorPreferencePage_backgroundColor, "AbstractTextEditor.Color.Background", "AbstractTextEditor.Color.Background.SystemDefault"};
        stringArrayArray[7] = new String[]{TextEditorMessages.TextEditorPreferencePage_foregroundColor, "AbstractTextEditor.Color.Foreground", "AbstractTextEditor.Color.Foreground.SystemDefault"};
        stringArrayArray[8] = new String[]{TextEditorMessages.HyperlinkColor_label, "hyperlinkColor", "hyperlinkColor.SystemDefault"};
        this.fAppearanceColorListModel = stringArrayArray;
        this.fFieldsInitialized = false;
        this.fMasterSlaveListeners = new ArrayList();
        this.fInitializers = new ArrayList();
        this.fDomains = new HashMap();
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
        this.fInitializerFactory = new InitializerFactory(this.fOverlayStore);
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.FindScope"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "tabWidth"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spacesForTabs"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "undoHistorySize"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionForeground"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionForeground.SystemDefault"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionBackground"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionBackground.SystemDefault"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Foreground"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Foreground.SystemDefault"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "hyperlinksEnabled"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hyperlinkColor"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "hyperlinkColor.SystemDefault"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hyperlinkKeyModifier"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "hyperlinkKeyModifierMask"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showWhitespaceCharacters"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "show_range_indicator"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "warn_if_input_derived"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "textDragAndDropEnabled"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTextHoverAffordance"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "hoverReplaceMode"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingSpaces"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedSpaces"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingSpaces"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingIdeographicSpaces"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedIdeographicSpaces"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingIdeographicSpaces"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingTabs"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedTabs"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingTabs"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showCarriageReturn"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLineFeed"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "whitespaceCharacterAlphaValue"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return new OverlayPreferenceStore(this.getPreferenceStore(), overlayKeyArray);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.text_editor_preference_page_context");
    }

    private void handleAppearanceColorListSelection() {
        int n = this.fAppearanceColorList.getSelectionIndex();
        if (n == -1) {
            return;
        }
        String string = this.fAppearanceColorListModel[n][1];
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)string);
        this.fAppearanceColorEditor.setColorValue(rGB);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[n][2]);
    }

    private void updateAppearanceColorWidgets(String string) {
        if (string == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean bl = this.fOverlayStore.getBoolean(string);
            this.fAppearanceColorDefault.setSelection(bl);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!bl);
        }
    }

    private Control createAppearancePage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Link link = new Link(composite2, 0);
        link.setText(TextEditorMessages.TextEditorPreferencePage_Font_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)TextEditorDefaultsPreferencePage.this.getShell(), (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", null, (Object)"selectFont:org.eclipse.jface.textfont");
            }
        });
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(composite2, 2);
        String string = TextEditorMessages.TextEditorPreferencePage_undoHistorySize;
        Preference preference = new Preference("undoHistorySize", string, null);
        IntegerDomain integerDomain = new IntegerDomain(0, 99999);
        this.addTextField(composite2, preference, integerDomain, 15, 0);
        string = TextEditorMessages.TextEditorPreferencePage_displayedTabWidth;
        Preference preference2 = new Preference("tabWidth", string, null);
        IntegerDomain integerDomain2 = new IntegerDomain(1, 16);
        this.addTextField(composite2, preference2, integerDomain2, 15, 0);
        string = TextEditorMessages.TextEditorPreferencePage_convertTabsToSpaces;
        Preference preference3 = new Preference("spacesForTabs", string, null);
        this.addCheckBox(composite2, preference3, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorPreferencePage_highlightCurrentLine;
        Preference preference4 = new Preference("currentLine", string, null);
        this.addCheckBox(composite2, preference4, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorPreferencePage_showPrintMargin;
        Preference preference5 = new Preference("printMargin", string, null);
        Button button = this.addCheckBox(composite2, preference5, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorPreferencePage_printMarginColumn;
        Preference preference6 = new Preference("printMarginColumn", string, null);
        final IntegerDomain integerDomain3 = new IntegerDomain(20, 200);
        Control[] controlArray = this.addTextField(composite2, preference6, integerDomain3, 15, 20);
        this.createDependency(button, preference5, controlArray);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditorDefaultsPreferencePage.this.updateStatus(integerDomain3);
            }
        });
        string = TextEditorMessages.TextEditorPreferencePage_showLineNumbers;
        Preference preference7 = new Preference("lineNumberRuler", string, null);
        this.addCheckBox(composite2, preference7, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorDefaultsPreferencePage_range_indicator;
        Preference preference8 = new Preference("show_range_indicator", string, null);
        this.addCheckBox(composite2, preference8, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorDefaultsPreferencePage_showWhitespaceCharacters;
        String string2 = TextEditorMessages.TextEditorDefaultsPreferencePage_showWhitespaceCharactersLinkText;
        Preference preference9 = new Preference("showWhitespaceCharacters", string, null);
        this.addCheckBoxWithLink(composite2, preference9, string2, new BooleanDomain(), 0, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WhitespaceCharacterPainterOptionsDialog whitespaceCharacterPainterOptionsDialog = new WhitespaceCharacterPainterOptionsDialog(Display.getDefault().getActiveShell(), TextEditorDefaultsPreferencePage.this.fOverlayStore);
                whitespaceCharacterPainterOptionsDialog.open();
            }
        });
        string = TextEditorMessages.TextEditorPreferencePage_showAffordance;
        Preference preference10 = new Preference("showTextHoverAffordance", string, null);
        this.addCheckBox(composite2, preference10, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHoverMode;
        Preference preference11 = new Preference("hoverReplaceMode", string, null);
        EnumeratedDomain enumeratedDomain = new EnumeratedDomain();
        enumeratedDomain.addValue(new EnumeratedDomain.EnumValue(-1, TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHover_disabled));
        enumeratedDomain.addValue(new EnumeratedDomain.EnumValue(1, TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHover_immediately));
        enumeratedDomain.addValue(new EnumeratedDomain.EnumValue(0, TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHover_afterDelay));
        enumeratedDomain.addValue(new EnumeratedDomain.EnumValue(2, TextEditorMessages.TextEditorDefaultsPreferencePage_enrichHover_onClick));
        this.addCombo(composite2, preference11, enumeratedDomain, 0);
        string = TextEditorMessages.TextEditorDefaultsPreferencePage_textDragAndDrop;
        Preference preference12 = new Preference("textDragAndDropEnabled", string, null);
        this.addCheckBox(composite2, preference12, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorDefaultsPreferencePage_warn_if_derived;
        Preference preference13 = new Preference("warn_if_input_derived", string, null);
        this.addCheckBox(composite2, preference13, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorDefaultsPreferencePage_smartHomeEnd;
        Preference preference14 = new Preference("AbstractTextEditor.Navigation.SmartHomeEnd", string, null);
        this.addCheckBox(composite2, preference14, new BooleanDomain(), 0);
        this.addFiller(composite2, 2);
        Label label = new Label(composite2, 16384);
        label.setText(TextEditorMessages.TextEditorPreferencePage_appearanceOptions);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(1296);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        this.fAppearanceColorList = new org.eclipse.swt.widgets.List(composite3, 2564);
        gridData = new GridData(1810);
        gridData.heightHint = this.fAppearanceColorList.getItemHeight() * 8;
        this.fAppearanceColorList.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(1808));
        label = new Label(composite4, 16384);
        label.setText(TextEditorMessages.TextEditorPreferencePage_color);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.fAppearanceColorEditor = new ColorSelector(composite4);
        Button button2 = this.fAppearanceColorEditor.getButton();
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        button2.setLayoutData((Object)gridData);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = TextEditorDefaultsPreferencePage.this.fAppearanceColorDefault.getSelection();
                TextEditorDefaultsPreferencePage.this.fAppearanceColorEditor.getButton().setEnabled(!bl);
                int n = TextEditorDefaultsPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                if (n == -1) {
                    return;
                }
                String string = TextEditorDefaultsPreferencePage.this.fAppearanceColorListModel[n][2];
                if (string != null) {
                    TextEditorDefaultsPreferencePage.this.fOverlayStore.setValue(string, bl);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        this.fAppearanceColorDefault = new Button(composite4, 32);
        this.fAppearanceColorDefault.setText(TextEditorMessages.TextEditorPreferencePage_systemDefault);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gridData);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(selectionListener);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditorDefaultsPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        button2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = TextEditorDefaultsPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                if (n == -1) {
                    return;
                }
                String string = TextEditorDefaultsPreferencePage.this.fAppearanceColorListModel[n][1];
                PreferenceConverter.setValue((IPreferenceStore)TextEditorDefaultsPreferencePage.this.fOverlayStore, (String)string, (RGB)TextEditorDefaultsPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        Link link2 = new Link(composite2, 0);
        link2.setText(TextEditorMessages.TextEditorPreferencePage_colorsAndFonts_link);
        link2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)TextEditorDefaultsPreferencePage.this.getShell(), (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", null, (Object)"selectCategory:org.eclipse.ui.workbenchMisc");
            }
        });
        GridData gridData2 = new GridData(4, 1, true, false);
        gridData2.widthHint = 150;
        gridData2.horizontalSpan = 2;
        link2.setLayoutData((Object)gridData2);
        this.addFiller(composite2, 2);
        composite2.layout();
        return composite2;
    }

    protected Control createContents(Composite composite) {
        this.initializeDefaultColors();
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control control = this.createAppearancePage(composite);
        this.initialize();
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private void initialize() {
        this.initializeFields();
        int n = 0;
        while (n < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[n][0]);
            ++n;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TextEditorDefaultsPreferencePage.this.fAppearanceColorList != null && !TextEditorDefaultsPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    TextEditorDefaultsPreferencePage.this.fAppearanceColorList.select(0);
                    TextEditorDefaultsPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        for (Initializer initializer : this.fInitializers) {
            initializer.initialize();
        }
        this.fFieldsInitialized = true;
        this.updateStatus(new StatusInfo());
        for (Initializer initializer : this.fMasterSlaveListeners) {
            initializer.widgetSelected(null);
        }
    }

    private void initializeDefaultColors() {
        RGB rGB;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionBackground")) {
            rGB = this.getControl().getDisplay().getSystemColor(26).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rGB);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rGB);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionForeground")) {
            rGB = this.getControl().getDisplay().getSystemColor(27).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rGB);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rGB);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Foreground")) {
            rGB = this.getControl().getDisplay().getSystemColor(25).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Foreground", (RGB)rGB);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rGB);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Background")) {
            rGB = this.getControl().getDisplay().getSystemColor(24).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)rGB);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rGB);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorListSelection();
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private void addFiller(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    private void checkboxControlChanged(Preference preference, Domain domain, Button button) {
        boolean bl = button.getSelection();
        IStatus iStatus = domain.validate(bl);
        if (!iStatus.matches(4)) {
            this.fOverlayStore.setValue(preference.getKey(), bl);
        }
        this.updateStatus(iStatus);
    }

    Button addCheckBox(Composite composite, final Preference preference, final Domain domain, int n) {
        final Button button = new Button(composite, 32);
        button.setText(preference.getName());
        button.setToolTipText(preference.getDescription());
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditorDefaultsPreferencePage.this.checkboxControlChanged(preference, domain, button);
            }
        });
        this.fInitializers.add(this.fInitializerFactory.create(preference, button));
        return button;
    }

    private Button addCheckBoxWithLink(Composite composite, final Preference preference, String string, final Domain domain, int n, final SelectionListener selectionListener) {
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = n;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        final Button button = new Button(composite2, 32);
        button.setFont(JFaceResources.getDialogFont());
        button.setText(preference.getName());
        gridData = new GridData(4, 2, false, false);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TextEditorDefaultsPreferencePage.this.checkboxControlChanged(preference, domain, button);
            }
        });
        gridData = new GridData(4, 2, false, false);
        Link link = new Link(composite2, 0);
        link.setText(string);
        link.setLayoutData((Object)gridData);
        if (selectionListener != null) {
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    selectionListener.widgetSelected(selectionEvent);
                }
            });
        }
        this.fInitializers.add(this.fInitializerFactory.create(preference, button));
        return button;
    }

    Control[] addCombo(Composite composite, final Preference preference, final EnumeratedDomain enumeratedDomain, int n) {
        Label label = new Label(composite, 0);
        label.setText(preference.getName());
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        label.setLayoutData((Object)gridData);
        final Combo combo = new Combo(composite, 12);
        gridData = new GridData(32);
        combo.setLayoutData((Object)gridData);
        combo.setToolTipText(preference.getDescription());
        for (EnumeratedDomain.EnumValue enumValue : enumeratedDomain.fItems) {
            combo.add(enumValue.getLabel());
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = combo.getSelectionIndex();
                EnumeratedDomain.EnumValue enumValue = enumeratedDomain.getValueByIndex(n);
                IStatus iStatus = enumeratedDomain.validate(enumValue);
                if (!iStatus.matches(4)) {
                    TextEditorDefaultsPreferencePage.this.fOverlayStore.setValue(preference.getKey(), enumValue.getIntValue());
                }
                TextEditorDefaultsPreferencePage.this.updateStatus(iStatus);
            }
        });
        this.fInitializers.add(this.fInitializerFactory.create(preference, combo, enumeratedDomain));
        return new Control[]{label, combo};
    }

    Control[] addSpinner(Composite composite, final Preference preference, final EnumeratedDomain enumeratedDomain, int n) {
        Label label = new Label(composite, 0);
        label.setText(preference.getName());
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        label.setLayoutData((Object)gridData);
        final Spinner spinner = new Spinner(composite, 2056);
        gridData = new GridData(32);
        spinner.setLayoutData((Object)gridData);
        spinner.setToolTipText(preference.getDescription());
        spinner.setMinimum(enumeratedDomain.getMinimumValue().getIntValue());
        spinner.setMaximum(enumeratedDomain.getMaximumValue().getIntValue());
        spinner.setIncrement(1);
        spinner.setPageIncrement(4);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = spinner.getSelection();
                EnumeratedDomain.EnumValue enumValue = enumeratedDomain.getValueByInteger(n);
                IStatus iStatus = enumeratedDomain.validate(enumValue);
                if (!iStatus.matches(4)) {
                    TextEditorDefaultsPreferencePage.this.fOverlayStore.setValue(preference.getKey(), enumValue.getIntValue());
                }
                TextEditorDefaultsPreferencePage.this.updateStatus(iStatus);
            }
        });
        this.fInitializers.add(this.fInitializerFactory.create(preference, spinner, enumeratedDomain));
        return new Control[]{label, spinner};
    }

    private Control[] addTextField(Composite composite, final Preference preference, final Domain domain, int n, int n2) {
        Label label = new Label(composite, 0);
        label.setText(preference.getName());
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n2;
        label.setLayoutData((Object)gridData);
        final Text text = new Text(composite, 2052);
        gridData = new GridData(32);
        gridData.widthHint = this.convertWidthInCharsToPixels(n + 1);
        text.setLayoutData((Object)gridData);
        text.setTextLimit(n);
        text.setToolTipText(preference.getDescription());
        if (domain != null) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    String string = text.getText();
                    IStatus iStatus = domain.validate(string);
                    if (!iStatus.matches(4)) {
                        TextEditorDefaultsPreferencePage.this.fOverlayStore.setValue(preference.getKey(), string);
                    }
                    TextEditorDefaultsPreferencePage.this.updateStatus(domain);
                }
            });
        }
        this.fInitializers.add(this.fInitializerFactory.create(preference, text));
        this.fDomains.put(domain, text);
        return new Control[]{label, text};
    }

    private void createDependency(final Button button, Preference preference, final Control[] controlArray) {
        TextEditorDefaultsPreferencePage.indent(controlArray[0]);
        boolean bl = this.fOverlayStore.getBoolean(preference.getKey());
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                int n = 0;
                while (n < controlArray.length) {
                    controlArray[n].setEnabled(bl);
                    ++n;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        button.addSelectionListener(selectionListener);
        this.fMasterSlaveListeners.add(selectionListener);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    public void performHelp() {
        Program.launch((String)"http://www.deltawalker.com/preferences/text-comparisons-editors.jsp");
    }

    void updateStatus(IStatus iStatus) {
        if (!this.fFieldsInitialized) {
            return;
        }
        this.setValid(!iStatus.matches(4));
        this.applyToStatusLine((DialogPage)this, iStatus);
    }

    void updateStatus(Domain domain) {
        if (!this.fFieldsInitialized) {
            return;
        }
        if (this.updateStatusOnError(domain)) {
            return;
        }
        for (Domain domain2 : this.fDomains.keySet()) {
            if (domain2.equals(domain) || !this.updateStatusOnError(domain2)) continue;
            return;
        }
        this.updateStatus(new StatusInfo());
    }

    private boolean updateStatusOnError(Domain domain) {
        IStatus iStatus;
        Text text = (Text)this.fDomains.get(domain);
        if (text.isEnabled() && (iStatus = domain.validate(text.getText())).matches(4)) {
            this.updateStatus(iStatus);
            return true;
        }
        return false;
    }

    public void applyToStatusLine(DialogPage dialogPage, IStatus iStatus) {
        String string = iStatus.getMessage();
        switch (iStatus.getSeverity()) {
            case 0: {
                dialogPage.setMessage(string, 0);
                dialogPage.setErrorMessage(null);
                break;
            }
            case 2: {
                dialogPage.setMessage(string, 2);
                dialogPage.setErrorMessage(null);
                break;
            }
            case 1: {
                dialogPage.setMessage(string, 1);
                dialogPage.setErrorMessage(null);
                break;
            }
            default: {
                if (string.length() == 0) {
                    string = null;
                }
                dialogPage.setMessage(null);
                dialogPage.setErrorMessage(string);
            }
        }
    }

    static class BooleanDomain
    extends Domain {
        BooleanDomain() {
        }

        @Override
        public IStatus validate(Object object) {
            StatusInfo statusInfo = new StatusInfo();
            if (object instanceof String && ((String)object).length() == 0) {
                statusInfo.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return statusInfo;
            }
            try {
                this.parseBoolean(object);
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
            }
            return statusInfo;
        }

        private boolean parseBoolean(Object object) throws NumberFormatException {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                if (Boolean.TRUE.toString().equalsIgnoreCase((String)object)) {
                    return true;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase((String)object)) {
                    return false;
                }
            }
            throw new NumberFormatException(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
        }
    }

    static abstract class Domain {
        Domain() {
        }

        public abstract IStatus validate(Object var1);

        protected int parseInteger(Object object) throws NumberFormatException {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            throw new NumberFormatException(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
        }
    }

    static class EnumeratedDomain
    extends Domain {
        private final List fItems = new ArrayList();
        private final Set fValueSet = new HashSet();

        EnumeratedDomain() {
        }

        public void addValue(EnumValue enumValue) {
            if (this.fValueSet.contains(enumValue)) {
                this.fItems.remove(enumValue);
            }
            this.fItems.add(enumValue);
            this.fValueSet.add(enumValue);
        }

        public int getIndex(EnumValue enumValue) {
            int n = 0;
            for (EnumValue enumValue2 : this.fItems) {
                if (enumValue2.equals(enumValue)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public EnumValue getValueByIndex(int n) {
            if (n >= 0 && this.fItems.size() > n) {
                return (EnumValue)this.fItems.get(n);
            }
            return null;
        }

        public EnumValue getValueByInteger(int n) {
            for (EnumValue enumValue : this.fItems) {
                if (enumValue.getIntValue() != n) continue;
                return enumValue;
            }
            return null;
        }

        public void addValue(int n) {
            this.addValue(new EnumValue(n));
        }

        public void addRange(int n, int n2) {
            while (n <= n2) {
                this.addValue(n++);
            }
        }

        @Override
        public IStatus validate(Object object) {
            StatusInfo statusInfo = new StatusInfo();
            if (object instanceof String && ((String)object).length() == 0) {
                statusInfo.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return statusInfo;
            }
            try {
                EnumValue enumValue = this.parseEnumValue(object);
                if (!this.fValueSet.contains(enumValue)) {
                    statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidRange, new String[]{this.getValueByIndex(0).getLabel(), this.getValueByIndex(this.fItems.size() - 1).getLabel()}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
            }
            return statusInfo;
        }

        private EnumValue parseEnumValue(Object object) {
            if (object instanceof EnumValue) {
                return (EnumValue)object;
            }
            int n = this.parseInteger(object);
            return this.getValueByInteger(n);
        }

        public EnumValue getMinimumValue() {
            return this.getValueByIndex(0);
        }

        public EnumValue getMaximumValue() {
            return this.getValueByIndex(this.fItems.size() - 1);
        }

        public static final class EnumValue {
            private final int fValue;
            private final String fName;

            public EnumValue(int n) {
                this(n, null);
            }

            public EnumValue(int n, String string) {
                this.fValue = n;
                this.fName = string;
            }

            public String getLabel() {
                return this.fName == null ? String.valueOf(this.fValue) : this.fName;
            }

            public int getIntValue() {
                return this.fValue;
            }

            public final int hashCode() {
                return this.getIntValue();
            }

            public boolean equals(Object object) {
                if (object instanceof EnumValue) {
                    return ((EnumValue)object).getIntValue() == this.fValue;
                }
                return false;
            }
        }
    }

    private static abstract class Initializer {
        protected final Preference fPreference;

        protected Initializer(Preference preference) {
            this.fPreference = preference;
        }

        public abstract void initialize();
    }

    public static final class InitializerFactory {
        private final IPreferenceStore fPreferenceStore;

        public InitializerFactory(IPreferenceStore iPreferenceStore) {
            this.fPreferenceStore = iPreferenceStore;
        }

        public Initializer create(Preference preference, Text text) {
            return new TextInitializer(preference, text);
        }

        public Initializer create(Preference preference, Button button) {
            return new CheckboxInitializer(preference, button);
        }

        public Initializer create(Preference preference, Combo combo, EnumeratedDomain enumeratedDomain) {
            return new ComboInitializer(preference, combo, enumeratedDomain);
        }

        public Initializer create(Preference preference, Spinner spinner, EnumeratedDomain enumeratedDomain) {
            return new SpinnerInitializer(preference, spinner, enumeratedDomain);
        }

        private class CheckboxInitializer
        extends Initializer {
            private final Button fControl;

            public CheckboxInitializer(Preference preference, Button button) {
                super(preference);
                this.fControl = button;
            }

            @Override
            public void initialize() {
                boolean bl = InitializerFactory.this.fPreferenceStore.getBoolean(this.fPreference.getKey());
                this.fControl.setSelection(bl);
            }
        }

        private class ComboInitializer
        extends Initializer {
            private final Combo fControl;
            private final EnumeratedDomain fDomain;

            public ComboInitializer(Preference preference, Combo combo, EnumeratedDomain enumeratedDomain) {
                super(preference);
                this.fControl = combo;
                this.fDomain = enumeratedDomain;
            }

            @Override
            public void initialize() {
                int n;
                int n2 = InitializerFactory.this.fPreferenceStore.getInt(this.fPreference.getKey());
                EnumeratedDomain.EnumValue enumValue = this.fDomain.getValueByInteger(n2);
                if (enumValue != null && (n = this.fDomain.getIndex(enumValue)) >= 0) {
                    this.fControl.select(n);
                }
            }
        }

        private class SpinnerInitializer
        extends Initializer {
            private final Spinner fControl;
            private final EnumeratedDomain fDomain;

            public SpinnerInitializer(Preference preference, Spinner spinner, EnumeratedDomain enumeratedDomain) {
                super(preference);
                this.fControl = spinner;
                this.fDomain = enumeratedDomain;
            }

            @Override
            public void initialize() {
                int n = InitializerFactory.this.fPreferenceStore.getInt(this.fPreference.getKey());
                EnumeratedDomain.EnumValue enumValue = this.fDomain.getValueByInteger(n);
                if (enumValue != null) {
                    this.fControl.setSelection(n);
                }
            }
        }

        private class TextInitializer
        extends Initializer {
            private final Text fText;

            public TextInitializer(Preference preference, Text text) {
                super(preference);
                this.fText = text;
            }

            @Override
            public void initialize() {
                String string = InitializerFactory.this.fPreferenceStore.getString(this.fPreference.getKey());
                this.fText.setText(string);
            }
        }
    }

    static class IntegerDomain
    extends Domain {
        private final int fMax;
        private final int fMin;

        public IntegerDomain(int n, int n2) {
            Assert.isLegal((n2 >= n ? 1 : 0) != 0);
            this.fMax = n2;
            this.fMin = n;
        }

        @Override
        public IStatus validate(Object object) {
            StatusInfo statusInfo = new StatusInfo();
            if (object instanceof String && ((String)object).length() == 0) {
                statusInfo.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return statusInfo;
            }
            try {
                int n = this.parseInteger(object);
                if (!this.rangeCheck(n)) {
                    statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(n)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
            }
            return statusInfo;
        }

        protected boolean rangeCheck(int n) {
            return n >= this.fMin && n <= this.fMax;
        }
    }

    private static class Preference {
        private String fKey;
        private String fName;
        private String fDescription;

        public Preference(String string, String string2, String string3) {
            Assert.isNotNull((Object)string);
            Assert.isNotNull((Object)string2);
            this.fKey = string;
            this.fName = string2;
            this.fDescription = string3;
        }

        public final String getKey() {
            return this.fKey;
        }

        public final String getName() {
            return this.fName;
        }

        public final String getDescription() {
            return this.fDescription;
        }
    }

    private static class WhitespaceCharacterPainterOptionsDialog
    extends Dialog {
        private List fDialogInitializers = new ArrayList();
        private OverlayPreferenceStore fDialogOverlayStore;
        private final IPreferenceStore fParentPreferenceStore;
        private InitializerFactory fDialogInitializerFactory;
        private Text errorMessageText;

        protected WhitespaceCharacterPainterOptionsDialog(Shell shell, IPreferenceStore iPreferenceStore) {
            super(shell);
            this.fParentPreferenceStore = iPreferenceStore;
            this.fDialogOverlayStore = this.createDialogOverlayStore();
            this.fDialogInitializerFactory = new InitializerFactory(this.fDialogOverlayStore);
        }

        private OverlayPreferenceStore createDialogOverlayStore() {
            ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingSpaces"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedSpaces"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingSpaces"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingIdeographicSpaces"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedIdeographicSpaces"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingIdeographicSpaces"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLeadingTabs"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showEnclosedTabs"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showTrailingTabs"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showCarriageReturn"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showLineFeed"));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "whitespaceCharacterAlphaValue"));
            OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
            arrayList.toArray(overlayKeyArray);
            return new OverlayPreferenceStore(this.fParentPreferenceStore, overlayKeyArray);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_showWhitespaceCharactersDialogTitle);
        }

        protected Control createContents(Composite composite) {
            Control control = super.createContents(composite);
            Dialog.applyDialogFont((Control)control);
            this.fDialogOverlayStore.load();
            this.fDialogOverlayStore.start();
            this.initializeShowWhitespaceCharactersPreferences();
            return control;
        }

        private void initializeShowWhitespaceCharactersPreferences() {
            for (Initializer initializer : this.fDialogInitializers) {
                initializer.initialize();
            }
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Label label = new Label(composite2, 0);
            label.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_configureWhitespaceCharacterPainterProperties);
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            Composite composite3 = new Composite(composite2, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.makeColumnsEqualWidth = true;
            composite3.setLayout((Layout)gridLayout);
            Label label2 = new Label(composite3, 0);
            label2.setText("");
            label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label2 = new Label(composite3, 0);
            label2.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_leading);
            label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label2 = new Label(composite3, 0);
            label2.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_enclosed);
            label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label2 = new Label(composite3, 0);
            label2.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_trailing);
            label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label2 = new Label(composite3, 0);
            label2.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_space);
            label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Preference preference = new Preference("showLeadingSpaces", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            preference = new Preference("showEnclosedSpaces", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            preference = new Preference("showTrailingSpaces", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            label2 = new Label(composite3, 0);
            label2.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_ideographicSpace);
            label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            preference = new Preference("showLeadingIdeographicSpaces", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            preference = new Preference("showEnclosedIdeographicSpaces", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            preference = new Preference("showTrailingIdeographicSpaces", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            label2 = new Label(composite3, 0);
            label2.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_tab);
            label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            preference = new Preference("showLeadingTabs", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            preference = new Preference("showEnclosedTabs", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            preference = new Preference("showTrailingTabs", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            label2 = new Label(composite3, 0);
            label2.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_carriageReturn);
            label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Button button = new Button(composite3, 32);
            button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            button.setEnabled(false);
            button = new Button(composite3, 32);
            button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            button.setEnabled(false);
            preference = new Preference("showCarriageReturn", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            label2 = new Label(composite3, 0);
            label2.setText(TextEditorMessages.TextEditorDefaultsPreferencePage_lineFeed);
            label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            button = new Button(composite3, 32);
            button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            button.setEnabled(false);
            button = new Button(composite3, 32);
            button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            button.setEnabled(false);
            preference = new Preference("showLineFeed", "", null);
            this.addCheckBox(composite3, preference, new BooleanDomain(), 0);
            Composite composite4 = new Composite(composite2, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 0;
            gridLayout.makeColumnsEqualWidth = false;
            composite4.setLayout((Layout)gridLayout);
            preference = new Preference("whitespaceCharacterAlphaValue", TextEditorMessages.TextEditorDefaultsPreferencePage_transparencyLevel, null);
            this.addTextField(composite4, preference, new IntegerDomain(0, 255), 5, 0);
            this.errorMessageText = new Text(composite2, 72);
            this.errorMessageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
            this.setErrorMessage(null);
            return composite2;
        }

        public void setErrorMessage(String string) {
            if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
                this.errorMessageText.setText(string == null ? "  " : string);
                boolean bl = string != null && StringConverter.removeWhiteSpaces((String)string).length() > 0;
                this.errorMessageText.setEnabled(bl);
                this.errorMessageText.setVisible(bl);
                this.errorMessageText.getParent().update();
                Button button = this.getButton(0);
                if (button != null) {
                    button.setEnabled(string == null);
                }
            }
        }

        private Button addCheckBox(Composite composite, final Preference preference, final Domain domain, int n) {
            final Button button = new Button(composite, 32);
            button.setToolTipText(preference.getDescription());
            GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
            gridData.horizontalIndent = n;
            button.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = button.getSelection();
                    IStatus iStatus = domain.validate(bl);
                    if (!iStatus.matches(4)) {
                        WhitespaceCharacterPainterOptionsDialog.this.fDialogOverlayStore.setValue(preference.getKey(), bl);
                    }
                }
            });
            this.fDialogInitializers.add(this.fDialogInitializerFactory.create(preference, button));
            return button;
        }

        private Control[] addTextField(Composite composite, final Preference preference, final Domain domain, int n, int n2) {
            Label label = new Label(composite, 0);
            label.setText(preference.getName());
            GridData gridData = new GridData(1, 0x1000000, false, false);
            gridData.horizontalIndent = n2;
            label.setLayoutData((Object)gridData);
            final Text text = new Text(composite, 2052);
            gridData = new GridData(1, 0x1000000, false, false);
            gridData.widthHint = this.convertWidthInCharsToPixels(n + 1);
            text.setLayoutData((Object)gridData);
            text.setTextLimit(n);
            text.setToolTipText(preference.getDescription());
            if (domain != null) {
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent modifyEvent) {
                        String string = text.getText();
                        IStatus iStatus = domain.validate(string);
                        if (!iStatus.matches(4)) {
                            WhitespaceCharacterPainterOptionsDialog.this.fDialogOverlayStore.setValue(preference.getKey(), string);
                            WhitespaceCharacterPainterOptionsDialog.this.setErrorMessage(null);
                        } else {
                            WhitespaceCharacterPainterOptionsDialog.this.setErrorMessage(NLSUtility.format(TextEditorMessages.TextEditorDefaultsPreferencePage_showWhitespaceCharactersDialogInvalidInput, string));
                        }
                    }
                });
            }
            this.fDialogInitializers.add(this.fDialogInitializerFactory.create(preference, text));
            return new Control[]{label, text};
        }

        protected void okPressed() {
            super.okPressed();
            this.fDialogOverlayStore.propagate();
        }
    }
}

