/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

class StatusInfo
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;

    public StatusInfo() {
        this(0, null);
    }

    public StatusInfo(int n, String string) {
        this.fStatusMessage = string;
        this.fSeverity = n;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public void setError(String string) {
        Assert.isNotNull((Object)string);
        this.fStatusMessage = string;
        this.fSeverity = 4;
    }

    public void setWarning(String string) {
        Assert.isNotNull((Object)string);
        this.fStatusMessage = string;
        this.fSeverity = 2;
    }

    public void setInfo(String string) {
        Assert.isNotNull((Object)string);
        this.fStatusMessage = string;
        this.fSeverity = 1;
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public boolean matches(int n) {
        return (this.fSeverity & n) != 0;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getPlugin() {
        return "org.eclipse.ui.editors";
    }

    public Throwable getException() {
        return null;
    }

    public int getCode() {
        return this.fSeverity;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }
}

