/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.spelling.IPreferenceStatusMonitor;
import org.eclipse.ui.texteditor.spelling.ISpellingPreferenceBlock;
import org.eclipse.ui.texteditor.spelling.SpellingEngineDescriptor;

class SpellingConfigurationBlock
implements IPreferenceConfigurationBlock {
    private final OverlayPreferenceStore fStore;
    private Combo fProviderCombo;
    private Button fEnablementCheckbox;
    private ComboViewer fProviderViewer;
    private Composite fComboGroup;
    private Composite fGroup;
    private StackLayout fStackLayout;
    private final Map fProviderDescriptors;
    private final Map fProviderPreferences;
    private final Map fProviderControls;
    private ForwardingStatusMonitor fStatusMonitor;
    private ISpellingPreferenceBlock fCurrentBlock;

    public SpellingConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore, IPreferenceStatusMonitor iPreferenceStatusMonitor) {
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fStore = overlayPreferenceStore;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fStatusMonitor = new ForwardingStatusMonitor(iPreferenceStatusMonitor);
        this.fProviderDescriptors = this.createListModel();
        this.fProviderPreferences = new HashMap();
        this.fProviderControls = new HashMap();
    }

    private Map createListModel() {
        SpellingEngineDescriptor[] spellingEngineDescriptorArray = EditorsUI.getSpellingService().getSpellingEngineDescriptors();
        HashMap<String, SpellingEngineDescriptor> hashMap = new HashMap<String, SpellingEngineDescriptor>();
        int n = 0;
        while (n < spellingEngineDescriptorArray.length) {
            hashMap.put(spellingEngineDescriptorArray[n].getId(), spellingEngineDescriptorArray[n]);
            ++n;
        }
        return hashMap;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spellingEnabled"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "spellingEngine"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    @Override
    public Control createControl(Composite composite) {
        GridLayout gridLayout;
        Composite composite2;
        Composite composite3 = new Composite(composite, 0);
        GridData gridData = new GridData(80);
        composite3.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        PixelConverter pixelConverter = new PixelConverter((Control)composite3);
        gridLayout2.verticalSpacing = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        composite3.setLayout((Layout)gridLayout2);
        if (EditorsUI.getSpellingService().getSpellingEngineDescriptors().length == 0) {
            Label label = new Label(composite3, 0);
            label.setText(TextEditorMessages.SpellingConfigurationBlock_error_not_installed);
            return composite3;
        }
        this.fEnablementCheckbox = new Button(composite3, 32);
        this.fEnablementCheckbox.setText(TextEditorMessages.SpellingConfigurationBlock_enable);
        gridData = new GridData(34);
        this.fEnablementCheckbox.setLayoutData((Object)gridData);
        this.fEnablementCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = SpellingConfigurationBlock.this.fEnablementCheckbox.getSelection();
                SpellingConfigurationBlock.this.fStore.setValue("spellingEnabled", bl);
                SpellingConfigurationBlock.this.updateCheckboxDependencies();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label = new Label(composite3, 0x1000000);
        gridData = new GridData(770);
        label.setLayoutData((Object)gridData);
        if (this.fProviderDescriptors.size() > 1) {
            this.fComboGroup = new Composite(composite3, 0);
            gridData = new GridData(770);
            gridData.horizontalIndent = 10;
            this.fComboGroup.setLayoutData((Object)gridData);
            composite2 = new GridLayout(2, false);
            composite2.marginWidth = 0;
            this.fComboGroup.setLayout((Layout)composite2);
            gridLayout = new Label(this.fComboGroup, 0x1000000);
            gridData = new GridData(36);
            gridLayout.setLayoutData((Object)gridData);
            gridLayout.setText(TextEditorMessages.SpellingConfigurationBlock_combo_caption);
            label = new Label(composite3, 0x1000000);
            gridData = new GridData(770);
            label.setLayoutData((Object)gridData);
            this.fProviderCombo = new Combo(this.fComboGroup, 12);
            gridData = new GridData(132);
            this.fProviderCombo.setLayoutData((Object)gridData);
            this.fProviderViewer = this.createProviderViewer();
        }
        composite2 = new Composite(composite3, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fGroup = new Composite(composite2, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 10;
        this.fGroup.setLayoutData((Object)gridData);
        this.fStackLayout = new StackLayout();
        this.fGroup.setLayout((Layout)this.fStackLayout);
        return composite3;
    }

    @Override
    public void applyData(Object object) {
    }

    private ComboViewer createProviderViewer() {
        final ComboViewer comboViewer = new ComboViewer(this.fProviderCombo);
        comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return SpellingConfigurationBlock.this.fProviderDescriptors.values().toArray();
            }
        });
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                return null;
            }

            public String getText(Object object) {
                return ((SpellingEngineDescriptor)object).getLabel();
            }
        });
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                if (iStructuredSelection.isEmpty()) {
                    return;
                }
                if (SpellingConfigurationBlock.this.fCurrentBlock != null && SpellingConfigurationBlock.this.fStatusMonitor.getStatus() != null && SpellingConfigurationBlock.this.fStatusMonitor.getStatus().matches(4)) {
                    if (this.isPerformRevert()) {
                        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                            public void run() throws Exception {
                                SpellingConfigurationBlock.this.fCurrentBlock.performRevert();
                            }

                            public void handleException(Throwable throwable) {
                            }
                        };
                        SafeRunner.run((ISafeRunnable)iSafeRunnable);
                    } else {
                        this.revertSelection();
                        return;
                    }
                }
                SpellingConfigurationBlock.this.fStore.setValue("spellingEngine", ((SpellingEngineDescriptor)iStructuredSelection.getFirstElement()).getId());
                SpellingConfigurationBlock.this.updateListDependencies();
            }

            private boolean isPerformRevert() {
                Shell shell = comboViewer.getControl().getShell();
                MessageDialog messageDialog = new MessageDialog(shell, TextEditorMessages.SpellingConfigurationBlock_error_title, null, TextEditorMessages.SpellingConfigurationBlock_error_message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                return messageDialog.open() == 0;
            }

            private void revertSelection() {
                try {
                    comboViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                    SpellingEngineDescriptor spellingEngineDescriptor = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)SpellingConfigurationBlock.this.fStore);
                    if (spellingEngineDescriptor != null) {
                        comboViewer.setSelection((ISelection)new StructuredSelection((Object)spellingEngineDescriptor), true);
                    }
                }
                finally {
                    comboViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        });
        comboViewer.setInput((Object)this.fProviderDescriptors);
        comboViewer.refresh();
        return comboViewer;
    }

    private void updateCheckboxDependencies() {
        SpellingEngineDescriptor spellingEngineDescriptor;
        String string;
        ISpellingPreferenceBlock iSpellingPreferenceBlock;
        final boolean bl = this.fEnablementCheckbox.getSelection();
        if (this.fComboGroup != null) {
            this.setEnabled((Control)this.fComboGroup, bl);
        }
        if ((iSpellingPreferenceBlock = (ISpellingPreferenceBlock)this.fProviderPreferences.get(string = (spellingEngineDescriptor = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)this.fStore)) != null ? spellingEngineDescriptor.getId() : "")) != null) {
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void run() throws Exception {
                    iSpellingPreferenceBlock.setEnabled(bl);
                }

                public void handleException(Throwable throwable) {
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
        }
    }

    private void setEnabled(Control control, boolean bl) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.setEnabled(controlArray[n], bl);
                ++n;
            }
        }
        control.setEnabled(bl);
    }

    void updateListDependencies() {
        Object object;
        String string;
        String string2;
        SpellingEngineDescriptor spellingEngineDescriptor = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)this.fStore);
        if (spellingEngineDescriptor == null) {
            string2 = "";
            string = TextEditorMessages.SpellingConfigurationBlock_error_not_exist;
            EditorsPlugin.log((IStatus)new Status(2, "org.eclipse.ui.editors", 0, string, null));
            this.fCurrentBlock = new ErrorPreferences(string);
        } else {
            string2 = spellingEngineDescriptor.getId();
            this.fCurrentBlock = (ISpellingPreferenceBlock)this.fProviderPreferences.get(string2);
            if (this.fCurrentBlock == null) {
                try {
                    this.fCurrentBlock = spellingEngineDescriptor.createPreferences();
                    this.fProviderPreferences.put(string2, this.fCurrentBlock);
                }
                catch (CoreException coreException) {
                    EditorsPlugin.log(coreException);
                    this.fCurrentBlock = new ErrorPreferences(coreException.getLocalizedMessage());
                }
            }
        }
        string = (Control)this.fProviderControls.get(string2);
        if (string == null) {
            object = new Control[1];
            ISafeRunnable iSafeRunnable = new ISafeRunnable((Control[])object){
                private final /* synthetic */ Control[] val$result;
                {
                    this.val$result = controlArray;
                }

                public void run() throws Exception {
                    this.val$result[0] = SpellingConfigurationBlock.this.fCurrentBlock.createControl(SpellingConfigurationBlock.this.fGroup);
                }

                public void handleException(Throwable throwable) {
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
            string = object[0];
            if (string == null) {
                String string3 = TextEditorMessages.SpellingConfigurationBlock_info_no_preferences;
                EditorsPlugin.log((IStatus)new Status(2, "org.eclipse.ui.editors", 0, string3, null));
                string = new ErrorPreferences(string3).createControl(this.fGroup);
            } else {
                this.fProviderControls.put(string2, string);
            }
        }
        Dialog.applyDialogFont((Control)string);
        this.fStackLayout.topControl = string;
        string.pack();
        this.fGroup.layout();
        this.fGroup.getParent().layout();
        this.fStatusMonitor.statusChanged(new StatusInfo());
        object = new ISafeRunnable(){

            public void run() throws Exception {
                SpellingConfigurationBlock.this.fCurrentBlock.initialize((IPreferenceStatusMonitor)SpellingConfigurationBlock.this.fStatusMonitor);
            }

            public void handleException(Throwable throwable) {
            }
        };
        SafeRunner.run((ISafeRunnable)object);
    }

    @Override
    public void initialize() {
        this.restoreFromPreferences();
    }

    @Override
    public boolean canPerformOk() {
        SpellingEngineDescriptor spellingEngineDescriptor = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)this.fStore);
        String string = spellingEngineDescriptor != null ? spellingEngineDescriptor.getId() : "";
        final ISpellingPreferenceBlock iSpellingPreferenceBlock = (ISpellingPreferenceBlock)this.fProviderPreferences.get(string);
        if (iSpellingPreferenceBlock == null) {
            return true;
        }
        final Boolean[] booleanArray = new Boolean[]{Boolean.TRUE};
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

            public void run() throws Exception {
                booleanArray[0] = iSpellingPreferenceBlock.canPerformOk();
            }

            public void handleException(Throwable throwable) {
            }
        };
        SafeRunner.run((ISafeRunnable)iSafeRunnable);
        return booleanArray[0];
    }

    @Override
    public void performOk() {
        for (final ISpellingPreferenceBlock iSpellingPreferenceBlock : this.fProviderPreferences.values()) {
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void run() throws Exception {
                    iSpellingPreferenceBlock.performOk();
                }

                public void handleException(Throwable throwable) {
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
        }
    }

    @Override
    public void performDefaults() {
        this.restoreFromPreferences();
        for (final ISpellingPreferenceBlock iSpellingPreferenceBlock : this.fProviderPreferences.values()) {
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void run() throws Exception {
                    iSpellingPreferenceBlock.performDefaults();
                }

                public void handleException(Throwable throwable) {
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
        }
    }

    @Override
    public void dispose() {
        for (final ISpellingPreferenceBlock iSpellingPreferenceBlock : this.fProviderPreferences.values()) {
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void run() throws Exception {
                    iSpellingPreferenceBlock.dispose();
                }

                public void handleException(Throwable throwable) {
                }
            };
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
        }
    }

    private void restoreFromPreferences() {
        if (this.fEnablementCheckbox == null) {
            return;
        }
        boolean bl = this.fStore.getBoolean("spellingEnabled");
        this.fEnablementCheckbox.setSelection(bl);
        if (this.fProviderViewer == null) {
            this.updateListDependencies();
        } else {
            SpellingEngineDescriptor spellingEngineDescriptor = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)this.fStore);
            if (spellingEngineDescriptor != null) {
                this.fProviderViewer.setSelection((ISelection)new StructuredSelection((Object)spellingEngineDescriptor), true);
            }
        }
        this.updateCheckboxDependencies();
    }

    private static class ErrorPreferences
    implements ISpellingPreferenceBlock {
        private String fMessage;
        private Label fLabel;

        protected ErrorPreferences(String string) {
            this.fMessage = string;
        }

        public Control createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new FillLayout(512));
            this.fLabel = new Label(composite2, 0x1000000);
            this.fLabel.setText(this.fMessage);
            return composite2;
        }

        public void initialize(IPreferenceStatusMonitor iPreferenceStatusMonitor) {
        }

        public boolean canPerformOk() {
            return true;
        }

        public void performOk() {
        }

        public void performDefaults() {
        }

        public void performRevert() {
        }

        public void dispose() {
        }

        public void setEnabled(boolean bl) {
            this.fLabel.setEnabled(bl);
        }
    }

    private static class ForwardingStatusMonitor
    implements IPreferenceStatusMonitor {
        private IPreferenceStatusMonitor fForwardedMonitor;
        private IStatus fStatus;

        public ForwardingStatusMonitor(IPreferenceStatusMonitor iPreferenceStatusMonitor) {
            this.fForwardedMonitor = iPreferenceStatusMonitor;
        }

        public void statusChanged(IStatus iStatus) {
            this.fStatus = iStatus;
            this.fForwardedMonitor.statusChanged(iStatus);
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }
}

