/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TypeFilteringDialog;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.SelectResourcesBlock;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class SelectResourcesDialog
extends Dialog {
    private SelectResourcesBlock fResourceGroup;
    private List fAcceptedFileTypes = new ArrayList();
    private IResource[] fInput;
    private String fTitle;
    private String fInstruction;
    private Label fCountIndication;
    private IFilter fAcceptableLocationsFilter;

    public SelectResourcesDialog(Shell shell, String string, String string2, IFilter iFilter) {
        super(shell);
        this.fTitle = string;
        this.fInstruction = string2;
        this.fAcceptableLocationsFilter = iFilter;
    }

    protected boolean isResizable() {
        return true;
    }

    public void setInput(IResource[] iResourceArray) {
        this.fInput = iResourceArray;
    }

    public IResource[] getSelectedResources() {
        List list = this.fResourceGroup.getAllCheckedListItems();
        return list.toArray(new IResource[list.size()]);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Label label = new Label(composite2, 16384);
        label.setText(this.fInstruction);
        label.setLayoutData((Object)new GridData(768));
        this.fResourceGroup = new SelectResourcesBlock(composite2, ResourcesPlugin.getWorkspace().getRoot(), this.getResourceProvider(6), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, this.useHeightHint(composite));
        this.fResourceGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                SelectResourcesDialog.this.updateSelectionCount();
            }
        });
        this.fCountIndication = new Label(composite2, 16384);
        this.fCountIndication.setLayoutData((Object)new GridData(768));
        this.createSelectionButtonGroup(composite2);
        this.setInitialSelection();
        return composite2;
    }

    private boolean useHeightHint(Composite composite) {
        int n = composite.getDisplay().getClientArea().height;
        int n2 = composite.getFont().getFontData()[0].getHeight();
        return n / n2 > 50;
    }

    private ITreeContentProvider getResourceProvider(final int n) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof IWorkspaceRoot) {
                    HashSet<IProject> hashSet = new HashSet<IProject>();
                    int n2 = 0;
                    while (n2 < SelectResourcesDialog.this.fInput.length) {
                        IProject iProject = SelectResourcesDialog.this.fInput[n2].getProject();
                        if ((iProject.getType() & n) > 0) {
                            hashSet.add(iProject);
                        }
                        ++n2;
                    }
                    return hashSet.toArray();
                }
                if (object instanceof IContainer) {
                    IResource[] iResourceArray = null;
                    try {
                        iResourceArray = ((IContainer)object).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> arrayList = new ArrayList<IResource>();
                    int n3 = 0;
                    while (n3 < iResourceArray.length) {
                        if ((iResourceArray[n3].getType() & n) > 0 && (n != 1 || SelectResourcesDialog.this.fAcceptableLocationsFilter == null || SelectResourcesDialog.this.fAcceptableLocationsFilter.accept(iResourceArray[n3]))) {
                            arrayList.add(iResourceArray[n3]);
                        }
                        ++n3;
                    }
                    return arrayList.toArray();
                }
                if (object instanceof ArrayList) {
                    return ((ArrayList)object).toArray();
                }
                return new Object[0];
            }
        };
    }

    protected final void createSelectionButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        Button button = this.createButton(composite2, 18, TextEditorMessages.SelectResourcesDialog_selectAll, false);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectResourcesDialog.this.fResourceGroup.setAllSelections(true);
                SelectResourcesDialog.this.updateSelectionCount();
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        button.setFont(font);
        this.setButtonLayoutData(button);
        Button button2 = this.createButton(composite2, 19, TextEditorMessages.SelectResourcesDialog_deselectAll, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectResourcesDialog.this.fResourceGroup.setAllSelections(false);
                SelectResourcesDialog.this.updateSelectionCount();
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
        button2.setFont(font);
        this.setButtonLayoutData(button2);
        Button button3 = this.createButton(composite2, 20, TextEditorMessages.SelectResourcesDialog_filterSelection, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectResourcesDialog.this.handleSelectFileTypes();
            }
        };
        button3.addSelectionListener((SelectionListener)selectionAdapter);
        button3.setFont(font);
        this.setButtonLayoutData(button3);
    }

    protected void handleSelectFileTypes() {
        Object[] objectArray = this.queryFileTypes();
        if (objectArray != null) {
            this.fAcceptedFileTypes = Arrays.asList(objectArray);
            this.filterSelection();
        }
    }

    protected Object[] queryFileTypes() {
        TypeFilteringDialog typeFilteringDialog = new TypeFilteringDialog(this.getShell(), (Collection)this.fAcceptedFileTypes);
        typeFilteringDialog.open();
        return typeFilteringDialog.getResult();
    }

    private void filterSelection() {
        final IFilter iFilter = new IFilter(){

            @Override
            public boolean accept(IResource iResource) {
                return SelectResourcesDialog.this.hasAcceptedFileType(iResource);
            }
        };
        List list = this.fResourceGroup.getAllWhiteCheckedItems();
        final IResource[] iResourceArray = list.toArray(new IResource[list.size()]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SelectResourcesDialog.this.setSelection(iResourceArray, iFilter);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
    }

    protected boolean hasAcceptedFileType(IResource iResource) {
        if (this.fAcceptedFileTypes == null) {
            return true;
        }
        String string = iResource.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        Iterator iterator = this.fAcceptedFileTypes.iterator();
        while (iterator.hasNext()) {
            if (!string2.equalsIgnoreCase((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    protected void setInitialSelection() {
        this.setSelection(this.fInput, this.fAcceptableLocationsFilter);
        this.selectAndReveal(this.fInput[0]);
    }

    protected void setSelection(IResource[] iResourceArray, IFilter iFilter) {
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if ((iResource.getType() & 1) > 0) {
                if (iFilter.accept(iResource)) {
                    List list = null;
                    IContainer iContainer = iResource.getParent();
                    list = hashtable.containsKey(iContainer) ? (List)hashtable.get(iContainer) : new ArrayList();
                    list.add(iResource);
                    hashtable.put(iContainer, list);
                }
            } else {
                this.setSelection(hashtable, (IContainer)iResource, iFilter);
            }
            ++n;
        }
        this.fResourceGroup.updateSelections(hashtable);
        this.updateSelectionCount();
    }

    private void setSelection(Map map, IContainer iContainer, IFilter iFilter) {
        try {
            IResource[] iResourceArray = iContainer.members();
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            int n = 0;
            while (n < iResourceArray.length) {
                IResource iResource = iResourceArray[n];
                if ((iResource.getType() & 1) > 0) {
                    if (iFilter.accept(iResource)) {
                        arrayList.add(iResource);
                    }
                } else {
                    this.setSelection(map, (IContainer)iResource, iFilter);
                }
                ++n;
            }
            if (!arrayList.isEmpty()) {
                map.put(iContainer, arrayList);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private void selectAndReveal(IResource iResource) {
        IContainer iContainer = null;
        iContainer = (1 & iResource.getType()) > 0 ? iResource.getParent() : (IContainer)iResource;
        this.fResourceGroup.selectAndReveal(iContainer);
    }

    private void updateSelectionCount() {
        List list = this.fResourceGroup.getAllCheckedListItems();
        int n = list == null ? 0 : list.size();
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 0: {
                stringBuffer.append(TextEditorMessages.SelectResourcesDialog_noFilesSelected);
                break;
            }
            case 1: {
                stringBuffer.append(TextEditorMessages.SelectResourcesDialog_oneFileSelected);
                break;
            }
            default: {
                stringBuffer.append(NLSUtility.format(TextEditorMessages.SelectResourcesDialog_nFilesSelected, new Integer(n)));
            }
        }
        this.fCountIndication.setText(stringBuffer.toString());
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(n > 0);
        }
    }

    static interface IFilter {
        public boolean accept(IResource var1);
    }
}

