/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

class SelectResourcesBlock
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private Collection expandedTreeNodes = new HashSet();
    private Map checkedStateStore = new HashMap(9);
    private Collection whiteCheckedTreeItems = new HashSet();
    private ListenerList listeners = new ListenerList(1);
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;
    private static int PREFERRED_HEIGHT = 150;

    public SelectResourcesBlock(Composite composite, Object object, ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider, IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider2, int n, boolean bl) {
        this.root = object;
        this.treeContentProvider = iTreeContentProvider;
        this.listContentProvider = iStructuredContentProvider;
        this.treeLabelProvider = iLabelProvider;
        this.listLabelProvider = iLabelProvider2;
        this.createContents(composite, n, bl);
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.listeners.add((Object)iCheckStateListener);
    }

    private void checkNewTreeElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            boolean bl = this.checkedStateStore.containsKey(object);
            this.treeViewer.setChecked(object, bl);
            this.treeViewer.setGrayed(object, bl && !this.whiteCheckedTreeItems.contains(object));
            ++n;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (checkStateChangedEvent.getCheckable().equals(SelectResourcesBlock.this.treeViewer)) {
                    SelectResourcesBlock.this.treeItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked());
                } else {
                    SelectResourcesBlock.this.listItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked(), true);
                }
                SelectResourcesBlock.this.notifyCheckStateChangeListeners(checkStateChangedEvent);
            }
        });
    }

    private void createContents(Composite composite, int n, boolean bl) {
        Composite composite2 = new Composite(composite, n);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite2, bl);
        this.createListViewer(composite2, bl);
        this.initialize();
    }

    private void createListViewer(Composite composite, boolean bl) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gridData = new GridData(1808);
        if (bl) {
            gridData.heightHint = PREFERRED_HEIGHT;
        }
        this.listViewer.getTable().setLayoutData((Object)gridData);
        this.listViewer.getTable().setFont(composite.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    private void createTreeViewer(Composite composite, boolean bl) {
        Tree tree = new Tree(composite, 2080);
        GridData gridData = new GridData(1808);
        if (bl) {
            gridData.heightHint = PREFERRED_HEIGHT;
        }
        tree.setLayoutData((Object)gridData);
        tree.setFont(composite.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private boolean determineShouldBeAtLeastGrayChecked(Object object) {
        List list = (List)this.checkedStateStore.get(object);
        if (list != null && !list.isEmpty()) {
            return true;
        }
        if (this.expandedTreeNodes.contains(object)) {
            Object[] objectArray = this.treeContentProvider.getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                if (this.checkedStateStore.containsKey(objectArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void expandTreeElement(final Object object) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SelectResourcesBlock.this.expandedTreeNodes.contains(object)) {
                    SelectResourcesBlock.this.checkNewTreeElements(SelectResourcesBlock.this.treeContentProvider.getChildren(object));
                } else {
                    SelectResourcesBlock.this.expandedTreeNodes.add(object);
                    if (SelectResourcesBlock.this.whiteCheckedTreeItems.contains(object)) {
                        Object[] objectArray = SelectResourcesBlock.this.treeContentProvider.getChildren(object);
                        int n = 0;
                        while (n < objectArray.length) {
                            if (!SelectResourcesBlock.this.whiteCheckedTreeItems.contains(objectArray[n])) {
                                Object object2 = objectArray[n];
                                SelectResourcesBlock.this.setWhiteChecked(object2, true);
                                SelectResourcesBlock.this.treeViewer.setChecked(object2, true);
                                SelectResourcesBlock.this.checkedStateStore.put(object2, new ArrayList());
                            }
                            ++n;
                        }
                        SelectResourcesBlock.this.setListForWhiteSelection(object);
                    }
                }
            }
        });
    }

    private void findAllSelectedListElements(Object object, String string, boolean bl, IElementFilter iElementFilter) throws InterruptedException {
        String string2 = null;
        if (bl) {
            iElementFilter.filterElements(this.listContentProvider.getElements(object));
        } else if (this.checkedStateStore.containsKey(object)) {
            iElementFilter.filterElements((Collection)this.checkedStateStore.get(object));
        }
        Object[] objectArray = this.treeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (bl) {
                this.findAllSelectedListElements(object2, string2, true, iElementFilter);
            } else if (this.checkedStateStore.containsKey(object2)) {
                this.findAllSelectedListElements(object2, string2, this.whiteCheckedTreeItems.contains(object2), iElementFilter);
            }
            ++n;
        }
    }

    private void findAllWhiteCheckedItems(Object object, Collection collection) {
        if (this.whiteCheckedTreeItems.contains(object)) {
            collection.add(object);
        } else {
            Collection collection2 = (Collection)this.checkedStateStore.get(object);
            if (collection2 == null) {
                return;
            }
            collection.addAll(collection2);
            Object[] objectArray = this.treeContentProvider.getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                this.findAllWhiteCheckedItems(objectArray[n], collection);
                ++n;
            }
        }
    }

    private void getAllCheckedListItems(IElementFilter iElementFilter) throws InterruptedException {
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = 0;
        while (n < objectArray.length) {
            this.findAllSelectedListElements(objectArray[n], null, this.whiteCheckedTreeItems.contains(objectArray[n]), iElementFilter);
            ++n;
        }
    }

    public List getAllCheckedListItems() {
        final ArrayList arrayList = new ArrayList();
        IElementFilter iElementFilter = new IElementFilter(){

            @Override
            public void filterElements(Collection collection) throws InterruptedException {
                arrayList.addAll(collection);
            }

            @Override
            public void filterElements(Object[] objectArray) throws InterruptedException {
                int n = 0;
                while (n < objectArray.length) {
                    arrayList.add(objectArray[n]);
                    ++n;
                }
            }
        };
        try {
            this.getAllCheckedListItems(iElementFilter);
        }
        catch (InterruptedException interruptedException) {
            return new ArrayList();
        }
        return arrayList;
    }

    public List getAllWhiteCheckedItems() {
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = this.treeContentProvider.getChildren(this.root);
        int n = 0;
        while (n < objectArray.length) {
            this.findAllWhiteCheckedItems(objectArray[n], arrayList);
            ++n;
        }
        return arrayList;
    }

    private void grayCheckHierarchy(Object object) {
        this.expandTreeElement(object);
        if (this.checkedStateStore.containsKey(object)) {
            return;
        }
        this.checkedStateStore.put(object, new ArrayList());
        Object object2 = this.treeContentProvider.getParent(object);
        if (object2 != null) {
            this.grayCheckHierarchy(object2);
        }
    }

    private void grayUpdateHierarchy(Object object) {
        Object object2;
        boolean bl = this.determineShouldBeAtLeastGrayChecked(object);
        this.treeViewer.setGrayChecked(object, bl);
        if (this.whiteCheckedTreeItems.contains(object)) {
            this.whiteCheckedTreeItems.remove(object);
        }
        if ((object2 = this.treeContentProvider.getParent(object)) != null) {
            this.grayUpdateHierarchy(object2);
        }
    }

    public void selectAndReveal(Object object) {
        this.treeViewer.reveal(object);
        StructuredSelection structuredSelection = new StructuredSelection(object);
        this.treeViewer.setSelection((ISelection)structuredSelection);
    }

    private void initialize() {
        this.treeViewer.setInput(this.root);
        this.expandedTreeNodes = new ArrayList();
        this.expandedTreeNodes.add(this.root);
    }

    private void listItemChecked(Object object, boolean bl, boolean bl2) {
        List list = (List)this.checkedStateStore.get(this.currentTreeSelection);
        if (!this.expandedTreeNodes.contains(this.currentTreeSelection)) {
            this.expandTreeElement(this.currentTreeSelection);
        }
        if (bl) {
            if (list == null) {
                this.grayCheckHierarchy(this.currentTreeSelection);
                list = (List)this.checkedStateStore.get(this.currentTreeSelection);
            }
            list.add(object);
        } else {
            list.remove(object);
            if (list.isEmpty()) {
                this.ungrayCheckHierarchy(this.currentTreeSelection);
            }
        }
        if (list.size() > 0) {
            this.checkedStateStore.put(this.currentTreeSelection, list);
        }
        if (bl2) {
            this.grayUpdateHierarchy(this.currentTreeSelection);
        }
    }

    private void notifyCheckStateChangeListeners(final CheckStateChangedEvent checkStateChangedEvent) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ICheckStateListener iCheckStateListener = (ICheckStateListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iCheckStateListener.checkStateChanged(checkStateChangedEvent);
                }
            });
            ++n;
        }
    }

    private void populateListViewer(final Object object) {
        this.listViewer.setInput(object);
        if (!this.expandedTreeNodes.contains(object) && this.whiteCheckedTreeItems.contains(object)) {
            BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    SelectResourcesBlock.this.setListForWhiteSelection(object);
                    SelectResourcesBlock.this.listViewer.setAllChecked(true);
                }
            });
        } else {
            List list = (List)this.checkedStateStore.get(object);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.listViewer.setChecked(iterator.next(), true);
                }
            }
        }
    }

    private void primeHierarchyForSelection(Object object, Set set) {
        if (set.contains(object)) {
            return;
        }
        this.checkedStateStore.put(object, new ArrayList());
        this.expandedTreeNodes.add(object);
        set.add(object);
        Object object2 = this.treeContentProvider.getParent(object);
        if (object2 != null) {
            this.primeHierarchyForSelection(object2, set);
        }
    }

    public void removeCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.listeners.remove((Object)iCheckStateListener);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        if (object != this.currentTreeSelection) {
            this.populateListViewer(object);
        }
        this.currentTreeSelection = object;
    }

    public void setAllSelections(final boolean bl) {
        if (this.root == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SelectResourcesBlock.this.setTreeChecked(SelectResourcesBlock.this.root, bl);
                SelectResourcesBlock.this.listViewer.setAllChecked(bl);
            }
        });
    }

    private void setListForWhiteSelection(Object object) {
        Object[] objectArray = this.listContentProvider.getElements(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n]);
            ++n;
        }
        this.checkedStateStore.put(object, arrayList);
    }

    public void setListComparator(ViewerComparator viewerComparator) {
        this.listViewer.setComparator(viewerComparator);
    }

    private void setTreeChecked(Object object, boolean bl) {
        if (object.equals(this.currentTreeSelection)) {
            this.listViewer.setAllChecked(bl);
        }
        if (bl) {
            this.setListForWhiteSelection(object);
        } else {
            this.checkedStateStore.remove(object);
        }
        this.setWhiteChecked(object, bl);
        this.treeViewer.setChecked(object, bl);
        this.treeViewer.setGrayed(object, false);
        if (this.expandedTreeNodes.contains(object)) {
            Object[] objectArray = this.treeContentProvider.getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                this.setTreeChecked(objectArray[n], bl);
                ++n;
            }
        }
    }

    public void setTreeComparator(ViewerComparator viewerComparator) {
        this.treeViewer.setComparator(viewerComparator);
    }

    private void setWhiteChecked(Object object, boolean bl) {
        if (bl) {
            if (!this.whiteCheckedTreeItems.contains(object)) {
                this.whiteCheckedTreeItems.add(object);
            }
        } else {
            this.whiteCheckedTreeItems.remove(object);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.expandTreeElement(treeExpansionEvent.getElement());
    }

    private void treeItemChecked(Object object, boolean bl) {
        this.setTreeChecked(object, bl);
        Object object2 = this.treeContentProvider.getParent(object);
        if (object2 == null) {
            return;
        }
        if (bl) {
            this.grayCheckHierarchy(object2);
        } else {
            this.ungrayCheckHierarchy(object2);
        }
        this.grayUpdateHierarchy(object2);
    }

    private void ungrayCheckHierarchy(Object object) {
        Object object2;
        if (!this.determineShouldBeAtLeastGrayChecked(object)) {
            this.checkedStateStore.remove(object);
        }
        if ((object2 = this.treeContentProvider.getParent(object)) != null) {
            this.ungrayCheckHierarchy(object2);
        }
    }

    public void updateSelections(Map map) {
        Object object2;
        this.listViewer.setAllChecked(false);
        this.treeViewer.setCheckedElements(new Object[0]);
        this.whiteCheckedTreeItems = new HashSet();
        HashSet hashSet = new HashSet();
        this.checkedStateStore = new HashMap();
        for (Object object2 : map.keySet()) {
            this.primeHierarchyForSelection(object2, hashSet);
            this.checkedStateStore.put(object2, map.get(object2));
        }
        this.treeViewer.setCheckedElements(this.checkedStateStore.keySet().toArray());
        this.treeViewer.setGrayedElements(this.checkedStateStore.keySet().toArray());
        if (this.currentTreeSelection != null && (object2 = map.get(this.currentTreeSelection)) != null) {
            this.listViewer.setCheckedElements(((List)object2).toArray());
        }
    }

    static interface IElementFilter {
        public void filterElements(Collection var1) throws InterruptedException;

        public void filterElements(Object[] var1) throws InterruptedException;
    }
}

