/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.HashSet;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.filebuffers.manipulation.RemoveTrailingWhitespaceOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.editors.text.FileBufferOperationHandler;
import org.eclipse.ui.internal.editors.text.SelectResourcesDialog;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class RemoveTrailingWhitespaceHandler
extends FileBufferOperationHandler {
    private boolean fStrictCheckIfTextLocation = true;

    public RemoveTrailingWhitespaceHandler() {
        super((IFileBufferOperation)new RemoveTrailingWhitespaceOperation());
    }

    @Override
    protected boolean isAcceptableLocation(IPath iPath) {
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        return iPath != null && iTextFileBufferManager.isTextFileLocation(iPath, this.fStrictCheckIfTextLocation);
    }

    @Override
    protected IFile[] collectFiles(IResource[] iResourceArray) {
        IFile[] iFileArray = super.collectFiles(iResourceArray);
        iFileArray = this.filterUnacceptableFiles(iFileArray);
        if (this.containsOnlyFiles(iResourceArray)) {
            return iFileArray;
        }
        SelectResourcesDialog.IFilter iFilter = new SelectResourcesDialog.IFilter(){

            @Override
            public boolean accept(IResource iResource) {
                return iResource != null && RemoveTrailingWhitespaceHandler.this.isAcceptableLocation(iResource.getFullPath());
            }
        };
        SelectResourcesDialog selectResourcesDialog = new SelectResourcesDialog(this.getShell(), TextEditorMessages.RemoveTrailingWhitespaceHandler_dialog_title, TextEditorMessages.RemoveTrailingWhitespaceHandler_dialog_description, iFilter);
        selectResourcesDialog.setInput(iResourceArray);
        int n = selectResourcesDialog.open();
        if (n == 0) {
            IResource[] iResourceArray2 = selectResourcesDialog.getSelectedResources();
            return super.collectFiles(iResourceArray2);
        }
        return null;
    }

    private boolean containsOnlyFiles(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if ((1 & iResource.getType()) == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private IFile[] filterUnacceptableFiles(IFile[] iFileArray) {
        HashSet<IFile> hashSet = new HashSet<IFile>();
        int n = 0;
        while (n < iFileArray.length) {
            IFile iFile = iFileArray[n];
            if (this.isAcceptableLocation(iFile.getFullPath())) {
                hashSet.add(iFile);
            }
            ++n;
        }
        return hashSet.toArray(new IFile[hashSet.size()]);
    }

    public void setEnabled(Object object) {
        this.fStrictCheckIfTextLocation = true;
        if (object instanceof IEvaluationContext) {
            Object object2 = ((IEvaluationContext)object).getVariable("selection");
            this.fStrictCheckIfTextLocation = !(object2 instanceof ITextSelection);
        }
        super.setEnabled(object);
    }
}

