/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.quickdiff.QuickDiff;
import org.eclipse.ui.texteditor.quickdiff.ReferenceProviderDescriptor;

class QuickDiffConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            QuickDiffConfigurationBlock.this.fStore.setValue((String)QuickDiffConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Combo fQuickDiffProviderCombo;
    private String[][] fQuickDiffProviderListModel;
    private String[][] fQuickDiffModel;
    private ColorSelector[] fQuickDiffColorEditors;
    private Button fQuickDiffOverviewRulerCheckBox;
    private Button fEnablementCheckbox;
    private Composite fQuickDiffProviderNote;

    public QuickDiffConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fStore = overlayPreferenceStore;
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.fStore.addKeys(this.createOverlayStoreKeys(markerAnnotationPreferences));
        this.fQuickDiffModel = this.createQuickDiffModel(markerAnnotationPreferences);
        this.fQuickDiffProviderListModel = this.createQuickDiffReferenceListModel();
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences markerAnnotationPreferences) {
        AnnotationPreference annotationPreference2;
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "quickdiff.quickDiff"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "quickdiff.defaultProvider"));
        for (AnnotationPreference annotationPreference2 : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (!annotationPreference2.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") && !annotationPreference2.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") && !annotationPreference2.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, annotationPreference2.getColorPreferenceKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, annotationPreference2.getOverviewRulerPreferenceKey()));
        }
        annotationPreference2 = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray((T[])annotationPreference2);
        return annotationPreference2;
    }

    private String[][] createQuickDiffModel(MarkerAnnotationPreferences markerAnnotationPreferences) {
        String[][] stringArray = new String[3][];
        for (AnnotationPreference annotationPreference : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange")) {
                stringArray[0] = new String[]{annotationPreference.getColorPreferenceKey(), annotationPreference.getOverviewRulerPreferenceKey(), TextEditorMessages.QuickDiffConfigurationBlock_changeColor};
                continue;
            }
            if (annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition")) {
                stringArray[1] = new String[]{annotationPreference.getColorPreferenceKey(), annotationPreference.getOverviewRulerPreferenceKey(), TextEditorMessages.QuickDiffConfigurationBlock_additionColor};
                continue;
            }
            if (!annotationPreference.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            stringArray[2] = new String[]{annotationPreference.getColorPreferenceKey(), annotationPreference.getOverviewRulerPreferenceKey(), TextEditorMessages.QuickDiffConfigurationBlock_deletionColor};
        }
        return stringArray;
    }

    private String[][] createQuickDiffReferenceListModel() {
        List list = new QuickDiff().getReferenceProviderDescriptors();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (ReferenceProviderDescriptor referenceProviderDescriptor : list) {
            String string = LegacyActionTools.removeMnemonics((String)referenceProviderDescriptor.getLabel());
            arrayList.add(new String[]{referenceProviderDescriptor.getId(), string});
        }
        String[][] stringArray = new String[arrayList.size()][];
        arrayList.toArray((T[])stringArray);
        return stringArray;
    }

    private Button addCheckBox(Composite composite, String string, String string2, int n) {
        Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(button, string2);
        return button;
    }

    private Composite createNoteComposite(Font font, Composite composite, String string, String string2) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite2.setFont(font);
        Label label = new Label(composite2, 1);
        label.setText(string);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        Label label2 = new Label(composite2, 64);
        label2.setText(string2);
        label2.setFont(font);
        return composite2;
    }

    @Override
    public Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        String string = TextEditorMessages.QuickDiffConfigurationBlock_showForNewEditors;
        this.fEnablementCheckbox = this.addCheckBox(composite2, string, "quickdiff.quickDiff", 0);
        this.fEnablementCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = QuickDiffConfigurationBlock.this.fEnablementCheckbox.getSelection();
                QuickDiffConfigurationBlock.this.fStore.setValue("spellingEnabled", bl);
                QuickDiffConfigurationBlock.this.updateEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.addFiller(composite2);
        string = TextEditorMessages.QuickDiffConfigurationBlock_showInOverviewRuler;
        this.fQuickDiffOverviewRulerCheckBox = new Button(composite2, 32);
        this.fQuickDiffOverviewRulerCheckBox.setText(string);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalIndent = 0;
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        this.fQuickDiffOverviewRulerCheckBox.setLayoutData((Object)gridData);
        this.fQuickDiffOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = 0;
                while (n < QuickDiffConfigurationBlock.this.fQuickDiffModel.length) {
                    QuickDiffConfigurationBlock.this.fStore.setValue(QuickDiffConfigurationBlock.this.fQuickDiffModel[n][1], QuickDiffConfigurationBlock.this.fQuickDiffOverviewRulerCheckBox.getSelection());
                    ++n;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label = new Label(composite2, 16384);
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        gridData.heightHint = 5;
        label.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText(TextEditorMessages.QuickDiffConfigurationBlock_colorTitle);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        group.setLayoutData((Object)gridData);
        this.fQuickDiffColorEditors = new ColorSelector[3];
        int n = 0;
        while (n < this.fQuickDiffModel.length) {
            ColorSelector colorSelector;
            string = this.fQuickDiffModel[n][2];
            label = new Label((Composite)group, 16384);
            label.setText(string);
            this.fQuickDiffColorEditors[n] = colorSelector = new ColorSelector((Composite)group);
            Button button = colorSelector.getButton();
            gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalAlignment = 1;
            button.setLayoutData((Object)gridData);
            final int n2 = n++;
            button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = QuickDiffConfigurationBlock.this.fQuickDiffModel[n2][0];
                    PreferenceConverter.setValue((IPreferenceStore)QuickDiffConfigurationBlock.this.fStore, (String)string, (RGB)colorSelector.getColorValue());
                }
            });
        }
        this.addFiller(composite2);
        label = new Label(composite2, 16384);
        label.setText(TextEditorMessages.QuickDiffConfigurationBlock_referenceProviderTitle);
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, false, true);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        composite3.setLayoutData((Object)gridData);
        this.fQuickDiffProviderCombo = new Combo(composite3, 12);
        gridData = new GridData(4, 1, true, false);
        this.fQuickDiffProviderCombo.setLayoutData((Object)gridData);
        this.fQuickDiffProviderCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = QuickDiffConfigurationBlock.this.fQuickDiffProviderCombo.getSelectionIndex();
                QuickDiffConfigurationBlock.this.fStore.setValue("quickdiff.defaultProvider", QuickDiffConfigurationBlock.this.fQuickDiffProviderListModel[n][0]);
            }
        });
        this.fQuickDiffProviderNote = this.createNoteComposite(composite.getFont(), composite3, TextEditorMessages.QuickDiffConfigurationBlock_referenceProviderNoteTitle, TextEditorMessages.QuickDiffConfigurationBlock_referenceProviderNoteMessage);
        gridData = new GridData(1, 4, false, true);
        gridData.horizontalSpan = 2;
        this.fQuickDiffProviderNote.setLayoutData((Object)gridData);
        return composite2;
    }

    @Override
    public void applyData(Object object) {
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    private void updateEnablement() {
        boolean bl = this.fEnablementCheckbox.getSelection();
        this.fQuickDiffOverviewRulerCheckBox.setEnabled(bl);
        this.fQuickDiffProviderCombo.setEnabled(bl);
        int n = 0;
        while (n < this.fQuickDiffColorEditors.length) {
            this.fQuickDiffColorEditors[n].setEnabled(bl);
            ++n;
        }
        this.fQuickDiffProviderNote.setEnabled(bl);
        Control[] controlArray = this.fQuickDiffProviderNote.getChildren();
        int n2 = 0;
        while (n2 < controlArray.length) {
            controlArray[n2].setEnabled(bl);
            ++n2;
        }
    }

    private void updateProviderList() {
        String string = this.fStore.getString("quickdiff.defaultProvider");
        int n = 0;
        while (n < this.fQuickDiffProviderListModel.length) {
            if (string.equals(this.fQuickDiffProviderListModel[n][0])) {
                this.fQuickDiffProviderCombo.select(n);
            }
            ++n;
        }
        this.fQuickDiffProviderCombo.redraw();
    }

    @Override
    public void initialize() {
        int n = 0;
        while (n < this.fQuickDiffProviderListModel.length) {
            String string = this.fQuickDiffProviderListModel[n][1];
            this.fQuickDiffProviderCombo.add(string);
            ++n;
        }
        this.fQuickDiffProviderCombo.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QuickDiffConfigurationBlock.this.updateProviderList();
            }
        });
        this.initializeFields();
    }

    private void initializeFields() {
        for (Button button : this.fCheckBoxes.keySet()) {
            String string = (String)this.fCheckBoxes.get(button);
            button.setSelection(this.fStore.getBoolean(string));
        }
        this.updateQuickDiffControls();
    }

    @Override
    public boolean canPerformOk() {
        return true;
    }

    @Override
    public void performOk() {
    }

    @Override
    public void performDefaults() {
        this.initializeFields();
        this.updateProviderList();
        this.updateEnablement();
    }

    private void updateQuickDiffControls() {
        boolean bl = false;
        int n = 0;
        while (n < this.fQuickDiffModel.length) {
            this.fQuickDiffColorEditors[n].setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)this.fQuickDiffModel[n][0]));
            bl |= this.fStore.getBoolean(this.fQuickDiffModel[n][1]);
            ++n;
        }
        this.fQuickDiffOverviewRulerCheckBox.setSelection(bl);
    }

    @Override
    public void dispose() {
    }
}

