/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;

public class NonExistingFileEditorInput
implements IEditorInput,
ILocationProvider {
    private static int fgNonExisting = 0;
    private IFileStore fFileStore;
    private String fName;

    public NonExistingFileEditorInput(IFileStore iFileStore, String string) {
        Assert.isNotNull((Object)iFileStore);
        Assert.isTrue((boolean)"file".equals(iFileStore.getFileSystem().getScheme()));
        this.fFileStore = iFileStore;
        this.fName = String.valueOf(string) + " " + ++fgNonExisting;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fName);
    }

    public String getName() {
        return this.fName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fName;
    }

    public Object getAdapter(Class clazz) {
        if (ILocationProvider.class.equals((Object)clazz)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }

    @Override
    public IPath getPath(Object object) {
        if (object instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput nonExistingFileEditorInput = (NonExistingFileEditorInput)object;
            return new Path(nonExistingFileEditorInput.fFileStore.toURI().getPath());
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NonExistingFileEditorInput) {
            NonExistingFileEditorInput nonExistingFileEditorInput = (NonExistingFileEditorInput)object;
            return this.fFileStore.equals(nonExistingFileEditorInput.fFileStore);
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }
}

