/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import com.ibm.icu.text.Collator;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public abstract class NextPreviousPulldownActionDelegate
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private Menu fMenu;
    private IPreferenceStore fStore = EditorsPlugin.getDefault().getPreferenceStore();

    public abstract String getPreferenceKey(AnnotationPreference var1);

    public Menu getMenu(Control control) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(control);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Menu menu) {
        if (this.fMenu == null) {
            this.fMenu = new Menu(menu);
            this.fillMenu(this.fMenu);
        }
        return this.fMenu;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    private void fillMenu(Menu menu) {
        IAction[] iActionArray = this.getActionsFromDescriptors();
        int n = 0;
        while (n < iActionArray.length) {
            ActionContributionItem actionContributionItem = new ActionContributionItem(iActionArray[n]);
            actionContributionItem.fill(menu, -1);
            ++n;
        }
    }

    private IAction[] getActionsFromDescriptors() {
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        TreeSet<NavigationEnablementAction> treeSet = new TreeSet<NavigationEnablementAction>();
        for (AnnotationPreference annotationPreference : markerAnnotationPreferences.getAnnotationPreferences()) {
            String string = annotationPreference.getShowInNextPrevDropdownToolbarActionKey();
            if (string == null || !this.fStore.getBoolean(string)) continue;
            String string2 = this.getPreferenceKey(annotationPreference);
            string2 = annotationPreference.getIsGoToNextNavigationTargetKey();
            if (string2 == null) continue;
            treeSet.add(new NavigationEnablementAction(annotationPreference.getPreferenceLabel(), this.fStore, string2));
        }
        return (IAction[])treeSet.toArray(new Action[treeSet.size()]);
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void run(IAction iAction) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private static class NavigationEnablementAction
    extends Action
    implements Comparable {
        private IPreferenceStore fStore;
        private String fKey;
        private String fName;

        public NavigationEnablementAction(String string, IPreferenceStore iPreferenceStore, String string2) {
            super(string, 2);
            this.fStore = iPreferenceStore;
            this.fKey = string2;
            this.fName = string;
            this.setChecked(this.fStore.getBoolean(this.fKey));
        }

        public void run() {
            this.fStore.setValue(this.fKey, this.isChecked());
        }

        public int compareTo(Object object) {
            if (!(object instanceof NavigationEnablementAction)) {
                return -1;
            }
            String string = ((NavigationEnablementAction)object).fName;
            return Collator.getInstance().compare(this.fName, string);
        }
    }
}

