/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.osgi.service.prefs.BackingStoreException;

class LinkedModeConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final String EXIT = "org.eclipse.ui.internal.workbench.texteditor.link.exit";
    private static final String TARGET = "org.eclipse.ui.internal.workbench.texteditor.link.target";
    private static final String MASTER = "org.eclipse.ui.internal.workbench.texteditor.link.master";
    private static final String SLAVE = "org.eclipse.ui.internal.workbench.texteditor.link.slave";
    static final String[] HIGHLIGHT = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_HIGHLIGHT, "unused"};
    static final String[] UNDERLINE = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_UNDERLINE, "UNDERLINE"};
    static final String[] BOX = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_BOX, "BOX"};
    static final String[] DASHED_BOX = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_DASHED_BOX, "DASHED_BOX"};
    static final String[] IBEAM = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_IBEAM, "IBEAM"};
    static final String[] SQUIGGLES = new String[]{TextEditorMessages.LinkedModeConfigurationBlock_SQUIGGLES, "SQUIGGLES"};
    private ColorSelector fAnnotationForegroundColorEditor;
    private Button fShowInTextCheckBox;
    private StructuredViewer fAnnotationTypeViewer;
    private final ListItem[] fListModel;
    private ComboViewer fDecorationViewer;
    private FontMetrics fFontMetrics;
    protected static final int INDENT = 20;
    private OverlayPreferenceStore fStore;
    private ArrayList fMasterSlaveListeners = new ArrayList();

    private OverlayPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    public LinkedModeConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        this.fStore = overlayPreferenceStore;
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.getPreferenceStore().addKeys(this.createOverlayStoreKeys(markerAnnotationPreferences));
        this.fListModel = this.createAnnotationTypeListModel(markerAnnotationPreferences);
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences markerAnnotationPreferences) {
        AnnotationPreference annotationPreference2;
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        for (AnnotationPreference annotationPreference2 : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (!this.isLinkedModeAnnotation(annotationPreference2)) continue;
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, annotationPreference2.getColorPreferenceKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, annotationPreference2.getTextPreferenceKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, annotationPreference2.getTextStylePreferenceKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, annotationPreference2.getHighlightPreferenceKey()));
        }
        annotationPreference2 = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray((T[])annotationPreference2);
        return annotationPreference2;
    }

    private boolean isLinkedModeAnnotation(AnnotationPreference annotationPreference) {
        Object object = annotationPreference.getAnnotationType();
        return object.equals(MASTER) || object.equals(SLAVE) || object.equals(TARGET) || object.equals(EXIT);
    }

    private ListItem[] createAnnotationTypeListModel(MarkerAnnotationPreferences markerAnnotationPreferences) {
        AnnotationPreference annotationPreference2;
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        for (AnnotationPreference annotationPreference2 : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (!this.isLinkedModeAnnotation(annotationPreference2)) continue;
            String string = annotationPreference2.getPreferenceLabel();
            List list = this.getStyles(annotationPreference2.getAnnotationType());
            arrayList.add(new ListItem(string, annotationPreference2.getColorPreferenceKey(), annotationPreference2.getTextPreferenceKey(), annotationPreference2.getHighlightPreferenceKey(), annotationPreference2.getTextStylePreferenceKey(), list));
        }
        annotationPreference2 = new ListItem[arrayList.size()];
        arrayList.toArray((T[])annotationPreference2);
        return annotationPreference2;
    }

    private List getStyles(Object object) {
        if (object.equals(MASTER)) {
            return Arrays.asList(BOX, DASHED_BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (object.equals(SLAVE)) {
            return Arrays.asList(BOX, DASHED_BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (object.equals(TARGET)) {
            return Arrays.asList(BOX, DASHED_BOX, HIGHLIGHT, UNDERLINE, SQUIGGLES);
        }
        if (object.equals(EXIT)) {
            return Arrays.asList(new String[][]{IBEAM});
        }
        return new ArrayList();
    }

    @Override
    public Control createControl(Composite composite) {
        OverlayPreferenceStore overlayPreferenceStore = this.getPreferenceStore();
        overlayPreferenceStore.load();
        overlayPreferenceStore.start();
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(TextEditorMessages.LinkedModeConfigurationBlock_annotationPresentationOptions);
        GridData gridData = new GridData(256);
        label.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true);
        composite3.setLayoutData((Object)gridData);
        this.fAnnotationTypeViewer = new TableViewer(composite3, 2564);
        this.fAnnotationTypeViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.fAnnotationTypeViewer.setContentProvider((IContentProvider)new ItemContentProvider());
        gridData = new GridData(1, 1, false, false);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        this.fAnnotationTypeViewer.getControl().setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fShowInTextCheckBox = new Button(composite4, 32);
        this.fShowInTextCheckBox.setText(TextEditorMessages.LinkedModeConfigurationBlock_labels_showIn);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        this.fShowInTextCheckBox.setLayoutData((Object)gridData);
        this.fDecorationViewer = new ComboViewer(composite4, 8);
        this.fDecorationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fDecorationViewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        this.fDecorationViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        this.fDecorationViewer.getControl().setLayoutData((Object)gridData);
        this.fDecorationViewer.setInput((Object)new Object[]{HIGHLIGHT, SQUIGGLES, BOX, DASHED_BOX, UNDERLINE, IBEAM});
        label = new Label(composite4, 16384);
        label.setText(TextEditorMessages.LinkedModeConfigurationBlock_color);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.fAnnotationForegroundColorEditor = new ColorSelector(composite4);
        Button button = this.fAnnotationForegroundColorEditor.getButton();
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        button.setLayoutData((Object)gridData);
        this.createDependency(this.fShowInTextCheckBox, new Control[]{label, button});
        this.fAnnotationTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                LinkedModeConfigurationBlock.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListItem listItem = LinkedModeConfigurationBlock.this.getSelectedItem();
                boolean bl = LinkedModeConfigurationBlock.this.fShowInTextCheckBox.getSelection();
                if (bl) {
                    String[] stringArray = (String[])((IStructuredSelection)LinkedModeConfigurationBlock.this.fDecorationViewer.getSelection()).getFirstElement();
                    if (HIGHLIGHT.equals(stringArray)) {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.highlightKey, true);
                    } else {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.textKey, true);
                    }
                } else {
                    LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.textKey, false);
                    LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.highlightKey, false);
                }
                LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.textKey, bl);
                LinkedModeConfigurationBlock.this.updateDecorationViewer(listItem, false);
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListItem listItem = LinkedModeConfigurationBlock.this.getSelectedItem();
                PreferenceConverter.setValue((IPreferenceStore)LinkedModeConfigurationBlock.this.getPreferenceStore(), (String)listItem.colorKey, (RGB)LinkedModeConfigurationBlock.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        this.fDecorationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                String[] stringArray = (String[])((IStructuredSelection)LinkedModeConfigurationBlock.this.fDecorationViewer.getSelection()).getFirstElement();
                ListItem listItem = LinkedModeConfigurationBlock.this.getSelectedItem();
                if (LinkedModeConfigurationBlock.this.fShowInTextCheckBox.getSelection()) {
                    if (HIGHLIGHT.equals(stringArray)) {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.highlightKey, true);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.textKey, false);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.textStyleKey, "NONE");
                    } else {
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.highlightKey, false);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.textKey, true);
                        LinkedModeConfigurationBlock.this.getPreferenceStore().setValue(listItem.textStyleKey, stringArray[1]);
                    }
                }
            }
        });
        return composite2;
    }

    @Override
    public void applyData(Object object) {
    }

    protected int convertWidthInCharsToPixels(int n) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    protected int convertHeightInCharsToPixels(int n) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)n);
    }

    protected void initializeDialogUnits(Control control) {
        GC gC = new GC((Drawable)control);
        gC.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gC.getFontMetrics();
        gC.dispose();
    }

    private void handleAnnotationListSelection() {
        ListItem listItem = this.getSelectedItem();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)listItem.colorKey);
        this.fAnnotationForegroundColorEditor.setColorValue(rGB);
        boolean bl = listItem.highlightKey == null ? false : this.getPreferenceStore().getBoolean(listItem.highlightKey);
        boolean bl2 = listItem.textKey == null ? false : this.getPreferenceStore().getBoolean(listItem.textKey);
        this.fShowInTextCheckBox.setSelection(bl2 || bl);
        this.updateDecorationViewer(listItem, true);
    }

    @Override
    public void initialize() {
        this.initializeFields();
        this.fAnnotationTypeViewer.setInput((Object)this.fListModel);
        this.fAnnotationTypeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LinkedModeConfigurationBlock.this.fAnnotationTypeViewer != null && !LinkedModeConfigurationBlock.this.fAnnotationTypeViewer.getControl().isDisposed()) {
                    LinkedModeConfigurationBlock.this.fAnnotationTypeViewer.setSelection((ISelection)new StructuredSelection((Object)LinkedModeConfigurationBlock.this.fListModel[0]));
                    LinkedModeConfigurationBlock.this.initializeFields();
                }
            }
        });
    }

    private ListItem getSelectedItem() {
        return (ListItem)((IStructuredSelection)this.fAnnotationTypeViewer.getSelection()).getFirstElement();
    }

    private void updateDecorationViewer(ListItem listItem, boolean bl) {
        boolean bl2 = this.fShowInTextCheckBox.getSelection() && (listItem.highlightKey != null || listItem.textStyleKey != null);
        this.fDecorationViewer.getControl().setEnabled(bl2);
        if (bl) {
            String[] stringArray = null;
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(listItem.validStyles);
            if (this.getPreferenceStore().getBoolean(listItem.highlightKey)) {
                stringArray = HIGHLIGHT;
            }
            if (stringArray == null) {
                String string = this.getPreferenceStore().getString(listItem.textStyleKey);
                for (String[] stringArray2 : arrayList) {
                    if (!stringArray2[1].equals(string)) continue;
                    stringArray = stringArray2;
                    break;
                }
            }
            this.fDecorationViewer.setInput((Object)arrayList.toArray(new Object[arrayList.size()]));
            if (stringArray == null) {
                stringArray = (String[])arrayList.get(0);
            }
            this.fDecorationViewer.setSelection((ISelection)new StructuredSelection((Object)stringArray), true);
        }
    }

    @Override
    public void performOk() {
        this.getPreferenceStore().propagate();
        try {
            Platform.getPreferencesService().getRootNode().node("instance").node("org.eclipse.ui.editors").flush();
        }
        catch (BackingStoreException backingStoreException) {
            EditorsPlugin.log(backingStoreException);
        }
    }

    @Override
    public void performDefaults() {
        this.getPreferenceStore().loadDefaults();
        this.handleAnnotationListSelection();
        this.initializeFields();
    }

    @Override
    public void dispose() {
        OverlayPreferenceStore overlayPreferenceStore = this.getPreferenceStore();
        if (overlayPreferenceStore != null) {
            overlayPreferenceStore.stop();
        }
    }

    protected void createDependency(Button button, Control control) {
        this.createDependency(button, new Control[]{control});
    }

    protected void createDependency(final Button button, final Control[] controlArray) {
        Assert.isTrue((controlArray.length > 0 ? 1 : 0) != 0);
        LinkedModeConfigurationBlock.indent(controlArray[0]);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                int n = 0;
                while (n < controlArray.length) {
                    controlArray[n].setEnabled(bl);
                    ++n;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        button.addSelectionListener(selectionListener);
        this.fMasterSlaveListeners.add(selectionListener);
    }

    protected static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    private void initializeFields() {
        for (SelectionListener selectionListener : this.fMasterSlaveListeners) {
            selectionListener.widgetSelected(null);
        }
    }

    @Override
    public boolean canPerformOk() {
        return true;
    }

    private static class ArrayLabelProvider
    extends LabelProvider {
        private ArrayLabelProvider() {
        }

        public String getText(Object object) {
            return ((String[])object)[0].toString();
        }
    }

    private static final class ItemContentProvider
    implements IStructuredContentProvider {
        private ItemContentProvider() {
        }

        public Object[] getElements(Object object) {
            return (ListItem[])object;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private final class ItemLabelProvider
    extends LabelProvider {
        private ItemLabelProvider() {
        }

        public String getText(Object object) {
            return ((ListItem)object).label;
        }
    }

    private static final class ListItem {
        final String label;
        final String colorKey;
        final String highlightKey;
        final String textStyleKey;
        final String textKey;
        final List validStyles;

        ListItem(String string, String string2, String string3, String string4, String string5, List list) {
            this.label = string;
            this.colorKey = string2;
            this.highlightKey = string4;
            this.textKey = string3;
            this.textStyleKey = string5;
            this.validStyles = list;
        }
    }
}

