/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.HyperlinkDetectorTargetDescriptor;

class HyperlinkDetectorsConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final String MODIFIER_DELIMITER = TextEditorMessages.HyperlinkKeyModifier_delimiter;
    private OverlayPreferenceStore fStore;
    private CheckboxTableViewer fHyperlinkDetectorsViewer;
    private ListItem[] fListModel;
    private final HyperlinkDetectorDescriptor[] fHyperlinkDetectorDescriptors;
    private Text fHyperlinkDefaultKeyModifierText;
    private Text fHyperlinkKeyModifierText;
    private Button fHyperlinksEnabledCheckBox;
    private StatusInfo fHyperlinkKeyModifierStatus;
    private PreferencePage fPreferencePage;

    public HyperlinkDetectorsConfigurationBlock(PreferencePage preferencePage, OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)overlayPreferenceStore);
        Assert.isNotNull((Object)preferencePage);
        this.fStore = overlayPreferenceStore;
        this.fPreferencePage = preferencePage;
        this.fHyperlinkDetectorDescriptors = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
        this.fStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int n = 0;
        while (n < this.fHyperlinkDetectorDescriptors.length) {
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, this.fHyperlinkDetectorDescriptors[n].getId()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, String.valueOf(this.fHyperlinkDetectorDescriptors[n].getId()) + "_stateMask"));
            ++n;
        }
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hyperlinkKeyModifier"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "hyperlinksEnabled"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    @Override
    public Control createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.addFiller(composite2, 2);
        String string = TextEditorMessages.HyperlinksEnabled_label;
        this.fHyperlinksEnabledCheckBox = this.addCheckBox(composite2, string, "hyperlinksEnabled", 0);
        this.fHyperlinksEnabledCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = HyperlinkDetectorsConfigurationBlock.this.fHyperlinksEnabledCheckBox.getSelection();
                HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.setEnabled(bl);
                HyperlinkDetectorsConfigurationBlock.this.fHyperlinkKeyModifierText.setEnabled(bl && HyperlinkDetectorsConfigurationBlock.this.getSelectedItem() != null);
                HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDetectorsViewer.getTable().setEnabled(bl);
                HyperlinkDetectorsConfigurationBlock.this.handleHyperlinkKeyModifierModified();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        string = TextEditorMessages.HyperlinkDefaultKeyModifier_label;
        this.fHyperlinkDefaultKeyModifierText = (Text)this.addTextField(composite2, string, "hyperlinkKeyModifier", 15, 20, pixelConverter)[1];
        this.fHyperlinkDefaultKeyModifierText.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent keyEvent) {
                this.isModifierCandidate = keyEvent.keyCode > 0 && keyEvent.character == '\u0000' && keyEvent.stateMask == 0;
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (this.isModifierCandidate && keyEvent.stateMask > 0 && keyEvent.stateMask == keyEvent.stateMask && keyEvent.character == '\u0000') {
                    boolean bl;
                    String string = HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.getText();
                    Point point = HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.getSelection();
                    int n = point.x - 1;
                    while (n > -1 && Character.isWhitespace(string.charAt(n))) {
                        --n;
                    }
                    boolean bl2 = n > -1 && !String.valueOf(string.charAt(n)).equals(MODIFIER_DELIMITER);
                    n = point.y;
                    while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                        ++n;
                    }
                    boolean bl3 = bl = n < string.length() && !String.valueOf(string.charAt(n)).equals(MODIFIER_DELIMITER);
                    String string2 = bl2 && bl ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertDelimiterAndModifierAndDelimiter, Action.findModifierString((int)keyEvent.stateMask)) : (bl2 ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertDelimiterAndModifier, Action.findModifierString((int)keyEvent.stateMask)) : (bl ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertModifierAndDelimiter, Action.findModifierString((int)keyEvent.stateMask)) : Action.findModifierString((int)keyEvent.stateMask)));
                    HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.insert(string2);
                }
            }
        });
        this.fHyperlinkDefaultKeyModifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                HyperlinkDetectorsConfigurationBlock.this.handleHyperlinkDefaultKeyModifierModified();
            }
        });
        this.addFiller(composite2, 2);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 20;
        composite3.setLayoutData((Object)gridData);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite3.setLayout((Layout)tableColumnLayout);
        Table table = new Table(composite3, 68388);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(composite.getFont());
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HyperlinkDetectorsConfigurationBlock.this.handleListSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        ColumnWeightData columnWeightData = new ColumnWeightData(1);
        TableColumn tableColumn = new TableColumn(table, 0, 0);
        tableColumn.setText(TextEditorMessages.HyperlinkDetectorTable_nameColumn);
        tableColumnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(table, 0, 1);
        tableColumn2.setText(TextEditorMessages.HyperlinkDetectorTable_modifierKeysColumn);
        tableColumnLayout.setColumnData((Widget)tableColumn2, (ColumnLayoutData)columnWeightData);
        TableColumn tableColumn3 = new TableColumn(table, 0, 2);
        tableColumn3.setText(TextEditorMessages.HyperlinkDetectorTable_targetNameColumn);
        tableColumnLayout.setColumnData((Widget)tableColumn3, (ColumnLayoutData)columnWeightData);
        this.fHyperlinkDetectorsViewer = new CheckboxTableViewer(table);
        this.fHyperlinkDetectorsViewer.setUseHashlookup(true);
        this.fHyperlinkDetectorsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                String string = ((ListItem)checkStateChangedEvent.getElement()).id;
                if (string == null) {
                    return;
                }
                HyperlinkDetectorsConfigurationBlock.this.fStore.setValue(string, !checkStateChangedEvent.getChecked());
            }
        });
        this.fHyperlinkDetectorsViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.fHyperlinkDetectorsViewer.setContentProvider((IContentProvider)new ItemContentProvider());
        gridData = new GridData(4, 4, true, false);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(10);
        this.fHyperlinkDetectorsViewer.getControl().setLayoutData((Object)gridData);
        string = TextEditorMessages.HyperlinkKeyModifier_label;
        this.fHyperlinkKeyModifierText = (Text)this.addTextField(composite2, string, null, 15, 20, pixelConverter)[1];
        this.fHyperlinkKeyModifierText.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent keyEvent) {
                this.isModifierCandidate = keyEvent.keyCode > 0 && keyEvent.character == '\u0000' && keyEvent.stateMask == 0;
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (this.isModifierCandidate && keyEvent.stateMask > 0 && keyEvent.stateMask == keyEvent.stateMask && keyEvent.character == '\u0000') {
                    boolean bl;
                    String string = HyperlinkDetectorsConfigurationBlock.this.fHyperlinkKeyModifierText.getText();
                    Point point = HyperlinkDetectorsConfigurationBlock.this.fHyperlinkKeyModifierText.getSelection();
                    int n = point.x - 1;
                    while (n > -1 && Character.isWhitespace(string.charAt(n))) {
                        --n;
                    }
                    boolean bl2 = n > -1 && !String.valueOf(string.charAt(n)).equals(MODIFIER_DELIMITER);
                    n = point.y;
                    while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                        ++n;
                    }
                    boolean bl3 = bl = n < string.length() && !String.valueOf(string.charAt(n)).equals(MODIFIER_DELIMITER);
                    String string2 = bl2 && bl ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertDelimiterAndModifierAndDelimiter, Action.findModifierString((int)keyEvent.stateMask)) : (bl2 ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertDelimiterAndModifier, Action.findModifierString((int)keyEvent.stateMask)) : (bl ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertModifierAndDelimiter, Action.findModifierString((int)keyEvent.stateMask)) : Action.findModifierString((int)keyEvent.stateMask)));
                    HyperlinkDetectorsConfigurationBlock.this.fHyperlinkKeyModifierText.insert(string2);
                }
            }
        });
        this.fHyperlinkKeyModifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                HyperlinkDetectorsConfigurationBlock.this.handleHyperlinkKeyModifierModified();
            }
        });
        return composite2;
    }

    @Override
    public void applyData(Object object) {
    }

    private void addFiller(Composite composite, int n) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    private Button addCheckBox(Composite composite, String string, final String string2, int n) {
        final Button button = new Button(composite, 32);
        button.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                HyperlinkDetectorsConfigurationBlock.this.fStore.setValue(string2, bl);
            }
        });
        return button;
    }

    private Control[] addTextField(Composite composite, String string, final String string2, int n, int n2, PixelConverter pixelConverter) {
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n2;
        label.setLayoutData((Object)gridData);
        final Text text = new Text(composite, 2052);
        gridData = new GridData(32);
        gridData.widthHint = pixelConverter.convertWidthInCharsToPixels(n + 1);
        text.setLayoutData((Object)gridData);
        text.setTextLimit(n);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = text.getText();
                if (string2 != null) {
                    HyperlinkDetectorsConfigurationBlock.this.fStore.setValue(string2, string);
                }
            }
        });
        return new Control[]{label, text};
    }

    private Object[] getCheckedItems() {
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        int n = 0;
        while (n < this.fListModel.length) {
            if (!this.fStore.getBoolean(this.fListModel[n].id)) {
                arrayList.add(this.fListModel[n]);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    @Override
    public boolean canPerformOk() {
        return true;
    }

    @Override
    public void performOk() {
        this.fStore.setValue("hyperlinkKeyModifierMask", HyperlinkDetectorsConfigurationBlock.computeStateMask(this.fHyperlinkKeyModifierText.getText()));
    }

    @Override
    public void performDefaults() {
        this.fStore.loadDefaults();
        this.initialize();
    }

    private void handleListSelection() {
        ListItem listItem = this.getSelectedItem();
        if (listItem == null) {
            this.fHyperlinkKeyModifierText.setEnabled(false);
            return;
        }
        this.fHyperlinkKeyModifierText.setEnabled(this.fHyperlinkDetectorsViewer.getChecked((Object)listItem));
        String string = listItem.modifierKeys;
        if (string == null) {
            string = this.fHyperlinkDefaultKeyModifierText.getText();
        }
        this.fHyperlinkKeyModifierText.setText(string);
    }

    @Override
    public void initialize() {
        int n;
        String string = this.fStore.getString("hyperlinkKeyModifier");
        if (HyperlinkDetectorsConfigurationBlock.computeStateMask(string) == -1) {
            n = this.fStore.getInt("hyperlinkKeyModifierMask");
            if (n == -1) {
                this.fHyperlinkDefaultKeyModifierText.setText("");
            } else {
                this.fHyperlinkDefaultKeyModifierText.setText(HyperlinkDetectorsConfigurationBlock.getModifierString(n));
            }
        } else {
            this.fHyperlinkDefaultKeyModifierText.setText(string);
        }
        n = this.fStore.getBoolean("hyperlinksEnabled") ? 1 : 0;
        this.fHyperlinksEnabledCheckBox.setSelection(n != 0);
        this.fHyperlinkKeyModifierText.setEnabled(n != 0);
        this.fHyperlinkDefaultKeyModifierText.setEnabled(n != 0);
        this.fListModel = this.createListModel();
        this.fHyperlinkDetectorsViewer.setInput((Object)this.fListModel);
        this.fHyperlinkDetectorsViewer.setAllChecked(false);
        this.fHyperlinkDetectorsViewer.setCheckedElements(this.getCheckedItems());
        this.fHyperlinkDetectorsViewer.getTable().setEnabled(n != 0);
        this.fHyperlinkKeyModifierText.setText("");
        this.handleListSelection();
    }

    private ListItem[] createListModel() {
        ListItem[] listItemArray;
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        int n = 0;
        while (n < this.fHyperlinkDetectorDescriptors.length) {
            listItemArray = this.fHyperlinkDetectorDescriptors[n];
            HyperlinkDetectorTargetDescriptor hyperlinkDetectorTargetDescriptor = listItemArray.getTarget();
            int n2 = this.fStore.getInt(String.valueOf(listItemArray.getId()) + "_stateMask");
            String string = HyperlinkDetectorsConfigurationBlock.getModifierString(n2);
            arrayList.add(new ListItem(listItemArray.getId(), listItemArray.getName(), hyperlinkDetectorTargetDescriptor.getName(), string));
            ++n;
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object2 instanceof ListItem)) {
                    return -1;
                }
                if (!(object instanceof ListItem)) {
                    return 1;
                }
                String string = ((ListItem)object).name;
                String string2 = ((ListItem)object2).name;
                return Collator.getInstance().compare(string, string2);
            }
        };
        Collections.sort(arrayList, comparator);
        listItemArray = new ListItem[arrayList.size()];
        arrayList.toArray(listItemArray);
        return listItemArray;
    }

    private ListItem getSelectedItem() {
        return (ListItem)((IStructuredSelection)this.fHyperlinkDetectorsViewer.getSelection()).getFirstElement();
    }

    private void handleHyperlinkKeyModifierModified() {
        String string = this.fHyperlinkKeyModifierText.getText();
        int n = HyperlinkDetectorsConfigurationBlock.computeStateMask(string);
        if (this.fHyperlinksEnabledCheckBox.getSelection() && (n == -1 || (n & 0x20000) != 0)) {
            this.fHyperlinkKeyModifierStatus = n == -1 ? new StatusInfo(4, NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_error_modifierIsNotValid, string)) : new StatusInfo(4, TextEditorMessages.HyperlinkKeyModifier_error_shiftIsDisabled);
            this.applyToStatusLine(this.getHyperlinkKeyModifierStatus());
            this.fPreferencePage.setValid(this.getHyperlinkKeyModifierStatus().isOK());
        } else {
            ListItem listItem = this.getSelectedItem();
            if (listItem != null) {
                if (listItem.modifierKeys != null || !string.equalsIgnoreCase(this.fHyperlinkDefaultKeyModifierText.getText())) {
                    listItem.modifierKeys = string;
                }
                this.fHyperlinkDetectorsViewer.refresh((Object)this.getSelectedItem());
                this.fStore.setValue(String.valueOf(listItem.id) + "_stateMask", n);
            }
            this.fHyperlinkKeyModifierStatus = new StatusInfo();
            this.fPreferencePage.setValid(true);
            this.applyToStatusLine(this.fHyperlinkKeyModifierStatus);
        }
    }

    private void handleHyperlinkDefaultKeyModifierModified() {
        String string = this.fHyperlinkDefaultKeyModifierText.getText();
        int n = HyperlinkDetectorsConfigurationBlock.computeStateMask(string);
        if (this.fHyperlinksEnabledCheckBox.getSelection() && (n == -1 || (n & 0x20000) != 0)) {
            this.fHyperlinkKeyModifierStatus = n == -1 ? new StatusInfo(4, NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_error_modifierIsNotValid, string)) : new StatusInfo(4, TextEditorMessages.HyperlinkKeyModifier_error_shiftIsDisabled);
            this.applyToStatusLine(this.getHyperlinkKeyModifierStatus());
            this.fPreferencePage.setValid(this.getHyperlinkKeyModifierStatus().isOK());
        } else {
            this.fStore.setValue("hyperlinkKeyModifier", string);
            this.fHyperlinkKeyModifierStatus = new StatusInfo();
            this.fPreferencePage.setValid(true);
            this.applyToStatusLine(this.fHyperlinkKeyModifierStatus);
            this.fHyperlinkDetectorsViewer.refresh();
            this.handleListSelection();
        }
    }

    private IStatus getHyperlinkKeyModifierStatus() {
        if (this.fHyperlinkKeyModifierStatus == null) {
            this.fHyperlinkKeyModifierStatus = new StatusInfo();
        }
        return this.fHyperlinkKeyModifierStatus;
    }

    private static final int computeStateMask(String string) {
        if (string == null) {
            return -1;
        }
        if (string.length() == 0) {
            return 0;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;.:+-* ");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = HyperlinkDetectorsConfigurationBlock.findLocalizedModifier(stringTokenizer.nextToken());
            if (n2 == 0 || (n & n2) == n2) {
                return -1;
            }
            n |= n2;
        }
        return n;
    }

    private static final int findLocalizedModifier(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    private static final String getModifierString(int n) {
        if (n == -1) {
            return null;
        }
        String string = "";
        if ((n & 0x40000) == 262144) {
            string = HyperlinkDetectorsConfigurationBlock.appendModifierString(string, 262144);
        }
        if ((n & 0x10000) == 65536) {
            string = HyperlinkDetectorsConfigurationBlock.appendModifierString(string, 65536);
        }
        if ((n & 0x20000) == 131072) {
            string = HyperlinkDetectorsConfigurationBlock.appendModifierString(string, 131072);
        }
        if ((n & 0x400000) == 0x400000) {
            string = HyperlinkDetectorsConfigurationBlock.appendModifierString(string, 0x400000);
        }
        return string;
    }

    private static final String appendModifierString(String string, int n) {
        if (string == null) {
            string = "";
        }
        String string2 = Action.findModifierString((int)n);
        if (string.length() == 0) {
            return string2;
        }
        return NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_concatModifierStrings, new String[]{string, string2});
    }

    private void applyToStatusLine(IStatus iStatus) {
        String string = iStatus.getMessage();
        switch (iStatus.getSeverity()) {
            case 0: {
                this.fPreferencePage.setMessage(string, 0);
                this.fPreferencePage.setErrorMessage(null);
                break;
            }
            case 2: {
                this.fPreferencePage.setMessage(string, 2);
                this.fPreferencePage.setErrorMessage(null);
                break;
            }
            case 1: {
                this.fPreferencePage.setMessage(string, 1);
                this.fPreferencePage.setErrorMessage(null);
                break;
            }
            default: {
                if (string.length() == 0) {
                    string = null;
                }
                this.fPreferencePage.setMessage(null);
                this.fPreferencePage.setErrorMessage(string);
            }
        }
    }

    @Override
    public void dispose() {
    }

    private static final class ItemContentProvider
    implements IStructuredContentProvider {
        private ItemContentProvider() {
        }

        public Object[] getElements(Object object) {
            return (ListItem[])object;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private final class ItemLabelProvider
    implements ITableLabelProvider {
        private ItemLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((ListItem)object).name;
                }
                case 1: {
                    String string = ((ListItem)object).modifierKeys;
                    if (string == null) {
                        return HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.getText();
                    }
                    return string;
                }
                case 2: {
                    return ((ListItem)object).targetName;
                }
            }
            Assert.isLegal((boolean)false);
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private static final class ListItem {
        final String id;
        final String name;
        final String targetName;
        String modifierKeys = "";

        ListItem(String string, String string2, String string3, String string4) {
            this.id = string;
            this.name = string2;
            this.targetName = string3;
            this.modifierKeys = string4;
        }
    }
}

