/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditorPreferenceConstants;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class EditorsPluginPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore iPreferenceStore = EditorsPlugin.getDefault().getPreferenceStore();
        TextEditorPreferenceConstants.initializeDefaultValues(iPreferenceStore);
        this.migrateOverviewRulerPreference(iPreferenceStore);
    }

    public static void setThemeBasedPreferences(IPreferenceStore iPreferenceStore, boolean bl) {
        ColorRegistry colorRegistry = null;
        if (PlatformUI.isWorkbenchRunning()) {
            colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        }
        EditorsPluginPreferenceInitializer.setDefault(iPreferenceStore, "currentLineColor", EditorsPluginPreferenceInitializer.findRGB(colorRegistry, "org.eclipse.ui.editors.currentLineColor", new RGB(232, 242, 254)), bl);
        EditorsPluginPreferenceInitializer.setDefault(iPreferenceStore, "printMarginColor", EditorsPluginPreferenceInitializer.findRGB(colorRegistry, "org.eclipse.ui.editors.printMarginColor", new RGB(176, 180, 185)), bl);
        EditorsPluginPreferenceInitializer.setDefault(iPreferenceStore, "lineNumberColor", EditorsPluginPreferenceInitializer.findRGB(colorRegistry, "org.eclipse.ui.editors.lineNumberRulerColor", new RGB(120, 120, 120)), bl);
        EditorsPluginPreferenceInitializer.setDefault(iPreferenceStore, "AbstractTextEditor.Color.Background", EditorsPluginPreferenceInitializer.findRGB(colorRegistry, "org.eclipse.ui.editors.backgroundColor", new RGB(255, 255, 255)), bl);
        EditorsPluginPreferenceInitializer.setDefault(iPreferenceStore, "AbstractTextEditor.Color.Foreground", EditorsPluginPreferenceInitializer.findRGB(colorRegistry, "org.eclipse.ui.editors.foregroundColor", new RGB(0, 0, 0)), bl);
        EditorsPluginPreferenceInitializer.setDefault(iPreferenceStore, "hyperlinkColor", EditorsPluginPreferenceInitializer.findRGB(colorRegistry, "org.eclipse.ui.editors.hyperlinkColor", new RGB(0, 0, 255)), bl);
        EditorsPluginPreferenceInitializer.setDefault(iPreferenceStore, "AbstractTextEditor.Color.FindScope", EditorsPluginPreferenceInitializer.findRGB(colorRegistry, "org.eclipse.ui.editors.findScope", new RGB(185, 176, 180)), bl);
    }

    private static void setDefault(IPreferenceStore iPreferenceStore, String string, RGB rGB, boolean bl) {
        if (!bl) {
            PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)string, (RGB)rGB);
            return;
        }
        RGB rGB2 = null;
        if (iPreferenceStore.isDefault(string)) {
            rGB2 = PreferenceConverter.getDefaultColor((IPreferenceStore)iPreferenceStore, (String)string);
        }
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)string, (RGB)rGB);
        if (rGB2 != null && !rGB2.equals((Object)rGB)) {
            iPreferenceStore.firePropertyChangeEvent(string, (Object)rGB2, (Object)rGB);
        }
    }

    private static RGB findRGB(ColorRegistry colorRegistry, String string, RGB rGB) {
        if (colorRegistry == null) {
            return rGB;
        }
        RGB rGB2 = colorRegistry.getRGB(string);
        if (rGB2 != null) {
            return rGB2;
        }
        return rGB;
    }

    private void migrateOverviewRulerPreference(IPreferenceStore iPreferenceStore) {
        String string = "overviewRuler";
        String string2 = "_migration";
        String string3 = "migrated_3.1";
        String string4 = String.valueOf(string) + string2;
        String string5 = iPreferenceStore.getString(string4);
        if (!string3.equals(string5)) {
            iPreferenceStore.putValue(string4, string3);
            if (!iPreferenceStore.getBoolean(string)) {
                iPreferenceStore.putValue(string, Boolean.TRUE.toString());
            }
        }
    }
}

