/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.HashSet;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.ConvertLineDelimitersOperation;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.editors.text.FileBufferOperationAction;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.SelectResourcesDialog;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class ConvertLineDelimitersAction
extends FileBufferOperationAction {
    private String fLabel;
    private boolean fStrictCheckIfTextLocation;

    protected ConvertLineDelimitersAction(String string, String string2) {
        super((IFileBufferOperation)new ConvertLineDelimitersOperation(string));
        this.setText(ConvertLineDelimitersAction.constructLabel(string2, string, System.getProperty("line.separator")));
        this.fLabel = Action.removeMnemonics((String)string2);
    }

    private static String constructLabel(String string, String string2, String string3) {
        if (string2.equals(string3)) {
            return String.valueOf(string) + TextEditorMessages.ConvertLineDelimitersAction_default_label;
        }
        return string;
    }

    @Override
    protected boolean isAcceptableLocation(IPath iPath) {
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        return iPath != null && iTextFileBufferManager.isTextFileLocation(iPath, this.fStrictCheckIfTextLocation);
    }

    @Override
    public void selectionChanged(IAction iAction, ISelection iSelection) {
        super.selectionChanged(iAction, iSelection);
        this.fStrictCheckIfTextLocation = !(iSelection instanceof ITextSelection);
    }

    @Override
    protected IFile[] collectFiles(IResource[] iResourceArray) {
        this.fStrictCheckIfTextLocation = this.fStrictCheckIfTextLocation || iResourceArray.length != 1 || iResourceArray[0].getType() != 1;
        IFile[] iFileArray = super.collectFiles(iResourceArray);
        iFileArray = this.filterUnacceptableFiles(iFileArray);
        if (this.containsOnlyFiles(iResourceArray)) {
            return iFileArray;
        }
        SelectResourcesDialog.IFilter iFilter = new SelectResourcesDialog.IFilter(){

            @Override
            public boolean accept(IResource iResource) {
                return iResource != null && ConvertLineDelimitersAction.this.isAcceptableLocation(iResource.getFullPath());
            }
        };
        SelectResourcesDialog selectResourcesDialog = new SelectResourcesDialog(this.getShell(), NLSUtility.format(TextEditorMessages.ConvertLineDelimitersAction_dialog_title, this.fLabel), TextEditorMessages.ConvertLineDelimitersAction_dialog_description, iFilter);
        selectResourcesDialog.setInput(iResourceArray);
        int n = selectResourcesDialog.open();
        if (n == 0) {
            IResource[] iResourceArray2 = selectResourcesDialog.getSelectedResources();
            return super.collectFiles(iResourceArray2);
        }
        return null;
    }

    private boolean containsOnlyFiles(IResource[] iResourceArray) {
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if ((1 & iResource.getType()) == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private IFile[] filterUnacceptableFiles(IFile[] iFileArray) {
        HashSet<IFile> hashSet = new HashSet<IFile>();
        int n = 0;
        while (n < iFileArray.length) {
            IFile iFile = iFileArray[n];
            if (this.isAcceptableLocation(iFile.getFullPath())) {
                hashSet.add(iFile);
            }
            ++n;
        }
        return hashSet.toArray(new IFile[hashSet.size()]);
    }
}

