/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

class AnnotationsConfigurationBlock
implements IPreferenceConfigurationBlock {
    static final String[] HIGHLIGHT = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_HIGHLIGHT, "not used"};
    static final String[] UNDERLINE = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_UNDERLINE, "UNDERLINE"};
    static final String[] BOX = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_BOX, "BOX"};
    static final String[] DASHED_BOX = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_DASHED_BOX, "DASHED_BOX"};
    static final String[] IBEAM = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_IBEAM, "IBEAM"};
    static final String[] SQUIGGLES = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_SQUIGGLES, "SQUIGGLES"};
    static final String[] PROBLEM_UNDERLINE = new String[]{TextEditorMessages.AnnotationsConfigurationBlock_PROBLEM_UNDERLINE, "PROBLEM_UNDERLINE"};
    private OverlayPreferenceStore fStore;
    private ColorSelector fAnnotationForegroundColorEditor;
    private Button fShowInTextCheckBox;
    private Button fShowInOverviewRulerCheckBox;
    private Button fShowInVerticalRulerCheckBox;
    private Button fIsNextPreviousTargetCheckBox;
    private StructuredViewer fAnnotationTypeViewer;
    private final ListItem[] fListModel;
    private ComboViewer fDecorationViewer;
    private final Set fImageKeys = new HashSet();

    public AnnotationsConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)overlayPreferenceStore);
        MarkerAnnotationPreferences markerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.fStore = overlayPreferenceStore;
        this.fStore.addKeys(this.createOverlayStoreKeys(markerAnnotationPreferences));
        this.fListModel = this.createAnnotationTypeListModel(markerAnnotationPreferences);
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(MarkerAnnotationPreferences markerAnnotationPreferences) {
        AnnotationPreference annotationPreference2;
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        for (AnnotationPreference annotationPreference2 : markerAnnotationPreferences.getAnnotationPreferences()) {
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, annotationPreference2.getColorPreferenceKey()));
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, annotationPreference2.getTextPreferenceKey()));
            if (annotationPreference2.getHighlightPreferenceKey() != null) {
                arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, annotationPreference2.getHighlightPreferenceKey()));
            }
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, annotationPreference2.getOverviewRulerPreferenceKey()));
            if (annotationPreference2.getVerticalRulerPreferenceKey() != null) {
                arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, annotationPreference2.getVerticalRulerPreferenceKey()));
            }
            if (annotationPreference2.getTextStylePreferenceKey() != null) {
                arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, annotationPreference2.getTextStylePreferenceKey()));
            }
            if (annotationPreference2.getIsGoToNextNavigationTargetKey() == null) continue;
            arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, annotationPreference2.getIsGoToNextNavigationTargetKey()));
        }
        annotationPreference2 = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray((T[])annotationPreference2);
        return annotationPreference2;
    }

    @Override
    public Control createControl(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(TextEditorMessages.AnnotationsConfigurationBlock_annotationPresentationOptions);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(1296);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        this.fAnnotationTypeViewer = new TableViewer(composite3, 68100);
        this.fAnnotationTypeViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.fAnnotationTypeViewer.setContentProvider((IContentProvider)new ItemContentProvider());
        gridData = new GridData(1, 1, false, false);
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
        this.fAnnotationTypeViewer.getControl().setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite3, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(1808));
        label = new Label(composite4, 16384);
        label.setText(TextEditorMessages.AnnotationsConfigurationBlock_labels_showIn);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fShowInVerticalRulerCheckBox = new Button(composite4, 32);
        this.fShowInVerticalRulerCheckBox.setText(TextEditorMessages.AnnotationsConfigurationBlock_showInVerticalRuler);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 20;
        this.fShowInVerticalRulerCheckBox.setLayoutData((Object)gridData);
        this.fShowInOverviewRulerCheckBox = new Button(composite4, 32);
        this.fShowInOverviewRulerCheckBox.setText(TextEditorMessages.AnnotationsConfigurationBlock_showInOverviewRuler);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 20;
        this.fShowInOverviewRulerCheckBox.setLayoutData((Object)gridData);
        this.fShowInTextCheckBox = new Button(composite4, 32);
        this.fShowInTextCheckBox.setText(TextEditorMessages.AnnotationsConfigurationBlock_showInText);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 20;
        this.fShowInTextCheckBox.setLayoutData((Object)gridData);
        this.fDecorationViewer = new ComboViewer(composite4, 8);
        this.fDecorationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fDecorationViewer.setLabelProvider((IBaseLabelProvider)new ArrayLabelProvider());
        this.fDecorationViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        this.fDecorationViewer.getControl().setLayoutData((Object)gridData);
        this.fDecorationViewer.setInput((Object)new Object[]{HIGHLIGHT, SQUIGGLES, BOX, DASHED_BOX, UNDERLINE, PROBLEM_UNDERLINE, IBEAM});
        this.fDecorationViewer.getCombo().setVisibleItemCount(this.fDecorationViewer.getCombo().getItemCount());
        label = new Label(composite4, 16384);
        label.setText(TextEditorMessages.AnnotationsConfigurationBlock_color);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalIndent = 20;
        label.setLayoutData((Object)gridData);
        this.fAnnotationForegroundColorEditor = new ColorSelector(composite4);
        Button button = this.fAnnotationForegroundColorEditor.getButton();
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        button.setLayoutData((Object)gridData);
        this.addFiller(composite4);
        this.fIsNextPreviousTargetCheckBox = new Button(composite4, 32);
        this.fIsNextPreviousTargetCheckBox.setText(TextEditorMessages.AnnotationsConfigurationBlock_isNavigationTarget);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 0;
        this.fIsNextPreviousTargetCheckBox.setLayoutData((Object)gridData);
        this.fAnnotationTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AnnotationsConfigurationBlock.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListItem listItem = AnnotationsConfigurationBlock.this.getSelectedItem();
                boolean bl = AnnotationsConfigurationBlock.this.fShowInTextCheckBox.getSelection();
                if (bl) {
                    String[] stringArray = (String[])((IStructuredSelection)AnnotationsConfigurationBlock.this.fDecorationViewer.getSelection()).getFirstElement();
                    if (HIGHLIGHT.equals(stringArray)) {
                        AnnotationsConfigurationBlock.this.fStore.setValue(listItem.highlightKey, true);
                    } else {
                        AnnotationsConfigurationBlock.this.fStore.setValue(listItem.textKey, true);
                    }
                } else {
                    if (listItem.textKey != null) {
                        AnnotationsConfigurationBlock.this.fStore.setValue(listItem.textKey, false);
                    }
                    if (listItem.highlightKey != null) {
                        AnnotationsConfigurationBlock.this.fStore.setValue(listItem.highlightKey, false);
                    }
                }
                AnnotationsConfigurationBlock.this.fStore.setValue(listItem.textKey, bl);
                AnnotationsConfigurationBlock.this.updateDecorationViewer(listItem, false);
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)listItem);
            }
        });
        this.fShowInOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListItem listItem = AnnotationsConfigurationBlock.this.getSelectedItem();
                AnnotationsConfigurationBlock.this.fStore.setValue(listItem.overviewRulerKey, AnnotationsConfigurationBlock.this.fShowInOverviewRulerCheckBox.getSelection());
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)listItem);
            }
        });
        this.fShowInVerticalRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListItem listItem = AnnotationsConfigurationBlock.this.getSelectedItem();
                AnnotationsConfigurationBlock.this.fStore.setValue(listItem.verticalRulerKey, AnnotationsConfigurationBlock.this.fShowInVerticalRulerCheckBox.getSelection());
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)listItem);
            }
        });
        this.fIsNextPreviousTargetCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListItem listItem = AnnotationsConfigurationBlock.this.getSelectedItem();
                AnnotationsConfigurationBlock.this.fStore.setValue(listItem.isNextPreviousNavigationKey, AnnotationsConfigurationBlock.this.fIsNextPreviousTargetCheckBox.getSelection());
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)listItem);
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListItem listItem = AnnotationsConfigurationBlock.this.getSelectedItem();
                PreferenceConverter.setValue((IPreferenceStore)AnnotationsConfigurationBlock.this.fStore, (String)listItem.colorKey, (RGB)AnnotationsConfigurationBlock.this.fAnnotationForegroundColorEditor.getColorValue());
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)listItem);
            }
        });
        this.fDecorationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                String[] stringArray = (String[])((IStructuredSelection)AnnotationsConfigurationBlock.this.fDecorationViewer.getSelection()).getFirstElement();
                ListItem listItem = AnnotationsConfigurationBlock.this.getSelectedItem();
                if (AnnotationsConfigurationBlock.this.fShowInTextCheckBox.getSelection()) {
                    if (HIGHLIGHT.equals(stringArray)) {
                        AnnotationsConfigurationBlock.this.fStore.setValue(listItem.highlightKey, true);
                        if (listItem.textKey != null) {
                            AnnotationsConfigurationBlock.this.fStore.setValue(listItem.textKey, false);
                            if (listItem.textStyleKey != null) {
                                AnnotationsConfigurationBlock.this.fStore.setValue(listItem.textStyleKey, "NONE");
                            }
                        }
                    } else {
                        if (listItem.highlightKey != null) {
                            AnnotationsConfigurationBlock.this.fStore.setValue(listItem.highlightKey, false);
                        }
                        if (listItem.textKey != null) {
                            AnnotationsConfigurationBlock.this.fStore.setValue(listItem.textKey, true);
                            if (listItem.textStyleKey != null) {
                                AnnotationsConfigurationBlock.this.fStore.setValue(listItem.textStyleKey, stringArray[1]);
                            }
                        }
                    }
                }
                AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.refresh((Object)listItem);
            }
        });
        composite2.layout();
        return composite2;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label label = new Label(composite, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        gridData.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gridData);
    }

    @Override
    public void applyData(Object object) {
        if (!(object instanceof String)) {
            return;
        }
        int n = 0;
        while (n < this.fListModel.length) {
            final ListItem listItem = this.fListModel[n];
            if (object.equals(listItem.label)) {
                final Control control = this.fAnnotationTypeViewer.getControl();
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        control.setFocus();
                        AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.setSelection((ISelection)new StructuredSelection((Object)listItem), true);
                    }
                });
                return;
            }
            ++n;
        }
    }

    @Override
    public boolean canPerformOk() {
        return true;
    }

    @Override
    public void performOk() {
    }

    @Override
    public void performDefaults() {
        this.fStore.loadDefaults();
        this.fAnnotationTypeViewer.refresh();
        this.handleAnnotationListSelection();
    }

    private void handleAnnotationListSelection() {
        ListItem listItem = this.getSelectedItem();
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)listItem.colorKey);
        this.fAnnotationForegroundColorEditor.setColorValue(rGB);
        boolean bl = listItem.highlightKey == null ? false : this.fStore.getBoolean(listItem.highlightKey);
        boolean bl2 = listItem.textKey == null ? false : this.fStore.getBoolean(listItem.textKey);
        this.fShowInTextCheckBox.setSelection(bl2 || bl);
        this.updateDecorationViewer(listItem, true);
        this.fShowInOverviewRulerCheckBox.setSelection(this.fStore.getBoolean(listItem.overviewRulerKey));
        if (listItem.isNextPreviousNavigationKey != null) {
            this.fIsNextPreviousTargetCheckBox.setEnabled(true);
            this.fIsNextPreviousTargetCheckBox.setSelection(this.fStore.getBoolean(listItem.isNextPreviousNavigationKey));
        } else {
            this.fIsNextPreviousTargetCheckBox.setEnabled(false);
            this.fIsNextPreviousTargetCheckBox.setSelection(false);
        }
        if (listItem.verticalRulerKey != null) {
            this.fShowInVerticalRulerCheckBox.setSelection(this.fStore.getBoolean(listItem.verticalRulerKey));
            this.fShowInVerticalRulerCheckBox.setEnabled(true);
        } else {
            this.fShowInVerticalRulerCheckBox.setSelection(true);
            this.fShowInVerticalRulerCheckBox.setEnabled(false);
        }
    }

    @Override
    public void initialize() {
        this.fAnnotationTypeViewer.setInput((Object)this.fListModel);
        this.fAnnotationTypeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AnnotationsConfigurationBlock.this.fAnnotationTypeViewer != null && !AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.getControl().isDisposed()) {
                    AnnotationsConfigurationBlock.this.fAnnotationTypeViewer.setSelection((ISelection)new StructuredSelection((Object)AnnotationsConfigurationBlock.this.fListModel[0]));
                }
            }
        });
    }

    private ListItem[] createAnnotationTypeListModel(MarkerAnnotationPreferences markerAnnotationPreferences) {
        Object object;
        Object object22;
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        for (Object object22 : markerAnnotationPreferences.getAnnotationPreferences()) {
            if (!object22.isIncludeOnPreferencePage()) continue;
            object = object22.getPreferenceLabel();
            if (this.containsMoreThanOne(markerAnnotationPreferences.getAnnotationPreferences().iterator(), (String)object)) {
                object = String.valueOf(object) + " (" + object22.getAnnotationType() + ")";
            }
            Image image = this.getImage((AnnotationPreference)object22);
            arrayList.add(new ListItem((String)object, image, object22.getColorPreferenceKey(), object22.getTextPreferenceKey(), object22.getOverviewRulerPreferenceKey(), object22.getHighlightPreferenceKey(), object22.getVerticalRulerPreferenceKey(), object22.getTextStylePreferenceKey(), object22.getIsGoToNextNavigationTargetKey()));
        }
        object22 = new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object2 instanceof ListItem)) {
                    return -1;
                }
                if (!(object instanceof ListItem)) {
                    return 1;
                }
                String string = ((ListItem)object).label;
                String string2 = ((ListItem)object2).label;
                return Collator.getInstance().compare(string, string2);
            }
        };
        Collections.sort(arrayList, object22);
        object = new ListItem[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private Image getImage(AnnotationPreference annotationPreference) {
        ISharedImages iSharedImages;
        String string;
        String string2;
        ImageDescriptor imageDescriptor;
        AnnotationPreference annotationPreference2;
        ImageRegistry imageRegistry = EditorsPlugin.getDefault().getImageRegistry();
        String string3 = (String)annotationPreference.getAnnotationType();
        if (string3 == null) {
            return null;
        }
        String string4 = String.valueOf(string3) + "__AnnotationsConfigurationBlock_Image";
        Image image = imageRegistry.get(string4);
        if (image != null) {
            return image;
        }
        image = imageRegistry.get(string3);
        if (image == null) {
            annotationPreference2 = EditorsPlugin.getDefault().getAnnotationPreferenceLookup().getAnnotationPreference(string3);
            imageDescriptor = annotationPreference2.getImageDescriptor();
            if (imageDescriptor != null) {
                imageRegistry.put(string3, imageDescriptor);
                image = imageRegistry.get(string3);
            } else {
                string2 = annotationPreference.getSymbolicImageName();
                if (string2 != null && (string = DefaultMarkerAnnotationAccess.getSharedImageName(string2)) != null) {
                    iSharedImages = PlatformUI.getWorkbench().getSharedImages();
                    image = iSharedImages.getImage(string);
                }
            }
        }
        if (image == null) {
            return null;
        }
        annotationPreference2 = image.getImageData();
        if (annotationPreference2.height > 16 || annotationPreference2.width > 16) {
            imageDescriptor = new Image((Device)Display.getCurrent(), annotationPreference2.scaledTo(16, 16));
        } else {
            if (annotationPreference2.height == 16 && annotationPreference2.width == 16) {
                return image;
            }
            string2 = annotationPreference2.getTransparencyMask();
            string = new ImageData(16, 16, annotationPreference2.depth, annotationPreference2.palette);
            iSharedImages = new ImageData(16, 16, ((ImageData)string2).depth, ((ImageData)string2).palette);
            int n = Math.max(0, (16 - annotationPreference2.width) / 2);
            int n2 = Math.max(0, (16 - annotationPreference2.height) / 2);
            int n3 = 0;
            while (n3 < 16) {
                int n4 = 0;
                while (n4 < 16) {
                    if (n3 >= n2 && n4 >= n && n3 < n2 + annotationPreference2.height && n4 < n + annotationPreference2.width) {
                        string.setPixel(n4, n3, annotationPreference2.getPixel(n4 - n, n3 - n2));
                        iSharedImages.setPixel(n4, n3, string2.getPixel(n4 - n, n3 - n2));
                    }
                    ++n4;
                }
                ++n3;
            }
            imageDescriptor = new Image((Device)Display.getCurrent(), (ImageData)string, (ImageData)iSharedImages);
        }
        this.fImageKeys.add(string4);
        imageRegistry.put(string4, (Image)imageDescriptor);
        return imageDescriptor;
    }

    private boolean containsMoreThanOne(Iterator iterator, String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (iterator.hasNext()) {
            if (string.equals(((AnnotationPreference)iterator.next()).getPreferenceLabel())) {
                ++n;
            }
            if (n != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        ImageRegistry imageRegistry = EditorsPlugin.getDefault().getImageRegistry();
        for (String string : this.fImageKeys) {
            imageRegistry.remove(string);
        }
        this.fImageKeys.clear();
    }

    private ListItem getSelectedItem() {
        return (ListItem)((IStructuredSelection)this.fAnnotationTypeViewer.getSelection()).getFirstElement();
    }

    private void updateDecorationViewer(ListItem listItem, boolean bl) {
        boolean bl2 = this.fShowInTextCheckBox.getSelection() && (listItem.highlightKey != null || listItem.textStyleKey != null);
        this.fDecorationViewer.getControl().setEnabled(bl2);
        if (bl) {
            String[] stringArray = null;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            if (listItem.highlightKey != null) {
                arrayList.add(HIGHLIGHT);
                if (this.fStore.getBoolean(listItem.highlightKey)) {
                    stringArray = HIGHLIGHT;
                }
            }
            arrayList.add(SQUIGGLES);
            if (listItem.textStyleKey != null) {
                arrayList.add(UNDERLINE);
                arrayList.add(PROBLEM_UNDERLINE);
                arrayList.add(BOX);
                arrayList.add(DASHED_BOX);
                arrayList.add(IBEAM);
            }
            if (stringArray == null) {
                String string = listItem.textStyleKey == null ? SQUIGGLES[1] : this.fStore.getString(listItem.textStyleKey);
                for (String[] stringArray2 : arrayList) {
                    if (!stringArray2[1].equals(string)) continue;
                    stringArray = stringArray2;
                    break;
                }
            }
            this.fDecorationViewer.setInput((Object)arrayList.toArray(new Object[arrayList.size()]));
            if (stringArray != null) {
                this.fDecorationViewer.setSelection((ISelection)new StructuredSelection((Object)stringArray), true);
            }
        }
    }

    private static class ArrayLabelProvider
    extends LabelProvider {
        private ArrayLabelProvider() {
        }

        public String getText(Object object) {
            return ((String[])object)[0].toString();
        }
    }

    private static final class ItemContentProvider
    implements IStructuredContentProvider {
        private ItemContentProvider() {
        }

        public Object[] getElements(Object object) {
            return (ListItem[])object;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private final class ItemLabelProvider
    extends LabelProvider {
        private ItemLabelProvider() {
        }

        public String getText(Object object) {
            return ((ListItem)object).label;
        }

        public Image getImage(Object object) {
            ListItem listItem = (ListItem)object;
            return listItem.image;
        }
    }

    private static final class ListItem {
        final String label;
        final Image image;
        final String colorKey;
        final String highlightKey;
        final String overviewRulerKey;
        final String textStyleKey;
        final String textKey;
        final String verticalRulerKey;
        final String isNextPreviousNavigationKey;

        ListItem(String string, Image image, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            this.label = string;
            this.image = image;
            this.colorKey = string2;
            this.highlightKey = string5;
            this.overviewRulerKey = string4;
            this.textKey = string3;
            this.textStyleKey = string7;
            this.verticalRulerKey = string6;
            this.isNextPreviousNavigationKey = string8;
        }
    }
}

