/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class AccessibilityPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private OverlayPreferenceStore fOverlayStore;
    private boolean fFieldsInitialized = false;
    private List fInitializers = new ArrayList();
    private InitializerFactory fInitializerFactory = new InitializerFactory();
    private Control fContents;
    private ArrayList fMasterSlaveListeners = new ArrayList();

    public AccessibilityPreferencePage() {
        this.setDescription(TextEditorMessages.AccessibilityPreferencePage_accessibility_title);
        this.setPreferenceStore(EditorsPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    protected Label createDescriptionLabel(Composite composite) {
        return null;
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Accessibility.UseCustomCarets"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Accessibility.WideCaret"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "quickdiff.characterMode"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "Accessibility.UseSaturatedColors"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return new OverlayPreferenceStore(this.getPreferenceStore(), overlayKeyArray);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.accessibility_preference_page_context");
    }

    private Control createAppearancePage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        String string = TextEditorMessages.TextEditorPreferencePage_accessibility_disableCustomCarets;
        Preference preference = new Preference("AbstractTextEditor.Accessibility.UseCustomCarets", string, null);
        Button button = this.addCheckBox(composite2, preference, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorPreferencePage_accessibility_wideCaret;
        Preference preference2 = new Preference("AbstractTextEditor.Accessibility.WideCaret", string, null);
        Button button2 = this.addCheckBox(composite2, preference2, new BooleanDomain(), 0);
        this.createDependency(button, preference, new Control[]{button2});
        string = TextEditorMessages.QuickDiffConfigurationBlock_characterMode;
        Preference preference3 = new Preference("quickdiff.characterMode", string, null);
        this.addCheckBox(composite2, preference3, new BooleanDomain(), 0);
        string = TextEditorMessages.TextEditorPreferencePage_accessibility_useSaturatedColorsInOverviewRuler;
        Preference preference4 = new Preference("Accessibility.UseSaturatedColors", string, null);
        this.addCheckBox(composite2, preference4, new BooleanDomain(), 0);
        return composite2;
    }

    protected Control createContents(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.fContents = this.createAppearancePage(composite);
        this.initialize();
        Dialog.applyDialogFont((Control)this.fContents);
        return this.fContents;
    }

    private void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        for (Initializer initializer : this.fInitializers) {
            initializer.initialize();
        }
        this.fFieldsInitialized = true;
        this.updateStatus(new StatusInfo());
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        for (SelectionListener selectionListener : this.fMasterSlaveListeners) {
            selectionListener.widgetSelected(null);
        }
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Button addCheckBox(Composite composite, final Preference preference, final Domain domain, int n) {
        final Button button = new Button(composite, 32);
        button.setText(preference.getName());
        button.setToolTipText(preference.getDescription());
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                IStatus iStatus = domain.validate(bl);
                if (!iStatus.matches(4)) {
                    AccessibilityPreferencePage.this.fOverlayStore.setValue(preference.getKey(), bl);
                }
                AccessibilityPreferencePage.this.updateStatus(iStatus);
            }
        });
        this.fInitializers.add(this.fInitializerFactory.create(preference, button));
        return button;
    }

    private void createDependency(final Button button, Preference preference, final Control[] controlArray) {
        AccessibilityPreferencePage.indent(controlArray[0]);
        boolean bl = this.fOverlayStore.getBoolean(preference.getKey());
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = button.getSelection();
                int n = 0;
                while (n < controlArray.length) {
                    controlArray[n].setEnabled(bl);
                    ++n;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        button.addSelectionListener(selectionListener);
        this.fMasterSlaveListeners.add(selectionListener);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    void updateStatus(IStatus iStatus) {
        if (!this.fFieldsInitialized) {
            return;
        }
        this.setValid(!iStatus.matches(4));
        this.applyToStatusLine((DialogPage)this, iStatus);
    }

    public void applyToStatusLine(DialogPage dialogPage, IStatus iStatus) {
        String string = iStatus.getMessage();
        switch (iStatus.getSeverity()) {
            case 0: {
                dialogPage.setMessage(string, 0);
                dialogPage.setErrorMessage(null);
                break;
            }
            case 2: {
                dialogPage.setMessage(string, 2);
                dialogPage.setErrorMessage(null);
                break;
            }
            case 1: {
                dialogPage.setMessage(string, 1);
                dialogPage.setErrorMessage(null);
                break;
            }
            default: {
                if (string.length() == 0) {
                    string = null;
                }
                dialogPage.setMessage(null);
                dialogPage.setErrorMessage(string);
            }
        }
    }

    static class BooleanDomain
    extends Domain {
        BooleanDomain() {
        }

        @Override
        public IStatus validate(Object object) {
            StatusInfo statusInfo = new StatusInfo();
            if (object instanceof String && ((String)object).length() == 0) {
                statusInfo.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return statusInfo;
            }
            try {
                this.parseBoolean(object);
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
            }
            return statusInfo;
        }

        private boolean parseBoolean(Object object) throws NumberFormatException {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                if (Boolean.TRUE.toString().equalsIgnoreCase((String)object)) {
                    return true;
                }
                if (Boolean.FALSE.toString().equalsIgnoreCase((String)object)) {
                    return false;
                }
            }
            throw new NumberFormatException(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
        }
    }

    static abstract class Domain {
        Domain() {
        }

        public abstract IStatus validate(Object var1);

        protected int parseInteger(Object object) throws NumberFormatException {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            throw new NumberFormatException(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
        }
    }

    static class EnumeratedDomain
    extends Domain {
        private final List fItems = new ArrayList();
        private final Set fValueSet = new HashSet();

        EnumeratedDomain() {
        }

        public void addValue(EnumValue enumValue) {
            if (this.fValueSet.contains(enumValue)) {
                this.fItems.remove(enumValue);
            }
            this.fItems.add(enumValue);
            this.fValueSet.add(enumValue);
        }

        public int getIndex(EnumValue enumValue) {
            int n = 0;
            for (EnumValue enumValue2 : this.fItems) {
                if (enumValue2.equals(enumValue)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public EnumValue getValueByIndex(int n) {
            if (n >= 0 && this.fItems.size() > n) {
                return (EnumValue)this.fItems.get(n);
            }
            return null;
        }

        public EnumValue getValueByInteger(int n) {
            for (EnumValue enumValue : this.fItems) {
                if (enumValue.getIntValue() != n) continue;
                return enumValue;
            }
            return null;
        }

        public void addValue(int n) {
            this.addValue(new EnumValue(n));
        }

        public void addRange(int n, int n2) {
            while (n <= n2) {
                this.addValue(n++);
            }
        }

        @Override
        public IStatus validate(Object object) {
            StatusInfo statusInfo = new StatusInfo();
            if (object instanceof String && ((String)object).length() == 0) {
                statusInfo.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return statusInfo;
            }
            try {
                EnumValue enumValue = this.parseEnumValue(object);
                if (!this.fValueSet.contains(enumValue)) {
                    statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidRange, new String[]{this.getValueByIndex(0).getLabel(), this.getValueByIndex(this.fItems.size() - 1).getLabel()}));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
            }
            return statusInfo;
        }

        private EnumValue parseEnumValue(Object object) {
            if (object instanceof EnumValue) {
                return (EnumValue)object;
            }
            int n = this.parseInteger(object);
            return this.getValueByInteger(n);
        }

        public static final class EnumValue {
            private final int fValue;
            private final String fName;

            public EnumValue(int n) {
                this(n, null);
            }

            public EnumValue(int n, String string) {
                this.fValue = n;
                this.fName = string;
            }

            public String getLabel() {
                return this.fName == null ? String.valueOf(this.fValue) : this.fName;
            }

            public int getIntValue() {
                return this.fValue;
            }

            public final int hashCode() {
                return this.getIntValue();
            }

            public boolean equals(Object object) {
                if (object instanceof EnumValue) {
                    return ((EnumValue)object).getIntValue() == this.fValue;
                }
                return false;
            }
        }
    }

    private abstract class Initializer {
        protected final Preference fPreference;

        protected Initializer(Preference preference) {
            this.fPreference = preference;
        }

        public abstract void initialize();
    }

    public final class InitializerFactory {
        public Initializer create(Preference preference, Text text) {
            return new TextInitializer(preference, text);
        }

        public Initializer create(Preference preference, Button button) {
            return new CheckboxInitializer(preference, button);
        }

        public Initializer create(Preference preference, Combo combo, EnumeratedDomain enumeratedDomain) {
            return new ComboInitializer(preference, combo, enumeratedDomain);
        }

        private class CheckboxInitializer
        extends Initializer {
            private final Button fControl;

            public CheckboxInitializer(Preference preference, Button button) {
                super(preference);
                this.fControl = button;
            }

            @Override
            public void initialize() {
                boolean bl = AccessibilityPreferencePage.this.fOverlayStore.getBoolean(this.fPreference.getKey());
                this.fControl.setSelection(bl);
            }
        }

        private class ComboInitializer
        extends Initializer {
            private final Combo fControl;
            private final EnumeratedDomain fDomain;

            public ComboInitializer(Preference preference, Combo combo, EnumeratedDomain enumeratedDomain) {
                super(preference);
                this.fControl = combo;
                this.fDomain = enumeratedDomain;
            }

            @Override
            public void initialize() {
                int n;
                int n2 = AccessibilityPreferencePage.this.fOverlayStore.getInt(this.fPreference.getKey());
                EnumeratedDomain.EnumValue enumValue = this.fDomain.getValueByInteger(n2);
                if (enumValue != null && (n = this.fDomain.getIndex(enumValue)) >= 0) {
                    this.fControl.select(n);
                }
            }
        }

        private class TextInitializer
        extends Initializer {
            private final Text fText;

            public TextInitializer(Preference preference, Text text) {
                super(preference);
                this.fText = text;
            }

            @Override
            public void initialize() {
                String string = AccessibilityPreferencePage.this.fOverlayStore.getString(this.fPreference.getKey());
                this.fText.setText(string);
            }
        }
    }

    static class IntegerDomain
    extends Domain {
        private final int fMax;
        private final int fMin;

        public IntegerDomain(int n, int n2) {
            Assert.isLegal((n2 >= n ? 1 : 0) != 0);
            this.fMax = n2;
            this.fMin = n;
        }

        @Override
        public IStatus validate(Object object) {
            StatusInfo statusInfo = new StatusInfo();
            if (object instanceof String && ((String)object).length() == 0) {
                statusInfo.setError(TextEditorMessages.TextEditorPreferencePage_emptyInput);
                return statusInfo;
            }
            try {
                int n = this.parseInteger(object);
                if (!this.rangeCheck(n)) {
                    statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(n)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                statusInfo.setError(NLSUtility.format(TextEditorMessages.TextEditorPreferencePage_invalidInput, String.valueOf(object)));
            }
            return statusInfo;
        }

        protected boolean rangeCheck(int n) {
            return n >= this.fMin && n <= this.fMax;
        }
    }

    private static class Preference {
        private String fKey;
        private String fName;
        private String fDescription;

        public Preference(String string, String string2, String string3) {
            Assert.isNotNull((Object)string);
            Assert.isNotNull((Object)string2);
            this.fKey = string;
            this.fName = string2;
            this.fDescription = string3;
        }

        public final String getKey() {
            return this.fKey;
        }

        public final String getName() {
            return this.fName;
        }

        public final String getDescription() {
            return this.fDescription;
        }
    }
}

