/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RevertSelectionAction
extends QuickDiffRestoreAction {
    private int fStartLine;
    private int fEndLine;

    public RevertSelectionAction(ITextEditor iTextEditor, boolean bl) {
        super(QuickDiffMessages.getResourceBundle(), "RevertSelectionAction.", iTextEditor, bl);
    }

    @Override
    public boolean computeEnablement() {
        if (!super.computeEnablement()) {
            return false;
        }
        ITextSelection iTextSelection = this.getSelection();
        if (iTextSelection == null) {
            return false;
        }
        this.fStartLine = iTextSelection.getStartLine();
        this.fEndLine = iTextSelection.getEndLine();
        int n = this.getLastLine();
        if (n == -1 || n < this.fStartLine || n > this.fEndLine + 1) {
            return false;
        }
        ILineDiffer iLineDiffer = this.getDiffer();
        if (iLineDiffer == null) {
            return false;
        }
        if (this.fEndLine > this.fStartLine) {
            int n2 = this.fStartLine;
            while (n2 <= this.fEndLine) {
                ILineDiffInfo iLineDiffInfo = iLineDiffer.getLineInfo(n2);
                if (iLineDiffInfo != null && iLineDiffInfo.hasChanges()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer iLineDiffer = this.getDiffer();
        if (iLineDiffer != null) {
            try {
                iLineDiffer.revertSelection(this.fStartLine, this.fEndLine - this.fStartLine + 1);
            }
            catch (BadLocationException badLocationException) {
                this.setStatus(badLocationException.getMessage());
            }
        }
    }
}

